/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5455;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.recipe.ManaInfusionRecipe;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class ManaPoolRecipeCategory
implements IRecipeCategory<ManaInfusionRecipe> {
    public static final RecipeType<ManaInfusionRecipe> TYPE = RecipeType.create((String)"botania", (String)"mana_pool", ManaInfusionRecipe.class);
    private final IDrawable background;
    private final class_2561 localizedName;
    private final IDrawable overlay;
    private final IDrawable icon;
    private final class_1799 renderStack = new class_1799((class_1935)BotaniaBlocks.manaPool);

    public ManaPoolRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(142, 55);
        this.localizedName = class_2561.method_43471((String)"botania.nei.manaPool");
        this.overlay = guiHelper.createDrawable(ResourceLocationHelper.prefix("textures/gui/pure_daisy_overlay.png"), 0, 0, 64, 46);
        ItemNBTHelper.setBoolean(this.renderStack, "RenderFull", true);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)this.renderStack.method_7972());
    }

    @NotNull
    public RecipeType<ManaInfusionRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public class_2561 getTitle() {
        return this.localizedName;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(ManaInfusionRecipe recipe, @NotNull IRecipeSlotsView slotsView, @NotNull class_332 gui, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        this.overlay.draw(gui, 40, 0);
        HUDHandler.renderManaBar(gui, 20, 50, 255, 0.75f, recipe.getManaToConsume(), 100000);
        RenderSystem.disableBlend();
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull ManaInfusionRecipe recipe, @NotNull IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.INPUT, 32, 12).addIngredients((class_1856)recipe.method_8117().get(0));
        StateIngredient catalyst = recipe.getRecipeCatalyst();
        if (catalyst != null) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, 12, 12).addItemStacks(catalyst.getDisplayedStacks())).addTooltipCallback((view, tooltip) -> tooltip.addAll(catalyst.descriptionTooltip()));
        }
        builder.addSlot(RecipeIngredientRole.CATALYST, 62, 12).addItemStack(this.renderStack);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 93, 12).addItemStack(recipe.method_8110((class_5455)class_5455.field_40585));
    }
}

