/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1860;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.recipe.ElvenTradeRecipe;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.api.state.enums.AlfheimPortalState;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.advancements.AlfheimPortalBreadTrigger;
import vazkii.botania.common.advancements.AlfheimPortalTrigger;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;
import vazkii.botania.common.block.block_entity.PylonBlockEntity;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;
import vazkii.botania.common.block.mana.ManaPoolBlock;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.XplatAbstractions;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.api.TriPredicate;

public class AlfheimPortalBlockEntity
extends BotaniaBlockEntity
implements Wandable {
    public static final Supplier<IMultiblock> MULTIBLOCK = Suppliers.memoize(() -> {
        record 1Matcher(class_6862<class_2248> tag, class_2350.class_2351 displayedRotation, class_2248 defaultBlock) implements IStateMatcher
        {
            public class_2680 getDisplayedState(long ticks) {
                List<class_2248> blocks = StreamSupport.stream(class_7923.field_41175.method_40286(this.tag).spliterator(), false).map(class_6880::comp_349).toList();
                if (blocks.isEmpty()) {
                    return class_2246.field_9987.method_9564();
                }
                class_2680 block = blocks.contains(this.defaultBlock) ? this.defaultBlock.method_9564() : blocks.get((int)(ticks / 20L % (long)blocks.size())).method_9564();
                return block.method_28498((class_2769)class_2741.field_12496) ? (class_2680)block.method_11657((class_2769)class_2741.field_12496, (Comparable)this.displayedRotation()) : block;
            }

            public TriPredicate<class_1922, class_2338, class_2680> getStatePredicate() {
                return (blockGetter, pos, state) -> state.method_26164(this.tag());
            }
        }
        1Matcher horizontal = new 1Matcher(BotaniaTags.Blocks.LIVINGWOOD_LOGS, class_2350.class_2351.field_11048, BotaniaBlocks.livingwoodLog);
        1Matcher vertical = new 1Matcher(BotaniaTags.Blocks.LIVINGWOOD_LOGS, class_2350.class_2351.field_11052, BotaniaBlocks.livingwoodLog);
        1Matcher horizontalGlimmer = new 1Matcher(BotaniaTags.Blocks.LIVINGWOOD_LOGS_GLIMMERING, class_2350.class_2351.field_11048, BotaniaBlocks.livingwoodLogGlimmering);
        1Matcher verticalGlimmer = new 1Matcher(BotaniaTags.Blocks.LIVINGWOOD_LOGS_GLIMMERING, class_2350.class_2351.field_11052, BotaniaBlocks.livingwoodLogGlimmering);
        return PatchouliAPI.get().makeMultiblock((String[][])new String[][]{{"_", "w", "g", "w", "_"}, {"W", " ", " ", " ", "W"}, {"G", " ", " ", " ", "G"}, {"W", " ", " ", " ", "W"}, {"_", "w", "0", "w", "_"}}, new Object[]{Character.valueOf('W'), vertical, Character.valueOf('w'), horizontal, Character.valueOf('G'), verticalGlimmer, Character.valueOf('g'), horizontalGlimmer, Character.valueOf('0'), BotaniaBlocks.alfPortal});
    });
    public static final int MANA_COST = 500;
    public static final int MANA_COST_OPENING = 200000;
    public static final int MIN_REQUIRED_PYLONS = 2;
    private static final String TAG_TICKS_OPEN = "ticksOpen";
    private static final String TAG_TICKS_SINCE_LAST_ITEM = "ticksSinceLastItem";
    private static final String TAG_STACK_COUNT = "stackCount";
    private static final String TAG_STACK = "portalStack";
    public static final String TAG_PORTAL_FLAG = "_elvenPortal";
    private final List<class_1799> stacksIn = new ArrayList<class_1799>();
    private final List<class_2338> cachedPylonPositions = new ArrayList<class_2338>();
    public int ticksOpen = 0;
    private int ticksSinceLastItem = 0;
    private boolean closeNow = false;
    private boolean explode = false;
    @Nullable
    private UUID breadPlayer = null;

    public AlfheimPortalBlockEntity(class_2338 pos, class_2680 state) {
        super(BotaniaBlockEntities.ALF_PORTAL, pos, state);
    }

    public static void commonTick(class_1937 level, class_2338 worldPosition, class_2680 blockState, AlfheimPortalBlockEntity self) {
        AlfheimPortalState state = (AlfheimPortalState)((Object)blockState.method_11654(BotaniaStateProperties.ALFPORTAL_STATE));
        if (state == AlfheimPortalState.OFF) {
            self.ticksOpen = 0;
            return;
        }
        AlfheimPortalState newState = self.getValidState(state);
        ++self.ticksOpen;
        class_238 aabb = self.getPortalAABB(state);
        boolean open = self.ticksOpen > 60;
        XplatAbstractions.INSTANCE.fireElvenPortalUpdateEvent(self, aabb, open, self.stacksIn);
        if (self.ticksOpen > 60) {
            ++self.ticksSinceLastItem;
            if (level.field_9236 && BotaniaConfig.client().elfPortalParticlesEnabled()) {
                self.blockParticle(state);
            }
            List items = level.method_18467(class_1542.class, aabb);
            if (!level.field_9236) {
                for (class_1542 item : items) {
                    if (!item.method_5805()) continue;
                    class_1799 stack = item.method_6983();
                    if (XplatAbstractions.INSTANCE.itemFlagsComponent((class_1542)item).alfPortalSpawned) continue;
                    item.method_31472();
                    if (self.validateItemUsage(item)) {
                        self.addItem(stack);
                    }
                    self.ticksSinceLastItem = 0;
                }
            }
            if (!level.field_9236 && !self.stacksIn.isEmpty() && self.ticksSinceLastItem >= 4) {
                self.resolveRecipes();
            }
        }
        if (self.closeNow) {
            if (!level.field_9236) {
                level.method_8501(worldPosition, BotaniaBlocks.alfPortal.method_9564());
            }
            for (int i = 0; i < 36; ++i) {
                self.blockParticle(state);
            }
            self.closeNow = false;
        } else if (newState != state) {
            if (newState == AlfheimPortalState.OFF) {
                for (int i = 0; i < 36; ++i) {
                    self.blockParticle(state);
                }
            }
            if (!level.field_9236) {
                level.method_8501(worldPosition, (class_2680)blockState.method_11657(BotaniaStateProperties.ALFPORTAL_STATE, (Comparable)((Object)newState)));
            }
        } else if (self.explode) {
            class_1657 entity;
            level.method_8437(null, (double)worldPosition.method_10263() + 0.5, (double)worldPosition.method_10264() + 2.0, (double)worldPosition.method_10260() + 0.5, 3.0f, class_1937.class_7867.field_40888);
            self.explode = false;
            if (!level.field_9236 && self.breadPlayer != null && (entity = level.method_18470(self.breadPlayer)) instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)entity;
                AlfheimPortalBreadTrigger.INSTANCE.trigger(serverPlayer, worldPosition);
            }
            self.breadPlayer = null;
        }
    }

    private boolean validateItemUsage(class_1542 entity) {
        class_1799 inputStack = entity.method_6983();
        for (class_1860 recipe : BotaniaRecipeTypes.getRecipes(this.field_11863, BotaniaRecipeTypes.ELVEN_TRADE_TYPE).values()) {
            ElvenTradeRecipe tradeRecipe;
            if (!(recipe instanceof ElvenTradeRecipe) || !(tradeRecipe = (ElvenTradeRecipe)recipe).containsItem(inputStack)) continue;
            return true;
        }
        if (inputStack.method_31574(class_1802.field_8229)) {
            this.explode = true;
            if (entity.method_24921() != null) {
                this.breadPlayer = entity.method_24921().method_5667();
            }
        }
        return false;
    }

    private void blockParticle(AlfheimPortalState state) {
        int rnd = this.field_11863.field_9229.method_43048(9);
        double dh = rnd / 3 - 1;
        double dy = rnd % 3 + 1;
        double dx = state == AlfheimPortalState.ON_X ? 0.0 : dh;
        double dz = state == AlfheimPortalState.ON_Z ? 0.0 : dh;
        float motionMul = 0.2f;
        WispParticleData data = WispParticleData.wisp((float)(Math.random() * (double)0.15f + (double)0.1f), (float)(Math.random() * 0.25), (float)(Math.random() * 0.5 + 0.5), (float)(Math.random() * 0.25));
        this.field_11863.method_8406((class_2394)data, (double)this.method_11016().method_10263() + dx, (double)this.method_11016().method_10264() + dy, (double)this.method_11016().method_10260() + dz, (double)((float)(Math.random() - 0.5) * motionMul), (double)((float)(Math.random() - 0.5) * motionMul), (double)((float)(Math.random() - 0.5) * motionMul));
    }

    @Override
    public boolean onUsedByWand(@Nullable class_1657 player, class_1799 stack, class_2350 side) {
        AlfheimPortalState newState;
        AlfheimPortalState state = (AlfheimPortalState)((Object)this.method_11010().method_11654(BotaniaStateProperties.ALFPORTAL_STATE));
        if (state == AlfheimPortalState.OFF && (newState = this.getValidState(state)) != AlfheimPortalState.OFF) {
            this.field_11863.method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657(BotaniaStateProperties.ALFPORTAL_STATE, (Comparable)((Object)newState)));
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                AlfheimPortalTrigger.INSTANCE.trigger(serverPlayer, serverPlayer.method_51469(), this.method_11016(), stack);
            }
            return true;
        }
        return false;
    }

    private class_238 getPortalAABB(AlfheimPortalState state) {
        return state == AlfheimPortalState.ON_X ? new class_238(this.field_11867.method_10069(0, 1, -1), this.field_11867.method_10069(1, 4, 2)) : new class_238(this.field_11867.method_10069(-1, 1, 0), this.field_11867.method_10069(2, 4, 1));
    }

    private void addItem(class_1799 stack) {
        int size = stack.method_7947();
        stack.method_7939(1);
        for (int i = 0; i < size; ++i) {
            this.stacksIn.add(stack.method_7972());
        }
    }

    public static Collection<ElvenTradeRecipe> elvenTradeRecipes(class_1937 world) {
        return BotaniaRecipeTypes.getRecipes(world, BotaniaRecipeTypes.ELVEN_TRADE_TYPE).values();
    }

    private void resolveRecipes() {
        List<class_2338> pylons = this.locatePylons(true);
        for (class_1860 r : BotaniaRecipeTypes.getRecipes(this.field_11863, BotaniaRecipeTypes.ELVEN_TRADE_TYPE).values()) {
            ElvenTradeRecipe recipe;
            Optional<List<class_1799>> match;
            if (!(r instanceof ElvenTradeRecipe) || !(match = (recipe = (ElvenTradeRecipe)r).match(this.stacksIn)).isPresent()) continue;
            if (!this.consumeMana(pylons, 500, false)) break;
            List<class_1799> inputs = match.get();
            for (class_1799 stack : inputs) {
                this.stacksIn.remove(stack);
            }
            for (class_1799 output : recipe.getOutputs(inputs)) {
                this.spawnItem(output.method_7972());
            }
        }
    }

    private void spawnItem(class_1799 stack) {
        class_1542 item = new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 1.5, (double)this.field_11867.method_10260() + 0.5, stack);
        XplatAbstractions.INSTANCE.itemFlagsComponent((class_1542)item).alfPortalSpawned = true;
        this.field_11863.method_8649((class_1297)item);
        this.ticksSinceLastItem = 0;
    }

    @Override
    public void method_11007(class_2487 cmp) {
        super.method_11007(cmp);
        cmp.method_10569(TAG_STACK_COUNT, this.stacksIn.size());
        int i = 0;
        for (class_1799 stack : this.stacksIn) {
            class_2487 stackcmp = stack.method_7953(new class_2487());
            cmp.method_10566(TAG_STACK + i, (class_2520)stackcmp);
            ++i;
        }
    }

    @Override
    public void method_11014(@NotNull class_2487 cmp) {
        super.method_11014(cmp);
        int count = cmp.method_10550(TAG_STACK_COUNT);
        this.stacksIn.clear();
        for (int i = 0; i < count; ++i) {
            class_2487 stackcmp = cmp.method_10562(TAG_STACK + i);
            class_1799 stack = class_1799.method_7915((class_2487)stackcmp);
            this.stacksIn.add(stack);
        }
    }

    @Override
    public void writePacketNBT(class_2487 cmp) {
        cmp.method_10569(TAG_TICKS_OPEN, this.ticksOpen);
        cmp.method_10569(TAG_TICKS_SINCE_LAST_ITEM, this.ticksSinceLastItem);
    }

    @Override
    public void readPacketNBT(class_2487 cmp) {
        this.ticksOpen = cmp.method_10550(TAG_TICKS_OPEN);
        this.ticksSinceLastItem = cmp.method_10550(TAG_TICKS_SINCE_LAST_ITEM);
    }

    private static class_2470 getStateRotation(AlfheimPortalState state) {
        return switch (state) {
            case AlfheimPortalState.ON_X -> class_2470.field_11463;
            case AlfheimPortalState.ON_Z -> class_2470.field_11467;
            default -> null;
        };
    }

    private AlfheimPortalState getValidState(AlfheimPortalState oldState) {
        class_2470 rot;
        if (oldState != AlfheimPortalState.OFF) {
            class_2470 oldRot = AlfheimPortalBlockEntity.getStateRotation(oldState);
            if (!MULTIBLOCK.get().validate(this.field_11863, this.method_11016(), oldRot)) {
                return AlfheimPortalState.OFF;
            }
            rot = oldRot;
        } else {
            rot = MULTIBLOCK.get().validate(this.field_11863, this.method_11016());
        }
        if (rot == null) {
            return AlfheimPortalState.OFF;
        }
        this.lightPylons();
        return switch (rot) {
            default -> throw new IncompatibleClassChangeError();
            case class_2470.field_11467, class_2470.field_11464 -> AlfheimPortalState.ON_Z;
            case class_2470.field_11463, class_2470.field_11465 -> AlfheimPortalState.ON_X;
        };
    }

    public List<class_2338> locatePylons(boolean rescanNow) {
        if (!rescanNow && this.cachedPylonPositions.size() >= 2) {
            ArrayList<class_2338> cachedResult = new ArrayList<class_2338>();
            for (class_2338 pos : this.cachedPylonPositions) {
                if (!this.isValidPylonPosition(pos)) continue;
                cachedResult.add(pos);
            }
            if (cachedResult.size() >= 2) {
                return cachedResult;
            }
        }
        int range = 5;
        ArrayList<class_2338> result = new ArrayList<class_2338>();
        for (class_2338 pos : class_2338.method_10097((class_2338)this.method_11016().method_10069(-range, -range, -range), (class_2338)this.method_11016().method_10069(range, range, range))) {
            if (!this.isValidPylonPosition(pos)) continue;
            result.add(pos.method_10062());
        }
        this.cachedPylonPositions.clear();
        this.cachedPylonPositions.addAll(result);
        return result;
    }

    private boolean isValidPylonPosition(class_2338 pos) {
        return this.method_10997().method_22340(pos) && this.method_10997().method_8320(pos).method_27852(BotaniaBlocks.naturaPylon) && this.method_10997().method_8320(pos.method_10074()).method_26204() instanceof ManaPoolBlock;
    }

    public void lightPylons() {
        if (this.ticksOpen < 50) {
            return;
        }
        boolean finishOpening = this.ticksOpen == 50;
        List<class_2338> pylons = this.locatePylons(finishOpening);
        for (class_2338 pos : pylons) {
            class_2586 tile = this.field_11863.method_8321(pos);
            if (!(tile instanceof PylonBlockEntity)) continue;
            PylonBlockEntity pylon = (PylonBlockEntity)tile;
            pylon.activated = true;
            pylon.centerPos = this.method_11016();
        }
        if (finishOpening) {
            this.consumeMana(pylons, 200000, true);
        }
    }

    public boolean consumeMana(List<class_2338> pylons, int totalCost, boolean close) {
        ArrayList<ManaPoolBlockEntity> consumePools = new ArrayList<ManaPoolBlockEntity>();
        int consumed = 0;
        if (pylons.size() < 2) {
            this.closeNow = true;
            return false;
        }
        int costPer = Math.max(1, totalCost / pylons.size());
        int expectedConsumption = costPer * pylons.size();
        for (class_2338 pos : pylons) {
            class_2586 tile = this.field_11863.method_8321(pos);
            if (tile instanceof PylonBlockEntity) {
                PylonBlockEntity pylon = (PylonBlockEntity)tile;
                pylon.activated = true;
                pylon.centerPos = this.method_11016();
            }
            if (!((tile = this.field_11863.method_8321(pos.method_10074())) instanceof ManaPoolBlockEntity)) continue;
            ManaPoolBlockEntity pool = (ManaPoolBlockEntity)tile;
            if (pool.getCurrentMana() < costPer) {
                this.closeNow = this.closeNow || close;
                return false;
            }
            if (this.field_11863.field_9236) continue;
            consumePools.add(pool);
            consumed += costPer;
        }
        if (consumed >= expectedConsumption) {
            for (ManaPoolBlockEntity pool : consumePools) {
                pool.receiveMana(-costPer);
                pool.craftingEffect(false);
            }
            return true;
        }
        return false;
    }
}

