/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.StateIngredientHelper;

public class BlockStateStateIngredient
implements StateIngredient {
    private final class_2680 state;

    public BlockStateStateIngredient(class_2680 state) {
        this.state = state;
    }

    @Override
    public boolean test(class_2680 blockState) {
        return this.state == blockState;
    }

    @Override
    public class_2680 pick(class_5819 random) {
        return this.state;
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = StateIngredientHelper.serializeBlockState(this.state);
        object.addProperty("type", "state");
        return object;
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10804(2);
        buffer.method_10804(class_2248.method_9507((class_2680)this.state));
    }

    @Override
    public List<class_1799> getDisplayedStacks() {
        class_2248 block = this.state.method_26204();
        if (block.method_8389() == class_1802.field_8162) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new class_1799((class_1935)block));
    }

    @Override
    @Nullable
    public List<class_2561> descriptionTooltip() {
        ImmutableMap map = this.state.method_11656();
        if (map.isEmpty()) {
            return StateIngredient.super.descriptionTooltip();
        }
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            class_2769 key = (class_2769)entry.getKey();
            String name = key.method_11901((Comparable)entry.getValue());
            tooltip.add((class_2561)class_2561.method_43470((String)(key.method_11899() + " = " + name)).method_27692(class_124.field_1080));
        }
        return tooltip;
    }

    @Override
    public List<class_2680> getDisplayed() {
        return Collections.singletonList(this.state);
    }

    public class_2680 getState() {
        return this.state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.state == ((BlockStateStateIngredient)o).state;
    }

    public int hashCode() {
        return this.state.hashCode();
    }

    public String toString() {
        return "BlockStateStateIngredient{" + this.state + "}";
    }
}

