/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.fabric.integration.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import vazkii.botania.api.recipe.RunicAltarRecipe;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.item.material.RuneItem;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.fabric.integration.emi.BlendTextureWidget;
import vazkii.botania.fabric.integration.emi.BotaniaEmiPlugin;
import vazkii.botania.fabric.integration.emi.BotaniaEmiRecipe;
import vazkii.botania.fabric.integration.emi.ManaWidget;

public class RunicAltarEmiRecipe
extends BotaniaEmiRecipe {
    private static final class_2960 TEXTURE = ResourceLocationHelper.prefix("textures/gui/petal_overlay.png");
    private static final EmiStack LIVINGROCK = EmiStack.of((class_1935)BotaniaBlocks.livingrock);
    private static final EmiStack ALTAR = EmiStack.of((class_1935)BotaniaBlocks.runeAltar);
    private final List<EmiIngredient> ingredients;
    private final int mana;

    public RunicAltarEmiRecipe(RunicAltarRecipe recipe) {
        super(BotaniaEmiPlugin.RUNIC_ALTAR, recipe);
        this.ingredients = recipe.method_8117().stream().map(EmiIngredient::of).toList();
        this.input = Stream.concat(this.ingredients.stream(), Stream.of(LIVINGROCK)).toList();
        for (EmiIngredient ing : this.input) {
            for (EmiStack stack : ing.getEmiStacks()) {
                if (!(stack.getItemStack().method_7909() instanceof RuneItem)) continue;
                stack.setRemainder(stack.copy());
            }
        }
        this.output = List.of(EmiStack.of((class_1799)recipe.method_8110((class_5455)class_5455.field_40585)));
        this.mana = recipe.getManaUsage();
    }

    public int getDisplayHeight() {
        return 107;
    }

    public int getDisplayWidth() {
        return 106;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.add((Widget)new ManaWidget(2, 100, this.mana, 100000));
        RunicAltarEmiRecipe.addRunicAltarWidgets(widgets, this, this.ingredients, (EmiIngredient)ALTAR, (EmiStack)this.output.get(0));
    }

    public static void addRunicAltarWidgets(WidgetHolder widgets, EmiRecipe recipe, List<EmiIngredient> input, EmiIngredient altar, EmiStack output) {
        double step = 360.0 / (double)input.size();
        widgets.add((Widget)new BlendTextureWidget(TEXTURE, 21, 0, 85, 82, 42, 11));
        for (int i = 0; i < input.size(); ++i) {
            EmiIngredient ing = input.get(i);
            widgets.addSlot(ing, BotaniaEmiPlugin.rotateXAround(44, 8, 44, 40, step * (double)i), BotaniaEmiPlugin.rotateYAround(44, 8, 44, 40, step * (double)i)).drawBack(false);
        }
        widgets.addSlot(altar, 44, 41).drawBack(false).catalyst(true);
        widgets.addSlot((EmiIngredient)output, 82, 5).drawBack(false).recipeContext(recipe);
    }
}

