/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.biome.image;

import com.dfsek.terra.addons.biome.image.lib.jafama.FastMath;
import com.dfsek.terra.api.world.biome.Biome;
import com.dfsek.terra.api.world.biome.generation.BiomeProvider;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ImageBiomeProvider
implements BiomeProvider {
    private final Map<Color, Biome> colorBiomeMap = new HashMap<Color, Biome>();
    private final BufferedImage image;
    private final int resolution;
    private final Align align;

    public ImageBiomeProvider(Set<Biome> registry, BufferedImage image, int resolution, Align align) {
        this.image = image;
        this.resolution = resolution;
        this.align = align;
        registry.forEach(biome -> this.colorBiomeMap.put(new Color(biome.getColor()), (Biome)biome));
    }

    private static int distance(Color a, Color b) {
        return FastMath.abs(a.getRed() - b.getRed()) + FastMath.abs(a.getGreen() - b.getGreen()) + FastMath.abs(a.getBlue() - b.getBlue());
    }

    public Biome getBiome(int x, int y, int z, long seed) {
        return this.getBiome(x, z);
    }

    public Biome getBiome(int x, int z) {
        Color color = this.align.getColor(this.image, x /= this.resolution, z /= this.resolution);
        return this.colorBiomeMap.get(this.colorBiomeMap.keySet().stream().reduce((Color)this.colorBiomeMap.keySet().stream().findAny().orElseThrow(IllegalStateException::new), (running, element) -> {
            int d2;
            int d1 = ImageBiomeProvider.distance(color, running);
            return d1 < (d2 = ImageBiomeProvider.distance(color, element)) ? running : element;
        }));
    }

    public Optional<Biome> getBaseBiome(int x, int z, long seed) {
        return Optional.of(this.getBiome(x, z));
    }

    public Iterable<Biome> getBiomes() {
        return this.colorBiomeMap.values();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Align {
        CENTER{

            @Override
            public Color getColor(BufferedImage image, int x, int z) {
                return new Color(image.getRGB(FastMath.floorMod(x - image.getWidth() / 2, image.getWidth()), FastMath.floorMod(z - image.getHeight() / 2, image.getHeight())));
            }
        }
        ,
        NONE{

            @Override
            public Color getColor(BufferedImage image, int x, int z) {
                return new Color(image.getRGB(FastMath.floorMod(x, image.getWidth()), FastMath.floorMod(z, image.getHeight())));
            }
        };


        public abstract Color getColor(BufferedImage var1, int var2, int var3);
    }
}

