/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.command;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import net.lionarius.skinrestorer.MineskinSkinProvider;
import net.lionarius.skinrestorer.MojangSkinProvider;
import net.lionarius.skinrestorer.SkinRestorer;
import net.lionarius.skinrestorer.SkinStorage;
import net.lionarius.skinrestorer.enums.SkinVariant;
import net.lionarius.skinrestorer.util.TranslationUtils;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2191;
import net.minecraft.class_2561;

public class SkinCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"skin").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").then(class_2170.method_9247((String)"mojang").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"skin_name", (ArgumentType)StringArgumentType.word()).executes(context -> SkinCommand.skinAction((class_2168)context.getSource(), () -> MojangSkinProvider.getSkin(StringArgumentType.getString((CommandContext)context, (String)"skin_name"))))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2191.method_9329()).requires(source -> source.method_9259(3))).executes(context -> SkinCommand.skinAction((class_2168)context.getSource(), class_2191.method_9330((CommandContext)context, (String)"targets"), true, () -> MojangSkinProvider.getSkin(StringArgumentType.getString((CommandContext)context, (String)"skin_name")))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"web").then(class_2170.method_9247((String)"classic").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"url", (ArgumentType)StringArgumentType.string()).executes(context -> SkinCommand.skinAction((class_2168)context.getSource(), () -> MineskinSkinProvider.getSkin(StringArgumentType.getString((CommandContext)context, (String)"url"), SkinVariant.CLASSIC)))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2191.method_9329()).requires(source -> source.method_9259(3))).executes(context -> SkinCommand.skinAction((class_2168)context.getSource(), class_2191.method_9330((CommandContext)context, (String)"targets"), true, () -> MineskinSkinProvider.getSkin(StringArgumentType.getString((CommandContext)context, (String)"url"), SkinVariant.CLASSIC))))))).then(class_2170.method_9247((String)"slim").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"url", (ArgumentType)StringArgumentType.string()).executes(context -> SkinCommand.skinAction((class_2168)context.getSource(), () -> MineskinSkinProvider.getSkin(StringArgumentType.getString((CommandContext)context, (String)"url"), SkinVariant.SLIM)))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2191.method_9329()).requires(source -> source.method_9259(3))).executes(context -> SkinCommand.skinAction((class_2168)context.getSource(), class_2191.method_9330((CommandContext)context, (String)"targets"), true, () -> MineskinSkinProvider.getSkin(StringArgumentType.getString((CommandContext)context, (String)"url"), SkinVariant.SLIM))))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").executes(context -> SkinCommand.skinAction((class_2168)context.getSource(), () -> SkinStorage.DEFAULT_SKIN))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2191.method_9329()).executes(context -> SkinCommand.skinAction((class_2168)context.getSource(), class_2191.method_9330((CommandContext)context, (String)"targets"), true, () -> SkinStorage.DEFAULT_SKIN)))));
    }

    private static int skinAction(class_2168 src, Collection<GameProfile> targets, boolean setByOperator, Supplier<Property> skinSupplier) {
        SkinRestorer.setSkinAsync(src.method_9211(), targets, skinSupplier).thenAccept(pair -> {
            Collection profiles = (Collection)pair.right();
            Collection players = (Collection)pair.left();
            if (profiles.size() == 0) {
                src.method_9213(class_2561.method_30163((String)TranslationUtils.translation.skinActionFailed));
                return;
            }
            if (setByOperator) {
                src.method_9226(() -> class_2561.method_30163((String)String.format(TranslationUtils.translation.skinActionAffectedProfile, String.join((CharSequence)", ", profiles.stream().map(GameProfile::getName).toList()))), true);
                if (players.size() != 0) {
                    src.method_9226(() -> class_2561.method_30163((String)String.format(TranslationUtils.translation.skinActionAffectedPlayer, String.join((CharSequence)", ", players.stream().map(p -> p.method_7334().getName()).toList()))), true);
                }
            } else {
                src.method_9226(() -> class_2561.method_30163((String)TranslationUtils.translation.skinActionOk), true);
            }
        });
        return targets.size();
    }

    private static int skinAction(class_2168 src, Supplier<Property> skinSupplier) {
        if (src.method_44023() == null) {
            return 0;
        }
        return SkinCommand.skinAction(src, Collections.singleton(src.method_44023().method_7334()), false, skinSupplier);
    }
}

