/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.common.fluid.utils;

import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.PlatformFluidHandler;
import earth.terrarium.botarium.common.fluid.base.PlatformFluidItemHandler;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import earth.terrarium.botarium.fabric.fluid.holder.FabricFluidHolder;
import earth.terrarium.botarium.fabric.fluid.holder.ItemStackStorage;
import earth.terrarium.botarium.fabric.fluid.storage.FabricFluidHandler;
import earth.terrarium.botarium.fabric.fluid.storage.FabricFluidItemHandler;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_3611;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class FluidHooks {
    public static FluidHolder newFluidHolder(class_3611 fluid, long amount, class_2487 tag) {
        return FabricFluidHolder.of(fluid, tag, amount);
    }

    public static FluidHolder fluidFromCompound(class_2487 compoundTag) {
        FabricFluidHolder fluid = FabricFluidHolder.of(null, 0L);
        fluid.deserialize(compoundTag);
        return fluid;
    }

    public static FluidHolder emptyFluid() {
        return FabricFluidHolder.empty();
    }

    public static long buckets(double buckets) {
        return (long)(buckets * (double)FluidHooks.getBucketAmount());
    }

    public static PlatformFluidItemHandler getItemFluidManager(class_1799 stack) {
        return new FabricFluidItemHandler(stack);
    }

    public static PlatformFluidHandler getBlockFluidManager(class_2586 entity, @Nullable class_2350 direction) {
        return new FabricFluidHandler((Storage<FluidVariant>)((Storage)FluidStorage.SIDED.find(entity.method_10997(), entity.method_11016(), (Object)direction)));
    }

    public static boolean isFluidContainingBlock(class_2586 entity, @Nullable class_2350 direction) {
        return FluidStorage.SIDED.find(entity.method_10997(), entity.method_11016(), (Object)direction) != null;
    }

    public static boolean isFluidContainingItem(class_1799 stack) {
        return FluidStorage.ITEM.find(stack, (Object)ItemStackStorage.of(stack)) != null;
    }

    public static Optional<PlatformFluidHandler> safeGetBlockFluidManager(class_2586 entity, @Nullable class_2350 direction) {
        if (entity == null) {
            return Optional.empty();
        }
        return FluidHooks.isFluidContainingBlock(entity, direction) ? Optional.of(FluidHooks.getBlockFluidManager(entity, direction)) : Optional.empty();
    }

    public static Optional<PlatformFluidItemHandler> safeGetItemFluidManager(class_1799 stack) {
        return FluidHooks.isFluidContainingItem(stack) ? Optional.of(FluidHooks.getItemFluidManager(stack)) : Optional.empty();
    }

    public static long moveFluid(PlatformFluidHandler from, PlatformFluidHandler to, FluidHolder fluid) {
        FluidHolder extracted = from.extractFluid(fluid, true);
        long inserted = to.insertFluid(extracted, true);
        from.extractFluid(FluidHooks.newFluidHolder(fluid.getFluid(), inserted, fluid.getCompound()), false);
        return to.insertFluid(extracted, false);
    }

    public static long moveItemToStandardFluid(PlatformFluidItemHandler from, ItemStackHolder sender, PlatformFluidHandler to, FluidHolder fluid) {
        FluidHolder extracted = from.extractFluid(sender.copy(), fluid, true);
        long inserted = to.insertFluid(extracted, true);
        from.extractFluid(sender, FluidHooks.newFluidHolder(fluid.getFluid(), inserted, fluid.getCompound()), false);
        return to.insertFluid(extracted, false);
    }

    public static long moveStandardToItemFluid(PlatformFluidHandler from, PlatformFluidItemHandler to, ItemStackHolder receiver, FluidHolder fluid) {
        FluidHolder extracted = from.extractFluid(fluid, true);
        long inserted = to.insertFluid(receiver.copy(), extracted, true);
        from.extractFluid(FluidHooks.newFluidHolder(fluid.getFluid(), inserted, fluid.getCompound()), false);
        return to.insertFluid(receiver, extracted, false);
    }

    public static long moveItemToItemFluid(PlatformFluidItemHandler from, ItemStackHolder sender, PlatformFluidItemHandler to, ItemStackHolder receiver, FluidHolder fluid) {
        FluidHolder extracted = from.extractFluid(sender.copy(), fluid, true);
        long inserted = to.insertFluid(receiver.copy(), extracted, true);
        from.extractFluid(sender, FluidHooks.newFluidHolder(fluid.getFluid(), inserted, fluid.getCompound()), false);
        return to.insertFluid(receiver, extracted, false);
    }

    public static long safeMoveFluid(Optional<PlatformFluidHandler> from, Optional<PlatformFluidHandler> to, FluidHolder fluid) {
        return from.flatMap(f -> to.map(t -> FluidHooks.moveFluid(f, t, fluid))).orElse(0L);
    }

    public static long safeMoveItemToStandard(Optional<PlatformFluidItemHandler> from, ItemStackHolder sender, Optional<PlatformFluidHandler> to, FluidHolder fluid) {
        return from.flatMap(f -> to.map(t -> FluidHooks.moveItemToStandardFluid(f, sender, t, fluid))).orElse(0L);
    }

    public static long safeMoveStandardToItem(Optional<PlatformFluidHandler> from, Optional<PlatformFluidItemHandler> to, ItemStackHolder receiver, FluidHolder fluid) {
        return from.flatMap(f -> to.map(t -> FluidHooks.moveStandardToItemFluid(f, t, receiver, fluid))).orElse(0L);
    }

    public static long safeMoveItemToItem(Optional<PlatformFluidItemHandler> from, ItemStackHolder sender, Optional<PlatformFluidItemHandler> to, ItemStackHolder receiver, FluidHolder fluid) {
        return from.flatMap(f -> to.map(t -> FluidHooks.moveItemToItemFluid(f, sender, t, receiver, fluid))).orElse(0L);
    }

    public static long moveBlockToBlockFluid(class_2586 from, @Nullable class_2350 fromDirection, class_2586 to, @Nullable class_2350 toDirection, FluidHolder fluid) {
        return FluidHooks.safeMoveFluid(FluidHooks.safeGetBlockFluidManager(from, fromDirection), FluidHooks.safeGetBlockFluidManager(to, toDirection), fluid);
    }

    public static long moveBlockToItemFluid(class_2586 from, @Nullable class_2350 fromDirection, ItemStackHolder to, FluidHolder fluid) {
        return FluidHooks.safeMoveStandardToItem(FluidHooks.safeGetBlockFluidManager(from, fromDirection), FluidHooks.safeGetItemFluidManager(to.getStack()), to, fluid);
    }

    public static long moveItemToBlockFluid(ItemStackHolder from, class_2586 to, @Nullable class_2350 toDirection, FluidHolder fluid) {
        return FluidHooks.safeMoveItemToStandard(FluidHooks.safeGetItemFluidManager(from.getStack()), from, FluidHooks.safeGetBlockFluidManager(to, toDirection), fluid);
    }

    public static long moveItemToItemFluid(ItemStackHolder from, ItemStackHolder to, FluidHolder fluid) {
        return FluidHooks.safeMoveItemToItem(FluidHooks.safeGetItemFluidManager(from.getStack()), from, FluidHooks.safeGetItemFluidManager(to.getStack()), to, fluid);
    }

    public static long toMillibuckets(long amount) {
        return amount / 81L;
    }

    public static long getBucketAmount() {
        return 81000L;
    }

    public static long getBottleAmount() {
        return 27000L;
    }

    public static long getBlockAmount() {
        return 81000L;
    }

    public static long getIngotAmount() {
        return 9000L;
    }

    public static long getNuggetAmount() {
        return 1000L;
    }

    public static void writeToBuffer(FluidHolder holder, class_2540 buffer) {
        if (holder.isEmpty()) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.method_10804(class_7923.field_41173.method_10206((Object)holder.getFluid()));
            buffer.method_10791(holder.getFluidAmount());
            buffer.method_10794(holder.getCompound());
        }
    }

    public static FluidHolder readFromBuffer(class_2540 buffer) {
        if (!buffer.readBoolean()) {
            return FluidHooks.emptyFluid();
        }
        class_3611 fluid = (class_3611)class_7923.field_41173.method_10200(buffer.method_10816());
        long amount = buffer.method_10792();
        return FluidHolder.of(fluid, amount, buffer.method_10798());
    }
}

