/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.fabric.fluid.holder;

import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_7923;

public class FabricFluidHolder
extends SnapshotParticipant<FabricFluidHolder>
implements FluidHolder,
StorageView<FluidVariant> {
    private FluidVariant fluidVariant;
    private long amount;

    private FabricFluidHolder(FluidVariant variant, long amount) {
        this.fluidVariant = variant;
        this.amount = amount;
    }

    public static FabricFluidHolder of(FluidVariant variant, long amount) {
        return new FabricFluidHolder(variant, amount);
    }

    public static FabricFluidHolder of(class_3611 variant, class_2487 compoundTag, long amount) {
        return new FabricFluidHolder(FluidVariant.of((class_3611)variant, (class_2487)compoundTag), amount);
    }

    public static FabricFluidHolder of(FluidHolder fluidHolder) {
        return new FabricFluidHolder(FluidVariant.of((class_3611)fluidHolder.getFluid(), (class_2487)fluidHolder.getCompound()), fluidHolder.getFluidAmount());
    }

    public FluidVariant toVariant() {
        return FluidVariant.of((class_3611)this.getFluid(), (class_2487)this.getCompound());
    }

    @Override
    public class_3611 getFluid() {
        return this.fluidVariant.getFluid();
    }

    @Override
    public void setFluid(class_3611 fluid) {
        this.fluidVariant = FluidVariant.of((class_3611)fluid);
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        if (this.fluidVariant.nbtMatches(resource.getNbt()) && this.fluidVariant.isOf((Object)resource.getFluid())) {
            long extracted = (long)class_3532.method_15363((float)maxAmount, (float)0.0f, (float)this.getFluidAmount());
            this.updateSnapshots(transaction);
            this.amount -= extracted;
            return extracted;
        }
        return 0L;
    }

    public boolean isResourceBlank() {
        return this.fluidVariant.isBlank();
    }

    public FluidVariant getResource() {
        return this.toVariant();
    }

    public long getAmount() {
        return this.getFluidAmount();
    }

    @Override
    public long getFluidAmount() {
        return this.amount;
    }

    public long getCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void setAmount(long amount) {
        this.amount = amount;
    }

    @Override
    public class_2487 getCompound() {
        return this.fluidVariant.getNbt();
    }

    @Override
    public void setCompound(class_2487 tag) {
        this.fluidVariant = FluidVariant.of((class_3611)this.fluidVariant.getFluid(), (class_2487)tag);
    }

    @Override
    public boolean isEmpty() {
        return this.fluidVariant.isBlank() || this.amount == 0L;
    }

    @Override
    public boolean matches(FluidHolder fluidHolder) {
        return this.fluidVariant.isOf((Object)fluidHolder.getFluid()) && this.fluidVariant.nbtMatches(fluidHolder.getCompound());
    }

    @Override
    public FabricFluidHolder copyHolder() {
        return FabricFluidHolder.of(this.getFluid(), this.getCompound() == null ? null : this.getCompound().method_10553(), this.getFluidAmount());
    }

    @Override
    public class_2487 serialize() {
        class_2487 compoundTag = new class_2487();
        compoundTag.method_10582("Fluid", class_7923.field_41173.method_10221((Object)this.getFluid()).toString());
        compoundTag.method_10544("Amount", this.getFluidAmount());
        if (this.getCompound() != null) {
            compoundTag.method_10566("Nbt", (class_2520)this.getCompound());
        }
        return compoundTag;
    }

    @Override
    public void deserialize(class_2487 compound) {
        this.amount = compound.method_10537("Amount");
        class_2487 tag = null;
        if (compound.method_10545("Nbt")) {
            tag = compound.method_10562("Nbt");
        }
        this.fluidVariant = FluidVariant.of((class_3611)((class_3611)class_7923.field_41173.method_10223(new class_2960(compound.method_10558("Fluid")))), (class_2487)tag);
    }

    protected FabricFluidHolder createSnapshot() {
        return this.copyHolder();
    }

    protected void readSnapshot(FabricFluidHolder snapshot) {
        this.fluidVariant = FluidVariant.of((class_3611)snapshot.getFluid(), (class_2487)snapshot.getCompound());
        this.setAmount(snapshot.getFluidAmount());
    }

    public static FabricFluidHolder empty() {
        return new FabricFluidHolder(FluidVariant.blank(), 0L);
    }
}

