/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.fabric.fluid.holder;

import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.FluidSnapshot;
import earth.terrarium.botarium.fabric.fluid.holder.FabricFluidHolder;
import earth.terrarium.botarium.fabric.fluid.storage.ExtendedFluidContainer;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2487;
import net.minecraft.class_3611;

public class WrappedFluidHolder
extends ExtendedFluidContainer
implements StorageView<FluidVariant> {
    private FluidHolder fluidHolder;
    private final FluidExtraction extraction;
    private final ExtendedFluidContainer container;
    private final long capacity;

    public WrappedFluidHolder(ExtendedFluidContainer container, FluidHolder fluidHolder, FluidExtraction extraction, long capacity) {
        this.fluidHolder = fluidHolder;
        this.extraction = extraction;
        this.container = container;
        this.capacity = capacity;
    }

    public FluidVariant fluidVariant() {
        return FluidVariant.of((class_3611)this.fluidHolder.getFluid(), (class_2487)this.fluidHolder.getCompound());
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        return this.extraction.apply(this.fluidHolder, FabricFluidHolder.of(resource, maxAmount), () -> this.updateSnapshots(transaction));
    }

    public boolean isResourceBlank() {
        return this.fluidVariant().isBlank();
    }

    public FluidVariant getResource() {
        return this.fluidVariant();
    }

    public long getAmount() {
        return this.fluidHolder.getFluidAmount();
    }

    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public FluidSnapshot createSnapshot() {
        return this.container.createSnapshot();
    }

    @Override
    public void readSnapshot(FluidSnapshot snapshot) {
        this.container.readSnapshot(snapshot);
    }

    @Override
    public void onFinalCommit() {
        this.container.onFinalCommit();
    }

    @FunctionalInterface
    public static interface FluidExtraction {
        public long apply(FluidHolder var1, FluidHolder var2, Runnable var3);
    }
}

