/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.trimeffects;

import com.mojang.serialization.DynamicOps;
import dev.foxgirl.trimeffects.Config;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_3489;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TrimEffects
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"trimeffects");
    private static TrimEffects INSTANCE;
    private Config.Parsed config;
    private static final Map<UUID, Integer> absorptionStunTicks;

    public static TrimEffects getInstance() {
        return INSTANCE;
    }

    public TrimEffects() {
        INSTANCE = this;
    }

    @NotNull
    public Config.Parsed getConfig() {
        return Objects.requireNonNull(this.config, "Expression 'config'");
    }

    public void onInitialize() {
        this.config = Config.read().parse();
    }

    @NotNull
    public static <T> class_5321<T> getKey(@NotNull class_6880<T> entry) {
        return (class_5321)entry.method_40230().orElseThrow();
    }

    @Nullable
    public static class_8053 getTrim(@NotNull class_5455 manager, @NotNull class_1799 stack) {
        class_2487 nbt = stack.method_7941("Trim");
        if (nbt == null || !stack.method_31573(class_3489.field_41890)) {
            return null;
        }
        return class_8053.field_41994.parse((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)manager), (Object)nbt).result().orElse(null);
    }

    public void handleTick(class_1309 player) {
        List armor;
        class_5455 manager = player.method_37908().method_30349();
        class_8053 trim = TrimEffects.getTrim(manager, (class_1799)(armor = (List)player.method_5661()).get(0));
        if (trim == null) {
            return;
        }
        class_5321 pattern = TrimEffects.getKey(trim.method_48424());
        class_5321 material = TrimEffects.getKey(trim.method_48431());
        int size = armor.size();
        for (int i = 1; i < size; ++i) {
            class_8053 trimCurrent = TrimEffects.getTrim(manager, (class_1799)armor.get(i));
            if (trimCurrent == null) {
                return;
            }
            if (pattern == TrimEffects.getKey(trimCurrent.method_48424()) && material == TrimEffects.getKey(trimCurrent.method_48431())) continue;
            return;
        }
        class_5321<class_1291> effect = this.getConfig().getEffects().get(pattern);
        Integer strength = this.getConfig().getStrengths().get(material);
        int durationMaximum = (int)((this.getConfig().getSecondsMaximum() + 0.75) * 20.0);
        int durationMinimum = (int)((this.getConfig().getSecondsMinimum() + 0.75) * 20.0);
        if (effect != null && strength != null && strength > 0) {
            class_1293 effectInstance;
            int amplifier = strength - 1;
            class_1291 effectType = (class_1291)manager.method_30530(class_7924.field_41208).method_29107(effect);
            if (effectType != null && ((effectInstance = player.method_6112(effectType)) == null || effectInstance.method_5578() < amplifier || effectInstance.method_48557(durationMinimum))) {
                if (effectType == class_1294.field_5898) {
                    Integer stunTicks = absorptionStunTicks.get(player.method_5667());
                    if (stunTicks != null && stunTicks > 0) {
                        absorptionStunTicks.put(player.method_5667(), stunTicks - 1);
                        return;
                    }
                    if (effectInstance != null && player.method_6067() < player.method_52541()) {
                        absorptionStunTicks.put(player.method_5667(), (int)(this.getConfig().getAbsorptionStunSeconds() * 2.0));
                        return;
                    }
                }
                player.method_37222(new class_1293(effectType, durationMaximum, amplifier), (class_1297)player);
            }
        }
    }

    static {
        absorptionStunTicks = new HashMap<UUID, Integer>();
    }
}

