/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.mixin;

import com.faboslav.friendsandfoes.entity.PlayerIllusionEntity;
import com.faboslav.friendsandfoes.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.init.FriendsAndFoesItems;
import com.faboslav.friendsandfoes.init.FriendsAndFoesSoundEvents;
import com.faboslav.friendsandfoes.platform.TotemHelper;
import com.faboslav.friendsandfoes.tag.FriendsAndFoesTags;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_4051;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309 {
    private static final int MAX_ILLUSIONS_COUNT = 9;
    private static final int ILLUSION_LIFETIME_TICKS = 600;
    private static final int NEGATIVE_EFFECT_TICKS = 400;
    private static final int POSITIVE_EFFECT_TICKS = 200;
    private static final Predicate<class_1309> FREEZE_FILTER = entity -> !(entity instanceof class_1657) || !((class_1657)entity).method_7337();
    private static final class_4051 FREEZE_TARGET_PREDICATE = class_4051.method_36626().method_18424().method_36627().method_18420(FREEZE_FILTER);
    private static final class_4051 ATTACK_TARGET_PREDICATE = class_4051.method_36626().method_18424().method_36627();
    @Shadow
    public double field_7524;
    @Shadow
    public double field_7522;
    @Shadow
    public double field_7502;
    @Shadow
    public double field_7500;
    @Shadow
    public double field_7521;
    @Shadow
    public double field_7499;
    @Shadow
    public float field_7505;
    @Shadow
    public float field_7483;

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Shadow
    public abstract class_1799 method_6118(class_1304 var1);

    @Shadow
    public abstract Iterable<class_1799> method_5661();

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void friendsandfoes_addToTick(CallbackInfo ci) {
        this.friendsandfoes_updateWildfireCrown();
    }

    private void friendsandfoes_updateWildfireCrown() {
        class_1799 itemStack = this.method_6118(class_1304.field_6169);
        if (itemStack.method_31574(FriendsAndFoesItems.WILDFIRE_CROWN.get()) && !this.method_5777(class_3486.field_15518) && !this.method_5809()) {
            this.method_6092(new class_1293(class_1294.field_5918, 160, 0, false, false, true));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"damage"}, cancellable=true)
    public void friendsandfoes_tryUseTotems(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (this.method_6032() <= this.method_6063() / 2.0f) {
            PlayerEntityMixin entity = this;
            class_1799 offhandItemStack = entity.method_5998(class_1268.field_5810);
            class_1799 mainhandItemStack = entity.method_5998(class_1268.field_5808);
            class_1799 moddedSlotItemStack = TotemHelper.getTotemFromModdedSlots((class_1657)entity, PlayerEntityMixin::isTotem);
            class_1799 totemItemStack = null;
            if (PlayerEntityMixin.isTotem(mainhandItemStack)) {
                totemItemStack = mainhandItemStack;
            } else if (PlayerEntityMixin.isTotem(offhandItemStack)) {
                totemItemStack = offhandItemStack;
            } else if (moddedSlotItemStack != null) {
                totemItemStack = moddedSlotItemStack;
            }
            if (totemItemStack != null) {
                if (this instanceof class_3222) {
                    class_3222 serverPlayerEntity = (class_3222)this;
                    if (totemItemStack.method_7909() == FriendsAndFoesItems.TOTEM_OF_FREEZING.get()) {
                        serverPlayerEntity.method_7259(class_3468.field_15372.method_14956((Object)FriendsAndFoesItems.TOTEM_OF_FREEZING.get()));
                    } else if (totemItemStack.method_7909() == FriendsAndFoesItems.TOTEM_OF_ILLUSION.get()) {
                        serverPlayerEntity.method_7259(class_3468.field_15372.method_14956((Object)FriendsAndFoesItems.TOTEM_OF_ILLUSION.get()));
                    }
                    class_174.field_1204.method_9165(serverPlayerEntity, totemItemStack);
                }
                this.method_6012();
                if (totemItemStack.method_7909() == FriendsAndFoesItems.TOTEM_OF_FREEZING.get()) {
                    this.friendsandfoes_freezeEntities();
                    this.method_6092(new class_1293(class_1294.field_5904, 200, 1));
                } else if (totemItemStack.method_7909() == FriendsAndFoesItems.TOTEM_OF_ILLUSION.get()) {
                    this.friendsandfoes_createIllusions();
                }
                TotemHelper.sendTotemEffectPacket(totemItemStack, this);
                totemItemStack.method_7934(1);
                cir.setReturnValue((Object)true);
            }
        }
    }

    private static boolean isTotem(class_1799 itemStack) {
        return itemStack.method_31573(FriendsAndFoesTags.TOTEMS);
    }

    private void friendsandfoes_freezeEntities() {
        List nearbyEntities = this.method_37908().method_8390(class_1309.class, this.method_5829().method_1014(9.0), livingEntity -> FREEZE_TARGET_PREDICATE.method_18419((class_1309)this, livingEntity));
        nearbyEntities.forEach(nearbyEntity -> {
            nearbyEntity.method_32317(400);
            nearbyEntity.method_6092(new class_1293(class_1294.field_5909, 400, 1));
        });
    }

    private void friendsandfoes_createIllusions() {
        this.method_5783(FriendsAndFoesSoundEvents.ENTITY_PLAYER_MIRROR_MOVE.get(), this.method_6107(), this.method_6017());
        class_243 illusionerPosition = this.method_19538();
        float slice = 0.69813174f;
        int radius = 9;
        int randomPoint = this.method_6051().method_39332(0, 8);
        ArrayList<PlayerIllusionEntity> createdPlayerIllusions = new ArrayList<PlayerIllusionEntity>();
        for (int point = 0; point < 9; ++point) {
            float angle = slice * (float)point;
            int x = (int)(illusionerPosition.method_10216() + (double)((float)radius * class_3532.method_15362((float)angle)));
            int y = (int)illusionerPosition.method_10214();
            int z = (int)(illusionerPosition.method_10215() + (double)((float)radius * class_3532.method_15374((float)angle)));
            if (randomPoint == point) {
                boolean teleportResult = this.friendsandfoes_tryToTeleport(x, y, z);
                if (!teleportResult) continue;
                this.method_6092(new class_1293(class_1294.field_5905, 200));
                this.friendsandfoes_spawnCloudParticles();
                continue;
            }
            PlayerIllusionEntity createdPlayerIllusion = this.friendsandfoes_createIllusion(x, y, z);
            if (createdPlayerIllusion == null) continue;
            createdPlayerIllusions.add(createdPlayerIllusion);
        }
        List nearbyEntities = this.method_37908().method_8390(class_1308.class, this.method_5829().method_1014(18.0), mobEntity -> ATTACK_TARGET_PREDICATE.method_18419((class_1309)this, (class_1309)mobEntity));
        nearbyEntities.forEach(nearbyEntity -> {
            if (nearbyEntity.method_5968() == this) {
                nearbyEntity.method_5980((class_1309)createdPlayerIllusions.get(this.method_6051().method_43048(createdPlayerIllusions.size())));
                nearbyEntity.method_6092(new class_1293(class_1294.field_5919, 400, 1));
            }
        });
    }

    @Nullable
    private PlayerIllusionEntity friendsandfoes_createIllusion(int x, int y, int z) {
        float randomYaw;
        PlayerIllusionEntity playerIllusion = (PlayerIllusionEntity)FriendsAndFoesEntityTypes.PLAYER_ILLUSION.get().method_5883(this.method_37908());
        if (playerIllusion == null) {
            return null;
        }
        playerIllusion.prevCapeX = this.field_7524;
        playerIllusion.prevCapeY = this.field_7502;
        playerIllusion.prevCapeZ = this.field_7522;
        playerIllusion.capeX = this.field_7500;
        playerIllusion.capeY = this.field_7521;
        playerIllusion.capeZ = this.field_7499;
        playerIllusion.prevStrideDistance = this.field_7505;
        playerIllusion.strideDistance = this.field_7483;
        playerIllusion.method_5673(class_1304.field_6173, this.method_6047());
        playerIllusion.method_5673(class_1304.field_6171, this.method_6079());
        this.method_5661().forEach(arg_0 -> ((PlayerIllusionEntity)playerIllusion).method_24523(arg_0));
        playerIllusion.method_6033(this.method_6063());
        playerIllusion.method_5719((class_1297)this);
        playerIllusion.field_5982 = randomYaw = 360.0f * this.method_6051().method_43057();
        playerIllusion.method_36456(randomYaw);
        playerIllusion.field_6220 = randomYaw;
        playerIllusion.method_5636(randomYaw);
        playerIllusion.field_6259 = randomYaw;
        playerIllusion.method_5847(randomYaw);
        playerIllusion.setPlayerUuid(this.method_5667());
        playerIllusion.setPlayer((class_1657)this);
        playerIllusion.setTicksUntilDespawn(600);
        boolean teleportResult = playerIllusion.tryToTeleport(x, y, z);
        if (teleportResult) {
            this.method_37908().method_8649((class_1297)playerIllusion);
            playerIllusion.spawnCloudParticles();
        }
        return playerIllusion;
    }

    private boolean friendsandfoes_tryToTeleport(int x, int y, int z) {
        double bottomY = Math.max(y -= 8, this.method_37908().method_31607());
        double topY = Math.min(bottomY + 16.0, (double)(((class_3218)this.method_37908()).method_32819() - 1));
        for (int i = 0; i < 16; ++i) {
            boolean teleportResult = this.method_6082(x, y = (int)class_3532.method_15350((double)(y + 1), (double)bottomY, (double)topY), z, false);
            if (!teleportResult) continue;
            return true;
        }
        return false;
    }

    private void friendsandfoes_spawnCloudParticles() {
        this.friendsandfoes_spawnParticles(class_2398.field_11204, 16);
    }

    private void friendsandfoes_spawnParticles(class_2400 particleType, int amount) {
        if (this.method_37908().method_8608()) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ((class_3218)this.method_5770()).method_14199((class_2394)particleType, this.method_23322(0.5), this.method_23319() + 0.5, this.method_23325(0.5), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

