/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.terrascript.lib.jafama;

import com.dfsek.terra.addons.terrascript.lib.jafama.NumbersUtils;

abstract class CmnFastMath {
    static final boolean FM_USE_JDK_MATH = CmnFastMath.getBooleanProperty("jafama.usejdk", false);
    static final boolean FM_USE_REDEFINED_LOG = CmnFastMath.getBooleanProperty("jafama.fastlog", false);
    static final boolean FM_USE_REDEFINED_SQRT = CmnFastMath.getBooleanProperty("jafama.fastsqrt", false);
    static final boolean FM_USE_POWTABS_FOR_ASIN = false;
    static final boolean SFM_USE_JDK_MATH = CmnFastMath.getBooleanProperty("jafama.strict.usejdk", false);
    static final boolean SFM_USE_REDEFINED_LOG = CmnFastMath.getBooleanProperty("jafama.strict.fastlog", true);
    static final boolean SFM_USE_REDEFINED_SQRT = CmnFastMath.getBooleanProperty("jafama.strict.fastsqrt", false);
    static final boolean SFM_USE_POWTABS_FOR_ASIN = false;
    static final boolean USE_TWO_POW_TAB = false;
    static final boolean ANTI_SLOW_CASTS = true;
    static final boolean ANTI_JIT_OPTIM_CRASH_ON_NAN = true;
    public static final double E = Math.E;
    public static final double PI = Math.PI;
    public static final double PI_SUP = Double.longBitsToDouble(Double.doubleToRawLongBits(Math.PI) + 1L);
    static final double ONE_DIV_F2 = 0.5;
    static final double ONE_DIV_F3 = 0.16666666666666666;
    static final double ONE_DIV_F4 = 0.041666666666666664;
    static final float TWO_POW_23_F = (float)NumbersUtils.twoPow(23);
    static final double TWO_POW_24 = NumbersUtils.twoPow(24);
    private static final double TWO_POW_N24 = NumbersUtils.twoPow(-24);
    static final double TWO_POW_26 = NumbersUtils.twoPow(26);
    static final double TWO_POW_N26 = NumbersUtils.twoPow(-26);
    static final double TWO_POW_27 = NumbersUtils.twoPow(27);
    static final double TWO_POW_N27 = NumbersUtils.twoPow(-27);
    static final double TWO_POW_N28 = NumbersUtils.twoPow(-28);
    static final double TWO_POW_52 = NumbersUtils.twoPow(52);
    static final double TWO_POW_N55 = NumbersUtils.twoPow(-55);
    static final double TWO_POW_66 = NumbersUtils.twoPow(66);
    static final double TWO_POW_512 = NumbersUtils.twoPow(512);
    static final double TWO_POW_N512 = NumbersUtils.twoPow(-512);
    static final double DOUBLE_MIN_NORMAL = Double.longBitsToDouble(0x10000000000000L);
    static final int MIN_DOUBLE_EXPONENT = -1074;
    static final int MIN_DOUBLE_NORMAL_EXPONENT = -1022;
    static final int MAX_DOUBLE_EXPONENT = 1023;
    static final int MIN_FLOAT_NORMAL_EXPONENT = -126;
    static final int MAX_FLOAT_EXPONENT = 127;
    private static final double SQRT_2 = StrictMath.sqrt(2.0);
    static final double LOG_2 = StrictMath.log(2.0);
    static final double LOG_TWO_POW_27 = StrictMath.log(TWO_POW_27);
    static final double LOG_DOUBLE_MAX_VALUE = StrictMath.log(Double.MAX_VALUE);
    static final double INV_LOG_10 = 1.0 / StrictMath.log(10.0);
    static final double DOUBLE_BEFORE_60 = Double.longBitsToDouble(Double.doubleToRawLongBits(60.0) - 1L);
    private static final double[] TWO_OVER_PI_TAB = new double[]{1.0680707E7, 7228996.0, 1387004.0, 2578385.0, 1.6069853E7, 1.2639074E7, 9804092.0, 4427841.0, 1.6666979E7, 1.1263675E7, 1.2935607E7, 2387514.0, 4345298.0, 1.4681673E7, 3074569.0, 1.3734428E7, 1.6653803E7, 1880361.0, 1.0960616E7, 8533493.0, 3062596.0, 8710556.0, 7349940.0, 6258241.0, 3772886.0, 3769171.0, 3798172.0, 8675211.0, 1.2450088E7, 3874808.0, 9961438.0, 366607.0, 1.5675153E7, 9132554.0, 7151469.0, 3571407.0, 2607881.0, 1.2013382E7, 4155038.0, 6285869.0, 7677882.0, 1.3102053E7, 1.5825725E7, 473591.0, 9065106.0, 1.5363067E7, 6271263.0, 9264392.0, 5636912.0, 4652155.0, 7056368.0, 1.3614112E7, 1.0155062E7, 1944035.0, 9527646.0, 1.50802E7, 6658437.0, 6231200.0, 6832269.0, 1.6767104E7, 5075751.0, 3212806.0, 1398474.0, 7579849.0, 6349435.0, 1.2618859E7};
    private static final double PIO2_TAB0 = Double.longBitsToDouble(4609753056584663040L);
    private static final double PIO2_TAB1 = Double.longBitsToDouble(4500296887714185216L);
    private static final double PIO2_TAB2 = Double.longBitsToDouble(4393339057296375808L);
    private static final double PIO2_TAB3 = Double.longBitsToDouble(4285399695318056960L);
    private static final double PIO2_TAB4 = Double.longBitsToDouble(4174867106174599168L);
    private static final double PIO2_TAB5 = Double.longBitsToDouble(4069606033725587456L);
    static final double PIO2_INV = Double.longBitsToDouble(4603909380684499075L);
    static final double PIO2_HI = Double.longBitsToDouble(4609753056924401664L);
    static final double PIO2_LO = Double.longBitsToDouble(4454258360616903473L);
    static final double PI_INV = PIO2_INV / 2.0;
    static final double PI_HI = 2.0 * PIO2_HI;
    static final double PI_LO = 2.0 * PIO2_LO;
    static final double TWOPI_INV = PIO2_INV / 4.0;
    static final double TWOPI_HI = 4.0 * PIO2_HI;
    static final double TWOPI_LO = 4.0 * PIO2_LO;
    private static final long QUADRANT_BITS_0_MASK = -3458764513820540929L;
    private static final long QUADRANT_PLACE_BITS = 0x3000000000000000L;
    static final double NORMALIZE_ANGLE_MAX_MEDIUM_DOUBLE_PIO2 = StrictMath.pow(2.0, 19.0) * 1.5707963267948966;
    static final double TWO_MATH_PI_IN_MINUS_PI_PI = -2.4492935982947064E-16;
    static final int SIN_COS_TABS_SIZE = (1 << CmnFastMath.getTabSizePower(11)) + 1;
    static final double SIN_COS_DELTA_HI = TWOPI_HI / (double)(SIN_COS_TABS_SIZE - 1);
    static final double SIN_COS_DELTA_LO = TWOPI_LO / (double)(SIN_COS_TABS_SIZE - 1);
    static final double SIN_COS_INDEXER = 1.0 / (SIN_COS_DELTA_HI + SIN_COS_DELTA_LO);
    static final double SIN_COS_MAX_VALUE_FOR_INT_MODULO = 4194303.0 / SIN_COS_INDEXER * 0.99;
    static final int TAN_VIRTUAL_TABS_SIZE = (1 << CmnFastMath.getTabSizePower(12)) + 1;
    static final double TAN_MAX_VALUE_FOR_TABS = StrictMath.toRadians(77.0);
    static final int TAN_TABS_SIZE = (int)(TAN_MAX_VALUE_FOR_TABS / 1.5707963267948966 * (double)(TAN_VIRTUAL_TABS_SIZE - 1)) + 1;
    static final double TAN_DELTA_HI = PIO2_HI / (double)(TAN_VIRTUAL_TABS_SIZE - 1);
    static final double TAN_DELTA_LO = PIO2_LO / (double)(TAN_VIRTUAL_TABS_SIZE - 1);
    static final double TAN_INDEXER = 1.0 / (TAN_DELTA_HI + TAN_DELTA_LO);
    static final double TAN_MAX_VALUE_FOR_INT_MODULO = 4194303.0 / TAN_INDEXER * 0.99;
    static final double ASIN_MAX_VALUE_FOR_TABS = StrictMath.sin(StrictMath.toRadians(73.0));
    static final int ASIN_TABS_SIZE = (1 << CmnFastMath.getTabSizePower(13)) + 1;
    static final double ASIN_DELTA = ASIN_MAX_VALUE_FOR_TABS / (double)(ASIN_TABS_SIZE - 1);
    static final double ASIN_INDEXER = 1.0 / ASIN_DELTA;
    static final double ASIN_MAX_VALUE_FOR_POWTABS = StrictMath.sin(StrictMath.toRadians(88.6));
    static final int ASIN_POWTABS_POWER = 84;
    static final double ASIN_POWTABS_ONE_DIV_MAX_VALUE = 1.0 / ASIN_MAX_VALUE_FOR_POWTABS;
    static final int ASIN_POWTABS_SIZE = 0;
    static final int ASIN_POWTABS_SIZE_MINUS_ONE = ASIN_POWTABS_SIZE - 1;
    static final double ASIN_PIO2_HI = Double.longBitsToDouble(4609753056924675352L);
    static final double ASIN_PIO2_LO = Double.longBitsToDouble(4364452196894661639L);
    static final double ASIN_PS0 = Double.longBitsToDouble(4595172819793696085L);
    static final double ASIN_PS1 = Double.longBitsToDouble(-4623835544539140227L);
    static final double ASIN_PS2 = Double.longBitsToDouble(4596417465768494165L);
    static final double ASIN_PS3 = Double.longBitsToDouble(-4637438604930937029L);
    static final double ASIN_PS4 = Double.longBitsToDouble(4560439845004096136L);
    static final double ASIN_PS5 = Double.longBitsToDouble(4540259411154564873L);
    static final double ASIN_QS1 = Double.longBitsToDouble(-4610777653840302773L);
    static final double ASIN_QS2 = Double.longBitsToDouble(4611733184086379208L);
    static final double ASIN_QS3 = Double.longBitsToDouble(-4618997306433404583L);
    static final double ASIN_QS4 = Double.longBitsToDouble(4590215604441354882L);
    static final double ATAN_MAX_VALUE_FOR_TABS = StrictMath.tan(StrictMath.toRadians(74.0));
    static final int ATAN_TABS_SIZE = (1 << CmnFastMath.getTabSizePower(12)) + 1;
    static final double ATAN_DELTA = ATAN_MAX_VALUE_FOR_TABS / (double)(ATAN_TABS_SIZE - 1);
    static final double ATAN_INDEXER = 1.0 / ATAN_DELTA;
    static final double ATAN_HI3 = Double.longBitsToDouble(4609753056924675352L);
    static final double ATAN_LO3 = Double.longBitsToDouble(4364452196894661639L);
    static final double ATAN_AT0 = Double.longBitsToDouble(4599676419421066509L);
    static final double ATAN_AT1 = Double.longBitsToDouble(-4626998257160492092L);
    static final double ATAN_AT2 = Double.longBitsToDouble(4594314991288484863L);
    static final double ATAN_AT3 = Double.longBitsToDouble(-4630701217362536847L);
    static final double ATAN_AT4 = Double.longBitsToDouble(4591215095208222830L);
    static final double ATAN_AT5 = Double.longBitsToDouble(-4633165035261879699L);
    static final double ATAN_AT6 = Double.longBitsToDouble(4589464229703073105L);
    static final double ATAN_AT7 = Double.longBitsToDouble(-4634804155249132134L);
    static final double ATAN_AT8 = Double.longBitsToDouble(4587333258118041067L);
    static final double ATAN_AT9 = Double.longBitsToDouble(-4637946461342241745L);
    static final double ATAN_AT10 = Double.longBitsToDouble(4580351289466214929L);
    static final double TANH_1_THRESHOLD = 19.061547465398498;
    static final double ASINH_LOG1P_THRESHOLD = 0.04;
    static final double ASINH_ACOSH_SQRT_ELISION_THRESHOLD = 1.6777216E7;
    static final double EXP_OVERFLOW_LIMIT = Double.longBitsToDouble(4649454530587146735L);
    static final double EXP_UNDERFLOW_LIMIT = Double.longBitsToDouble(-4573606559926636463L);
    static final int EXP_LO_DISTANCE_TO_ZERO_POT = 0;
    static final int EXP_LO_DISTANCE_TO_ZERO = 1;
    static final int EXP_LO_TAB_SIZE_POT = CmnFastMath.getTabSizePower(11);
    static final int EXP_LO_TAB_SIZE = (1 << EXP_LO_TAB_SIZE_POT) + 1;
    static final int EXP_LO_TAB_MID_INDEX = (EXP_LO_TAB_SIZE - 1) / 2;
    static final int EXP_LO_INDEXING = EXP_LO_TAB_MID_INDEX / 1;
    static final int EXP_LO_INDEXING_DIV_SHIFT = EXP_LO_TAB_SIZE_POT - 1 - 0;
    static final int LOG_BITS = CmnFastMath.getTabSizePower(12);
    static final int LOG_TAB_SIZE = 1 << LOG_BITS;
    static final int TWO_POW_TAB_SIZE = 0;
    static final int SQRT_LO_BITS = CmnFastMath.getTabSizePower(12);
    static final int SQRT_LO_TAB_SIZE = 1 << SQRT_LO_BITS;
    static final int CBRT_LO_BITS = CmnFastMath.getTabSizePower(12);
    static final int CBRT_LO_TAB_SIZE = 1 << CBRT_LO_BITS;
    static final double HYPOT_MAX_MAG = NumbersUtils.twoPow(511);
    static final double HYPOT_FACTOR = NumbersUtils.twoPow(750);

    CmnFastMath() {
    }

    public static void initTables() {
        int antiOptim = 0;
        antiOptim += MyTSinCos.sinTab.length;
        antiOptim += MyTTan.tanTab.length;
        antiOptim += MyTAsin.asinTab.length;
        antiOptim += MyTAsinPow.asinPowTab.length;
        antiOptim += MyTAtan.atanTab.length;
        antiOptim += MyTExp.expHiTab.length;
        antiOptim += MyTLog.logXTab.length;
        antiOptim += MyTTwoPow.twoPowTab.length;
        antiOptim += MyTSqrt.sqrtXSqrtHiTab.length;
        if (StrictMath.cos(antiOptim += MyTCbrt.cbrtXCbrtHiTab.length) == 0.0) {
            throw new AssertionError();
        }
    }

    public static int log2(int value) {
        return NumbersUtils.log2(value);
    }

    public static int log2(long value) {
        return NumbersUtils.log2(value);
    }

    public static double twoPow(int power) {
        return NumbersUtils.twoPow(power);
    }

    public static int pow2(int value) {
        return value * value;
    }

    public static long pow2(long value) {
        return value * value;
    }

    public static int pow3(int value) {
        return value * value * value;
    }

    public static long pow3(long value) {
        return value * value * value;
    }

    public static int abs(int value) {
        if (FM_USE_JDK_MATH || SFM_USE_JDK_MATH) {
            return Math.abs(value);
        }
        return NumbersUtils.abs(value);
    }

    public static long abs(long value) {
        if (FM_USE_JDK_MATH || SFM_USE_JDK_MATH) {
            return Math.abs(value);
        }
        return NumbersUtils.abs(value);
    }

    public static int toIntExact(long value) {
        return NumbersUtils.asInt(value);
    }

    public static int toInt(long value) {
        return NumbersUtils.toInt(value);
    }

    public static int toRange(int min, int max, int value) {
        return NumbersUtils.toRange(min, max, value);
    }

    public static long toRange(long min, long max, long value) {
        return NumbersUtils.toRange(min, max, value);
    }

    public static int incrementExact(int value) {
        if (value == Integer.MAX_VALUE) {
            throw new ArithmeticException("integer overflow");
        }
        return value + 1;
    }

    public static long incrementExact(long value) {
        if (value == Long.MAX_VALUE) {
            throw new ArithmeticException("long overflow");
        }
        return value + 1L;
    }

    public static int incrementBounded(int value) {
        if (value == Integer.MAX_VALUE) {
            return value;
        }
        return value + 1;
    }

    public static long incrementBounded(long value) {
        if (value == Long.MAX_VALUE) {
            return value;
        }
        return value + 1L;
    }

    public static int decrementExact(int value) {
        if (value == Integer.MIN_VALUE) {
            throw new ArithmeticException("integer overflow");
        }
        return value - 1;
    }

    public static long decrementExact(long value) {
        if (value == Long.MIN_VALUE) {
            throw new ArithmeticException("long overflow");
        }
        return value - 1L;
    }

    public static int decrementBounded(int value) {
        if (value == Integer.MIN_VALUE) {
            return value;
        }
        return value - 1;
    }

    public static long decrementBounded(long value) {
        if (value == Long.MIN_VALUE) {
            return value;
        }
        return value - 1L;
    }

    public static int negateExact(int value) {
        if (value == Integer.MIN_VALUE) {
            throw new ArithmeticException("integer overflow");
        }
        return -value;
    }

    public static long negateExact(long value) {
        if (value == Long.MIN_VALUE) {
            throw new ArithmeticException("long overflow");
        }
        return -value;
    }

    public static int negateBounded(int value) {
        if (value == Integer.MIN_VALUE) {
            return Integer.MAX_VALUE;
        }
        return -value;
    }

    public static long negateBounded(long value) {
        if (value == Long.MIN_VALUE) {
            return Long.MAX_VALUE;
        }
        return -value;
    }

    public static int addExact(int a, int b) {
        return NumbersUtils.plusExact(a, b);
    }

    public static long addExact(long a, long b) {
        return NumbersUtils.plusExact(a, b);
    }

    public static int addBounded(int a, int b) {
        return NumbersUtils.plusBounded(a, b);
    }

    public static long addBounded(long a, long b) {
        return NumbersUtils.plusBounded(a, b);
    }

    public static int subtractExact(int a, int b) {
        return NumbersUtils.minusExact(a, b);
    }

    public static long subtractExact(long a, long b) {
        return NumbersUtils.minusExact(a, b);
    }

    public static int subtractBounded(int a, int b) {
        return NumbersUtils.minusBounded(a, b);
    }

    public static long subtractBounded(long a, long b) {
        return NumbersUtils.minusBounded(a, b);
    }

    public static int multiplyExact(int a, int b) {
        return NumbersUtils.timesExact(a, b);
    }

    public static long multiplyExact(long a, int b) {
        return NumbersUtils.timesExact(a, (long)b);
    }

    public static long multiplyExact(long a, long b) {
        return NumbersUtils.timesExact(a, b);
    }

    public static int multiplyBounded(int a, int b) {
        return NumbersUtils.timesBounded(a, b);
    }

    public static long multiplyBounded(long a, int b) {
        return NumbersUtils.timesBounded(a, (long)b);
    }

    public static long multiplyBounded(long a, long b) {
        return NumbersUtils.timesBounded(a, b);
    }

    public static long multiplyFull(int x, int y) {
        return (long)x * (long)y;
    }

    public static long multiplyHigh(long x, long y) {
        if ((x | y) < 0L) {
            long x1 = x >> 32;
            long y1 = y >> 32;
            long x2 = x & 0xFFFFFFFFL;
            long y2 = y & 0xFFFFFFFFL;
            long z2 = x2 * y2;
            long t = x1 * y2 + (z2 >>> 32);
            long z1 = (t & 0xFFFFFFFFL) + x2 * y1;
            long z0 = t >> 32;
            return x1 * y1 + z0 + (z1 >> 32);
        }
        long x1 = x >>> 32;
        long y1 = y >>> 32;
        long x2 = x & 0xFFFFFFFFL;
        long y2 = y & 0xFFFFFFFFL;
        long A = x1 * y1;
        long B = x2 * y2;
        long C = (x1 + x2) * (y1 + y2);
        long K = C - A - B;
        return ((B >>> 32) + K >>> 32) + A;
    }

    public static int floorDiv(int x, int y) {
        int r = x / y;
        if ((x ^ y) < 0 && r * y != x) {
            --r;
        }
        return r;
    }

    public static long floorDiv(long x, int y) {
        return CmnFastMath.floorDiv(x, (long)y);
    }

    public static long floorDiv(long x, long y) {
        long r = x / y;
        if ((x ^ y) < 0L && r * y != x) {
            --r;
        }
        return r;
    }

    public static int floorMod(int x, int y) {
        return x - CmnFastMath.floorDiv(x, y) * y;
    }

    public static int floorMod(long x, int y) {
        return (int)(x - CmnFastMath.floorDiv(x, y) * (long)y);
    }

    public static long floorMod(long x, long y) {
        return x - CmnFastMath.floorDiv(x, y) * y;
    }

    public static int min(int a, int b) {
        return Math.min(a, b);
    }

    public static long min(long a, long b) {
        return Math.min(a, b);
    }

    public static int max(int a, int b) {
        return Math.max(a, b);
    }

    public static long max(long a, long b) {
        return Math.max(a, b);
    }

    static double twoPowNormal(int power) {
        return Double.longBitsToDouble((long)(power + 1023) << 52);
    }

    static double twoPowNormalOrSubnormal(int power) {
        if (power <= -1023) {
            return Double.longBitsToDouble(0x8000000000000L >> -(power + 1023));
        }
        return Double.longBitsToDouble((long)(power + 1023) << 52);
    }

    static double atan2_pinf_yyy(double y) {
        if (y == Double.POSITIVE_INFINITY) {
            return 0.7853981633974483;
        }
        if (y == Double.NEGATIVE_INFINITY) {
            return -0.7853981633974483;
        }
        if (y > 0.0) {
            return 0.0;
        }
        if (y < 0.0) {
            return -0.0;
        }
        return Double.NaN;
    }

    static double atan2_ninf_yyy(double y) {
        if (y == Double.POSITIVE_INFINITY) {
            return 2.356194490192345;
        }
        if (y == Double.NEGATIVE_INFINITY) {
            return -2.356194490192345;
        }
        if (y > 0.0) {
            return Math.PI;
        }
        if (y < 0.0) {
            return -Math.PI;
        }
        return Double.NaN;
    }

    static double atan2_yyy_zeroOrNaN(double y, double x) {
        if (x == 0.0) {
            if (y == 0.0) {
                if (CmnFastMath.signFromBit_antiCyclic(x) < 0L) {
                    return (double)CmnFastMath.signFromBit_antiCyclic(y) * Math.PI;
                }
                return y;
            }
            if (y > 0.0) {
                return 1.5707963267948966;
            }
            if (y < 0.0) {
                return -1.5707963267948966;
            }
            return Double.NaN;
        }
        return Double.NaN;
    }

    static double hypot_NaN(double xAbs, double yAbs) {
        if (xAbs == Double.POSITIVE_INFINITY || yAbs == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        return Double.NaN;
    }

    static double hypot_NaN(double xAbs, double yAbs, double zAbs) {
        if (xAbs == Double.POSITIVE_INFINITY || yAbs == Double.POSITIVE_INFINITY || zAbs == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        return Double.NaN;
    }

    static long encodeRemainderAndQuadrant(double remainder, int quadrant) {
        long bits = Double.doubleToRawLongBits(remainder);
        return bits & 0xCFFFFFFFFFFFFFFFL | (long)quadrant << 60;
    }

    static double decodeRemainder(long bits) {
        return Double.longBitsToDouble(bits & 0xCFFFFFFFFFFFFFFFL | 0x3000000000000000L);
    }

    static int decodeQuadrant(long bits) {
        return (int)(bits >> 60) & 3;
    }

    static strictfp double jdkRemainderTwoPi(double angle) {
        double sin = StrictMath.sin(angle);
        double cos = StrictMath.cos(angle);
        return StrictMath.atan2(sin, cos);
    }

    static strictfp double jdkRemainderPi(double angle) {
        double sin = StrictMath.sin(angle);
        double cos = StrictMath.cos(angle);
        return StrictMath.atan2(sin, Math.abs(cos));
    }

    static strictfp long jdkRemainderPiO2(double angle, boolean negateRem) {
        double cosForAtan2;
        double sinForAtan2;
        int q;
        double sin = StrictMath.sin(angle);
        double cos = StrictMath.cos(angle);
        if (cos >= SQRT_2 / 2.0) {
            q = 0;
            sinForAtan2 = sin;
            cosForAtan2 = cos;
        } else if (cos <= -(SQRT_2 / 2.0)) {
            q = 2;
            sinForAtan2 = -sin;
            cosForAtan2 = -cos;
        } else if (sin > 0.0) {
            q = 1;
            sinForAtan2 = -cos;
            cosForAtan2 = sin;
        } else {
            q = 3;
            sinForAtan2 = cos;
            cosForAtan2 = -sin;
        }
        double fw = StrictMath.atan2(sinForAtan2, cosForAtan2);
        return CmnFastMath.encodeRemainderAndQuadrant(negateRem ? -fw : fw, q);
    }

    static strictfp double heavyRemainderTwoPi(double angle) {
        long remAndQuad = CmnFastMath.heavyRemainderPiO2(angle, false);
        double rem = CmnFastMath.decodeRemainder(remAndQuad);
        int q = CmnFastMath.decodeQuadrant(remAndQuad);
        if (q == 0) {
            return rem;
        }
        if (q == 1) {
            return rem + PIO2_LO + PIO2_HI;
        }
        if (q == 2) {
            if (rem < 0.0) {
                return rem + PI_LO + PI_HI;
            }
            return rem - PI_LO - PI_HI;
        }
        return rem - PIO2_LO - PIO2_HI;
    }

    static strictfp double heavyRemainderPi(double angle) {
        long remAndQuad = CmnFastMath.heavyRemainderPiO2(angle, false);
        double rem = CmnFastMath.decodeRemainder(remAndQuad);
        int q = CmnFastMath.decodeQuadrant(remAndQuad);
        if ((q & 1) != 0) {
            if (rem < 0.0) {
                return rem + PIO2_LO + PIO2_HI;
            }
            return rem - PIO2_LO - PIO2_HI;
        }
        return rem;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static strictfp long heavyRemainderPiO2(double angle, boolean negateRem) {
        double q5;
        boolean carry;
        int i;
        double q4;
        double q3;
        double q2;
        double q1;
        double q0;
        double f5;
        double f6;
        long lx = Double.doubleToRawLongBits(angle);
        long exp = (lx >> 52 & 0x7FFL) - 1046L;
        double z = Double.longBitsToDouble(lx - (exp << 52));
        double x0 = (int)z;
        z = (z - x0) * TWO_POW_24;
        double x1 = (int)z;
        z = (z - x1) * TWO_POW_24;
        double x2 = (int)z;
        int e0 = (int)exp;
        int nx = x2 == 0.0 ? (x1 == 0.0 ? 1 : 2) : 3;
        int jk = 4;
        int jx = nx - 1;
        int jv = Math.max(0, (e0 - 3) / 24);
        int qZero = e0 - 24 * (jv + 1);
        int j = jv - jx;
        if (jx == 0) {
            f6 = 0.0;
            f5 = 0.0;
            double f4 = j >= -4 ? TWO_OVER_PI_TAB[j + 4] : 0.0;
            double f3 = j >= -3 ? TWO_OVER_PI_TAB[j + 3] : 0.0;
            double f2 = j >= -2 ? TWO_OVER_PI_TAB[j + 2] : 0.0;
            double f1 = j >= -1 ? TWO_OVER_PI_TAB[j + 1] : 0.0;
            double f0 = j >= 0 ? TWO_OVER_PI_TAB[j] : 0.0;
            q0 = x0 * f0;
            q1 = x0 * f1;
            q2 = x0 * f2;
            q3 = x0 * f3;
            q4 = x0 * f4;
        } else if (jx == 1) {
            f6 = 0.0;
            f5 = j >= -5 ? TWO_OVER_PI_TAB[j + 5] : 0.0;
            double f4 = j >= -4 ? TWO_OVER_PI_TAB[j + 4] : 0.0;
            double f3 = j >= -3 ? TWO_OVER_PI_TAB[j + 3] : 0.0;
            double f2 = j >= -2 ? TWO_OVER_PI_TAB[j + 2] : 0.0;
            double f1 = j >= -1 ? TWO_OVER_PI_TAB[j + 1] : 0.0;
            double f0 = j >= 0 ? TWO_OVER_PI_TAB[j] : 0.0;
            q0 = x0 * f1 + x1 * f0;
            q1 = x0 * f2 + x1 * f1;
            q2 = x0 * f3 + x1 * f2;
            q3 = x0 * f4 + x1 * f3;
            q4 = x0 * f5 + x1 * f4;
        } else {
            f6 = j >= -6 ? TWO_OVER_PI_TAB[j + 6] : 0.0;
            f5 = j >= -5 ? TWO_OVER_PI_TAB[j + 5] : 0.0;
            double f4 = j >= -4 ? TWO_OVER_PI_TAB[j + 4] : 0.0;
            double f3 = j >= -3 ? TWO_OVER_PI_TAB[j + 3] : 0.0;
            double f2 = j >= -2 ? TWO_OVER_PI_TAB[j + 2] : 0.0;
            double f1 = j >= -1 ? TWO_OVER_PI_TAB[j + 1] : 0.0;
            double f0 = j >= 0 ? TWO_OVER_PI_TAB[j] : 0.0;
            q0 = x0 * f2 + x1 * f1 + x2 * f0;
            q1 = x0 * f3 + x1 * f2 + x2 * f1;
            q2 = x0 * f4 + x1 * f3 + x2 * f2;
            q3 = x0 * f5 + x1 * f4 + x2 * f3;
            q4 = x0 * f6 + x1 * f5 + x2 * f4;
        }
        double twoPowQZero = CmnFastMath.twoPowNormal(qZero);
        int jz = jk;
        z = q4;
        double fw = (int)(TWO_POW_N24 * z);
        int iq0 = (int)(z - TWO_POW_24 * fw);
        z = q3 + fw;
        fw = (int)(TWO_POW_N24 * z);
        int iq1 = (int)(z - TWO_POW_24 * fw);
        z = q2 + fw;
        fw = (int)(TWO_POW_N24 * z);
        int iq2 = (int)(z - TWO_POW_24 * fw);
        z = q1 + fw;
        fw = (int)(TWO_POW_N24 * z);
        int iq3 = (int)(z - TWO_POW_24 * fw);
        z = q0 + fw;
        int iq4 = 0;
        int iq5 = 0;
        z = z * twoPowQZero % 8.0;
        int n = (int)z;
        z -= (double)n;
        int ih = 0;
        if (qZero > 0) {
            i = iq3 >> 24 - qZero;
            n += i;
            ih = (iq3 -= i << 24 - qZero) >> 23 - qZero;
        } else if (qZero == 0) {
            ih = iq3 >> 23;
        } else if (z >= 0.5) {
            ih = 2;
        }
        if (ih > 0) {
            ++n;
            carry = true;
            if (iq0 != 0) {
                iq0 = 0x1000000 - iq0;
                iq1 = 0xFFFFFF - iq1;
                iq2 = 0xFFFFFF - iq2;
                iq3 = 0xFFFFFF - iq3;
            } else if (iq1 != 0) {
                iq1 = 0x1000000 - iq1;
                iq2 = 0xFFFFFF - iq2;
                iq3 = 0xFFFFFF - iq3;
            } else if (iq2 != 0) {
                iq2 = 0x1000000 - iq2;
                iq3 = 0xFFFFFF - iq3;
            } else if (iq3 != 0) {
                iq3 = 0x1000000 - iq3;
            } else {
                carry = false;
            }
            if (qZero > 0) {
                if (qZero == 1) {
                    iq3 &= 0x7FFFFF;
                } else if (qZero == 2) {
                    iq3 &= 0x3FFFFF;
                }
            }
            if (ih == 2) {
                z = 1.0 - z;
                if (carry) {
                    z -= twoPowQZero;
                }
            }
        }
        if (z == 0.0) {
            if (iq3 == 0) {
                return CmnFastMath.jdkRemainderPiO2(angle, negateRem);
            }
            if (jx == 0) {
                f5 = TWO_OVER_PI_TAB[jv + 5];
                q5 = x0 * f5;
            } else if (jx == 1) {
                f6 = TWO_OVER_PI_TAB[jv + 5];
                q5 = x0 * f6 + x1 * f5;
            } else {
                double f7 = TWO_OVER_PI_TAB[jv + 5];
                q5 = x0 * f7 + x1 * f6 + x2 * f5;
            }
            ++jz;
            z = q5;
            fw = (int)(TWO_POW_N24 * z);
            iq0 = (int)(z - TWO_POW_24 * fw);
            z = q4 + fw;
            fw = (int)(TWO_POW_N24 * z);
            iq1 = (int)(z - TWO_POW_24 * fw);
            z = q3 + fw;
            fw = (int)(TWO_POW_N24 * z);
            iq2 = (int)(z - TWO_POW_24 * fw);
            z = q2 + fw;
            fw = (int)(TWO_POW_N24 * z);
            iq3 = (int)(z - TWO_POW_24 * fw);
            z = q1 + fw;
            fw = (int)(TWO_POW_N24 * z);
            iq4 = (int)(z - TWO_POW_24 * fw);
            z = q0 + fw;
            iq5 = 0;
            z = z * twoPowQZero % 8.0;
            n = (int)z;
            z -= (double)n;
            ih = 0;
            if (qZero > 0) {
                i = iq4 >> 24 - qZero;
                n += i;
                ih = (iq4 -= i << 24 - qZero) >> 23 - qZero;
            } else if (qZero == 0) {
                ih = iq4 >> 23;
            } else if (z >= 0.5) {
                ih = 2;
            }
            if (ih > 0) {
                ++n;
                carry = true;
                if (iq0 != 0) {
                    iq0 = 0x1000000 - iq0;
                    iq1 = 0xFFFFFF - iq1;
                    iq2 = 0xFFFFFF - iq2;
                    iq3 = 0xFFFFFF - iq3;
                    iq4 = 0xFFFFFF - iq4;
                } else if (iq1 != 0) {
                    iq1 = 0x1000000 - iq1;
                    iq2 = 0xFFFFFF - iq2;
                    iq3 = 0xFFFFFF - iq3;
                    iq4 = 0xFFFFFF - iq4;
                } else if (iq2 != 0) {
                    iq2 = 0x1000000 - iq2;
                    iq3 = 0xFFFFFF - iq3;
                    iq4 = 0xFFFFFF - iq4;
                } else if (iq3 != 0) {
                    iq3 = 0x1000000 - iq3;
                    iq4 = 0xFFFFFF - iq4;
                } else if (iq4 != 0) {
                    iq4 = 0x1000000 - iq4;
                } else {
                    carry = false;
                }
                if (qZero > 0) {
                    if (qZero == 1) {
                        iq4 &= 0x7FFFFF;
                    } else if (qZero == 2) {
                        iq4 &= 0x3FFFFF;
                    }
                }
                if (ih == 2) {
                    z = 1.0 - z;
                    if (carry) {
                        z -= twoPowQZero;
                    }
                }
            }
            if (z == 0.0) {
                if (iq4 == 0) {
                    return CmnFastMath.jdkRemainderPiO2(angle, negateRem);
                }
                --jz;
                twoPowQZero *= TWO_POW_N24;
            }
        }
        if (z != 0.0) {
            if ((z /= twoPowQZero) >= TWO_POW_24) {
                fw = (int)(TWO_POW_N24 * z);
                if (jz != jk) return CmnFastMath.jdkRemainderPiO2(angle, negateRem);
                iq4 = (int)(z - TWO_POW_24 * fw);
                ++jz;
                twoPowQZero *= TWO_POW_24;
                iq5 = (int)fw;
            } else if (jz == jk) {
                iq4 = (int)z;
            } else {
                iq5 = (int)z;
            }
        }
        fw = twoPowQZero;
        if (jz == 5) {
            q5 = fw * (double)iq5;
            fw *= TWO_POW_N24;
        } else {
            q5 = 0.0;
        }
        q4 = fw * (double)iq4;
        q3 = (fw *= TWO_POW_N24) * (double)iq3;
        q2 = (fw *= TWO_POW_N24) * (double)iq2;
        q1 = (fw *= TWO_POW_N24) * (double)iq1;
        q0 = (fw *= TWO_POW_N24) * (double)iq0;
        fw = PIO2_TAB0 * q5;
        fw += PIO2_TAB0 * q4 + PIO2_TAB1 * q5;
        fw += PIO2_TAB0 * q3 + PIO2_TAB1 * q4 + PIO2_TAB2 * q5;
        fw += PIO2_TAB0 * q2 + PIO2_TAB1 * q3 + PIO2_TAB2 * q4 + PIO2_TAB3 * q5;
        fw += PIO2_TAB0 * q1 + PIO2_TAB1 * q2 + PIO2_TAB2 * q3 + PIO2_TAB3 * q4 + PIO2_TAB4 * q5;
        if (!(ih != 0 ^ negateRem)) return CmnFastMath.encodeRemainderAndQuadrant(fw += PIO2_TAB0 * q0 + PIO2_TAB1 * q1 + PIO2_TAB2 * q2 + PIO2_TAB3 * q3 + PIO2_TAB4 * q4 + PIO2_TAB5 * q5, n & 3);
        fw = -fw;
        return CmnFastMath.encodeRemainderAndQuadrant(fw += PIO2_TAB0 * q0 + PIO2_TAB1 * q1 + PIO2_TAB2 * q2 + PIO2_TAB3 * q3 + PIO2_TAB4 * q4 + PIO2_TAB5 * q5, n & 3);
    }

    private static long signFromBit_antiCyclic(double value) {
        return Double.doubleToRawLongBits(value) >> 62 | 1L;
    }

    private static boolean getBooleanProperty(String key, boolean defaultValue) {
        String tmp = System.getProperty(key);
        if (tmp != null) {
            return Boolean.parseBoolean(tmp);
        }
        return defaultValue;
    }

    private static int getTabSizePower(int tabSizePower) {
        return FM_USE_JDK_MATH && SFM_USE_JDK_MATH ? Math.min(2, tabSizePower) : tabSizePower;
    }

    static final class MyTCbrt {
        static final double[] cbrtXCbrtHiTab = new double[2098];
        static final double[] cbrtXCbrtLoTab = new double[CBRT_LO_TAB_SIZE];
        static final double[] cbrtSlopeHiTab = new double[2098];
        static final double[] cbrtSlopeLoTab = new double[CBRT_LO_TAB_SIZE];

        MyTCbrt() {
        }

        private static strictfp void init() {
            for (int i = -1074; i <= 1023; ++i) {
                double twoPowExpDiv3 = StrictMath.pow(2.0, (double)i * 0.3333333333333333);
                MyTCbrt.cbrtXCbrtHiTab[i - -1074] = twoPowExpDiv3 * 0.5;
                MyTCbrt.cbrtSlopeHiTab[i - -1074] = 1.3333333333333333 / (twoPowExpDiv3 * twoPowExpDiv3);
            }
            MyTCbrt.cbrtXCbrtLoTab[0] = 1.0;
            MyTCbrt.cbrtSlopeLoTab[0] = 1.0;
            long CBRT_LO_MASK = 0x3FF0000000000000L | 0xFFFFFFFFFFFFFL >> CBRT_LO_BITS;
            for (int i = 1; i < CBRT_LO_TAB_SIZE; ++i) {
                double cbrtX;
                long xBits = CBRT_LO_MASK | (long)(i - 1) << 52 - CBRT_LO_BITS;
                MyTCbrt.cbrtXCbrtLoTab[i] = cbrtX = StrictMath.cbrt(Double.longBitsToDouble(xBits));
                MyTCbrt.cbrtSlopeLoTab[i] = 1.0 / (cbrtX * cbrtX);
            }
        }

        static {
            MyTCbrt.init();
        }
    }

    static final class MyTSqrt {
        static final double[] sqrtXSqrtHiTab = new double[2098];
        static final double[] sqrtXSqrtLoTab = new double[SQRT_LO_TAB_SIZE];
        static final double[] sqrtSlopeHiTab = new double[2098];
        static final double[] sqrtSlopeLoTab = new double[SQRT_LO_TAB_SIZE];

        MyTSqrt() {
        }

        private static strictfp void init() {
            for (int i = -1074; i <= 1023; ++i) {
                double twoPowExpDiv2 = StrictMath.pow(2.0, (double)i * 0.5);
                MyTSqrt.sqrtXSqrtHiTab[i - -1074] = twoPowExpDiv2 * 0.5;
                MyTSqrt.sqrtSlopeHiTab[i - -1074] = 1.0 / twoPowExpDiv2;
            }
            MyTSqrt.sqrtXSqrtLoTab[0] = 1.0;
            MyTSqrt.sqrtSlopeLoTab[0] = 1.0;
            long SQRT_LO_MASK = 0x3FF0000000000000L | 0xFFFFFFFFFFFFFL >> SQRT_LO_BITS;
            for (int i = 1; i < SQRT_LO_TAB_SIZE; ++i) {
                double sqrtX;
                long xBits = SQRT_LO_MASK | (long)(i - 1) << 52 - SQRT_LO_BITS;
                MyTSqrt.sqrtXSqrtLoTab[i] = sqrtX = StrictMath.sqrt(Double.longBitsToDouble(xBits));
                MyTSqrt.sqrtSlopeLoTab[i] = 1.0 / sqrtX;
            }
        }

        static {
            MyTSqrt.init();
        }
    }

    static final class MyTTwoPow {
        static final double[] twoPowTab = new double[0];

        MyTTwoPow() {
        }

        private static strictfp void init() {
        }

        static {
            MyTTwoPow.init();
        }
    }

    static final class MyTLog {
        static final double[] logXLogTab = new double[LOG_TAB_SIZE];
        static final double[] logXTab = new double[LOG_TAB_SIZE];
        static final double[] logXInvTab = new double[LOG_TAB_SIZE];

        MyTLog() {
        }

        private static strictfp void init() {
            for (int i = 0; i < LOG_TAB_SIZE; ++i) {
                double x = 1.0 + (double)i * (1.0 / (double)LOG_TAB_SIZE);
                MyTLog.logXLogTab[i] = StrictMath.log(x);
                MyTLog.logXTab[i] = x;
                MyTLog.logXInvTab[i] = 1.0 / x;
            }
        }

        static {
            MyTLog.init();
        }
    }

    static final class MyTExp {
        static final double[] expHiTab = new double[1 + (int)EXP_OVERFLOW_LIMIT - (int)EXP_UNDERFLOW_LIMIT];
        static final double[] expLoPosTab = new double[EXP_LO_TAB_SIZE];
        static final double[] expLoNegTab = new double[EXP_LO_TAB_SIZE];

        MyTExp() {
        }

        private static strictfp void init() {
            int i;
            for (i = (int)EXP_UNDERFLOW_LIMIT; i <= (int)EXP_OVERFLOW_LIMIT; ++i) {
                MyTExp.expHiTab[i - (int)CmnFastMath.EXP_UNDERFLOW_LIMIT] = StrictMath.exp(i);
            }
            for (i = 0; i < EXP_LO_TAB_SIZE; ++i) {
                double x = -1.0 + (double)i / (double)EXP_LO_INDEXING;
                MyTExp.expLoPosTab[i] = StrictMath.exp(x);
                MyTExp.expLoNegTab[i] = -StrictMath.expm1(-x);
            }
        }

        static {
            MyTExp.init();
        }
    }

    static final class MyTAtan {
        static final double[] atanTab = new double[ATAN_TABS_SIZE];
        static final double[] atanDer1DivF1Tab = new double[ATAN_TABS_SIZE];
        static final double[] atanDer2DivF2Tab = new double[ATAN_TABS_SIZE];
        static final double[] atanDer3DivF3Tab = new double[ATAN_TABS_SIZE];
        static final double[] atanDer4DivF4Tab = new double[ATAN_TABS_SIZE];

        MyTAtan() {
        }

        private static strictfp void init() {
            for (int i = 0; i < ATAN_TABS_SIZE; ++i) {
                double x = (double)i * ATAN_DELTA;
                double onePlusXSqInv = 1.0 / (1.0 + x * x);
                double onePlusXSqInv2 = onePlusXSqInv * onePlusXSqInv;
                double onePlusXSqInv3 = onePlusXSqInv2 * onePlusXSqInv;
                double onePlusXSqInv4 = onePlusXSqInv2 * onePlusXSqInv2;
                MyTAtan.atanTab[i] = StrictMath.atan(x);
                MyTAtan.atanDer1DivF1Tab[i] = onePlusXSqInv;
                MyTAtan.atanDer2DivF2Tab[i] = -2.0 * x * onePlusXSqInv2 * 0.5;
                MyTAtan.atanDer3DivF3Tab[i] = (-2.0 + 6.0 * x * x) * onePlusXSqInv3 * 0.16666666666666666;
                MyTAtan.atanDer4DivF4Tab[i] = 24.0 * x * (1.0 - x * x) * onePlusXSqInv4 * 0.041666666666666664;
            }
        }

        static {
            MyTAtan.init();
        }
    }

    static final class MyTAsinPow {
        static final double[] asinParamPowTab = new double[ASIN_POWTABS_SIZE];
        static final double[] asinPowTab = new double[ASIN_POWTABS_SIZE];
        static final double[] asinDer1DivF1PowTab = new double[ASIN_POWTABS_SIZE];
        static final double[] asinDer2DivF2PowTab = new double[ASIN_POWTABS_SIZE];
        static final double[] asinDer3DivF3PowTab = new double[ASIN_POWTABS_SIZE];
        static final double[] asinDer4DivF4PowTab = new double[ASIN_POWTABS_SIZE];

        MyTAsinPow() {
        }

        private static strictfp void init() {
        }

        static {
            MyTAsinPow.init();
        }
    }

    static final class MyTAsin {
        static final double[] asinTab = new double[ASIN_TABS_SIZE];
        static final double[] asinDer1DivF1Tab = new double[ASIN_TABS_SIZE];
        static final double[] asinDer2DivF2Tab = new double[ASIN_TABS_SIZE];
        static final double[] asinDer3DivF3Tab = new double[ASIN_TABS_SIZE];
        static final double[] asinDer4DivF4Tab = new double[ASIN_TABS_SIZE];

        MyTAsin() {
        }

        private static strictfp void init() {
            for (int i = 0; i < ASIN_TABS_SIZE; ++i) {
                double x = (double)i * ASIN_DELTA;
                double oneMinusXSqInv = 1.0 / (1.0 - x * x);
                double oneMinusXSqInv0_5 = StrictMath.sqrt(oneMinusXSqInv);
                double oneMinusXSqInv1_5 = oneMinusXSqInv0_5 * oneMinusXSqInv;
                double oneMinusXSqInv2_5 = oneMinusXSqInv1_5 * oneMinusXSqInv;
                double oneMinusXSqInv3_5 = oneMinusXSqInv2_5 * oneMinusXSqInv;
                MyTAsin.asinTab[i] = StrictMath.asin(x);
                MyTAsin.asinDer1DivF1Tab[i] = oneMinusXSqInv0_5;
                MyTAsin.asinDer2DivF2Tab[i] = x * oneMinusXSqInv1_5 * 0.5;
                MyTAsin.asinDer3DivF3Tab[i] = (1.0 + 2.0 * x * x) * oneMinusXSqInv2_5 * 0.16666666666666666;
                MyTAsin.asinDer4DivF4Tab[i] = (5.0 + 2.0 * x * (2.0 + x * (5.0 - 2.0 * x))) * oneMinusXSqInv3_5 * 0.041666666666666664;
            }
        }

        static {
            MyTAsin.init();
        }
    }

    static final class MyTTan {
        static final double[] tanTab = new double[TAN_TABS_SIZE];
        static final double[] tanDer1DivF1Tab = new double[TAN_TABS_SIZE];
        static final double[] tanDer2DivF2Tab = new double[TAN_TABS_SIZE];
        static final double[] tanDer3DivF3Tab = new double[TAN_TABS_SIZE];
        static final double[] tanDer4DivF4Tab = new double[TAN_TABS_SIZE];

        MyTTan() {
        }

        private static strictfp void init() {
            for (int i = 0; i < TAN_TABS_SIZE; ++i) {
                double angle = (double)i * TAN_DELTA_HI + (double)i * TAN_DELTA_LO;
                double sinAngle = StrictMath.sin(angle);
                double cosAngle = StrictMath.cos(angle);
                double cosAngleInv = 1.0 / cosAngle;
                double cosAngleInv2 = cosAngleInv * cosAngleInv;
                double cosAngleInv3 = cosAngleInv2 * cosAngleInv;
                double cosAngleInv4 = cosAngleInv2 * cosAngleInv2;
                double cosAngleInv5 = cosAngleInv3 * cosAngleInv2;
                MyTTan.tanTab[i] = sinAngle * cosAngleInv;
                MyTTan.tanDer1DivF1Tab[i] = cosAngleInv2;
                MyTTan.tanDer2DivF2Tab[i] = 2.0 * sinAngle * cosAngleInv3 * 0.5;
                MyTTan.tanDer3DivF3Tab[i] = 2.0 * (1.0 + 2.0 * sinAngle * sinAngle) * cosAngleInv4 * 0.16666666666666666;
                MyTTan.tanDer4DivF4Tab[i] = 8.0 * sinAngle * (2.0 + sinAngle * sinAngle) * cosAngleInv5 * 0.041666666666666664;
            }
        }

        static {
            MyTTan.init();
        }
    }

    static final class MyTSinCos {
        static final double[] sinTab = new double[SIN_COS_TABS_SIZE];
        static final double[] cosTab = new double[SIN_COS_TABS_SIZE];

        MyTSinCos() {
        }

        private static strictfp void init() {
            int SIN_COS_PI_INDEX = (SIN_COS_TABS_SIZE - 1) / 2;
            int SIN_COS_PI_MUL_2_INDEX = 2 * SIN_COS_PI_INDEX;
            int SIN_COS_PI_MUL_0_5_INDEX = SIN_COS_PI_INDEX / 2;
            int SIN_COS_PI_MUL_1_5_INDEX = 3 * SIN_COS_PI_INDEX / 2;
            for (int i = 0; i < SIN_COS_TABS_SIZE; ++i) {
                double angle = (double)i * SIN_COS_DELTA_HI + (double)i * SIN_COS_DELTA_LO;
                double sinAngle = StrictMath.sin(angle);
                double cosAngle = StrictMath.cos(angle);
                if (i == SIN_COS_PI_INDEX) {
                    sinAngle = 0.0;
                } else if (i == SIN_COS_PI_MUL_2_INDEX) {
                    sinAngle = 0.0;
                } else if (i == SIN_COS_PI_MUL_0_5_INDEX) {
                    cosAngle = 0.0;
                } else if (i == SIN_COS_PI_MUL_1_5_INDEX) {
                    cosAngle = 0.0;
                }
                MyTSinCos.sinTab[i] = sinAngle;
                MyTSinCos.cosTab[i] = cosAngle;
            }
        }

        static {
            MyTSinCos.init();
        }
    }
}

