/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.terrascript.script.functions;

import com.dfsek.terra.addons.terrascript.lib.jafama.FastMath;
import com.dfsek.terra.addons.terrascript.parser.lang.ImplementationArguments;
import com.dfsek.terra.addons.terrascript.parser.lang.Returnable;
import com.dfsek.terra.addons.terrascript.parser.lang.Scope;
import com.dfsek.terra.addons.terrascript.parser.lang.functions.Function;
import com.dfsek.terra.addons.terrascript.script.TerraImplementationArguments;
import com.dfsek.terra.addons.terrascript.tokenizer.Position;
import com.dfsek.terra.api.block.entity.BlockEntity;
import com.dfsek.terra.api.util.Rotation;
import com.dfsek.terra.api.util.RotationUtil;
import com.dfsek.terra.api.util.vector.Vector2;
import com.dfsek.terra.api.util.vector.Vector3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateFunction
implements Function<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StateFunction.class);
    private final Returnable<String> data;
    private final Returnable<Number> x;
    private final Returnable<Number> y;
    private final Returnable<Number> z;
    private final Position position;

    public StateFunction(Returnable<Number> x, Returnable<Number> y, Returnable<Number> z, Returnable<String> data, Position position) {
        this.position = position;
        this.data = data;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public Void apply(ImplementationArguments implementationArguments, Scope scope) {
        TerraImplementationArguments arguments = (TerraImplementationArguments)implementationArguments;
        Vector2 xz = RotationUtil.rotateVector((Vector2)Vector2.of((double)((Number)this.x.apply(implementationArguments, scope)).doubleValue(), (double)((Number)this.z.apply(implementationArguments, scope)).doubleValue()), (Rotation)arguments.getRotation());
        Vector3 origin = Vector3.of((double)FastMath.roundToInt(xz.getX()), (double)((Number)this.y.apply(implementationArguments, scope)).intValue(), (double)FastMath.roundToInt(xz.getZ())).mutable().add(arguments.getOrigin()).immutable();
        try {
            BlockEntity state = arguments.getWorld().getBlockEntity(origin);
            state.applyState((String)this.data.apply(implementationArguments, scope));
            state.update(false);
        }
        catch (Exception e) {
            LOGGER.warn("Could not apply BlockState at {}", (Object)origin, (Object)e);
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public Returnable.ReturnType returnType() {
        return Returnable.ReturnType.VOID;
    }
}

