/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.terrascript.tokenizer;

import com.dfsek.terra.addons.terrascript.tokenizer.Char;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class Lookahead {
    private final List<Char> buffer = new ArrayList<Char>();
    private final Reader input;
    private int index = 0;
    private int line = 0;
    private boolean end = false;

    public Lookahead(Reader r) {
        this.input = r;
    }

    public Char current() {
        return this.next(0);
    }

    public Char consume() {
        Char consumed = this.current();
        this.consume(1);
        return consumed;
    }

    public Char next(int ahead) {
        if (ahead < 0) {
            throw new IllegalArgumentException();
        }
        while (this.buffer.size() <= ahead && !this.end) {
            Char item = this.fetch();
            if (item != null) {
                this.buffer.add(item);
                continue;
            }
            this.end = true;
        }
        if (ahead >= this.buffer.size()) {
            return null;
        }
        return this.buffer.get(ahead);
    }

    public void consume(int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException();
        }
        while (amount-- > 0) {
            if (!this.buffer.isEmpty()) {
                this.buffer.remove(0);
                continue;
            }
            if (this.end) {
                return;
            }
            Char item = this.fetch();
            if (item != null) continue;
            this.end = true;
        }
    }

    public boolean matches(String check, boolean consume) {
        if (check == null) {
            return false;
        }
        for (int i = 0; i < check.length(); ++i) {
            if (this.next(i).is(check.charAt(i))) continue;
            return false;
        }
        if (consume) {
            this.consume(check.length());
        }
        return true;
    }

    private Char fetch() {
        try {
            int c = this.input.read();
            if (c == -1) {
                return null;
            }
            if (c == 10) {
                ++this.line;
                this.index = 0;
            }
            ++this.index;
            return new Char((char)c, this.line, this.index);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getLine() {
        return this.line;
    }

    public int getIndex() {
        return this.index;
    }
}

