/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.terrascript.tokenizer;

import com.dfsek.terra.addons.terrascript.parser.exceptions.ParseException;
import com.dfsek.terra.addons.terrascript.tokenizer.Char;
import com.dfsek.terra.addons.terrascript.tokenizer.Lookahead;
import com.dfsek.terra.addons.terrascript.tokenizer.Position;
import com.dfsek.terra.addons.terrascript.tokenizer.Token;
import com.dfsek.terra.addons.terrascript.tokenizer.exceptions.EOFException;
import com.dfsek.terra.addons.terrascript.tokenizer.exceptions.FormatException;
import com.dfsek.terra.addons.terrascript.tokenizer.exceptions.TokenizerException;
import com.google.common.collect.Sets;
import java.io.StringReader;
import java.util.Set;
import java.util.Stack;

public class Tokenizer {
    public static final Set<Character> syntaxSignificant = Sets.newHashSet((Object[])new Character[]{Character.valueOf(';'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('\"'), Character.valueOf(','), Character.valueOf('\\'), Character.valueOf('='), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('*'), Character.valueOf('/'), Character.valueOf('>'), Character.valueOf('<'), Character.valueOf('!')});
    private final Lookahead reader;
    private final Stack<Token> brackets = new Stack();
    private Token current;
    private Token last;

    public Tokenizer(String data) {
        this.reader = new Lookahead(new StringReader(data + "\u0000"));
        this.current = this.fetchCheck();
    }

    public Token get() {
        if (!this.hasNext()) {
            throw new ParseException("Unexpected end of input", this.last.getPosition());
        }
        return this.current;
    }

    public Token consume() {
        if (!this.hasNext()) {
            throw new ParseException("Unexpected end of input", this.last.getPosition());
        }
        Token temp = this.current;
        this.current = this.fetchCheck();
        return temp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Token fetchCheck() {
        Token fetch = this.fetch();
        if (fetch != null) {
            this.last = fetch;
            if (fetch.getType() == Token.Type.BLOCK_BEGIN) {
                this.brackets.push(fetch);
                return fetch;
            } else {
                if (fetch.getType() != Token.Type.BLOCK_END) return fetch;
                if (this.brackets.isEmpty()) throw new ParseException("Dangling opening brace", new Position(0, 0));
                this.brackets.pop();
            }
            return fetch;
        } else {
            if (this.brackets.isEmpty()) return fetch;
            throw new ParseException("Dangling closing brace", this.brackets.peek().getPosition());
        }
    }

    private Token fetch() throws TokenizerException {
        Char c;
        while (!this.reader.current().isEOF() && this.reader.current().isWhitespace()) {
            this.reader.consume();
        }
        while (this.reader.matches("//", true)) {
            this.skipLine();
        }
        if (this.reader.matches("/*", true)) {
            this.skipTo("*/");
        }
        if (this.reader.current().isEOF()) {
            return null;
        }
        if (this.reader.matches("==", true)) {
            return new Token("==", Token.Type.EQUALS_OPERATOR, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (this.reader.matches("!=", true)) {
            return new Token("!=", Token.Type.NOT_EQUALS_OPERATOR, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (this.reader.matches(">=", true)) {
            return new Token(">=", Token.Type.GREATER_THAN_OR_EQUALS_OPERATOR, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (this.reader.matches("<=", true)) {
            return new Token("<=", Token.Type.LESS_THAN_OR_EQUALS_OPERATOR, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (this.reader.matches(">", true)) {
            return new Token(">", Token.Type.GREATER_THAN_OPERATOR, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (this.reader.matches("<", true)) {
            return new Token("<", Token.Type.LESS_THAN_OPERATOR, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (this.reader.matches("||", true)) {
            return new Token("||", Token.Type.BOOLEAN_OR, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (this.reader.matches("&&", true)) {
            return new Token("&&", Token.Type.BOOLEAN_AND, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (this.isNumberStart()) {
            StringBuilder num = new StringBuilder();
            while (!this.reader.current().isEOF() && this.isNumberLike()) {
                num.append(this.reader.consume());
            }
            return new Token(num.toString(), Token.Type.NUMBER, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (this.reader.current().is('\"')) {
            this.reader.consume();
            StringBuilder string = new StringBuilder();
            boolean ignoreNext = false;
            while (!this.reader.current().is('\"') || ignoreNext) {
                if (this.reader.current().is('\\') && !ignoreNext) {
                    ignoreNext = true;
                    this.reader.consume();
                    continue;
                }
                ignoreNext = false;
                if (this.reader.current().isEOF()) {
                    throw new FormatException("No end of string literal found. ", new Position(this.reader.getLine(), this.reader.getIndex()));
                }
                string.append(this.reader.consume());
            }
            this.reader.consume();
            return new Token(string.toString(), Token.Type.STRING, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (this.reader.current().is('(')) {
            return new Token(this.reader.consume().toString(), Token.Type.GROUP_BEGIN, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (this.reader.current().is(')')) {
            return new Token(this.reader.consume().toString(), Token.Type.GROUP_END, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (this.reader.current().is(';')) {
            return new Token(this.reader.consume().toString(), Token.Type.STATEMENT_END, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (this.reader.current().is(',')) {
            return new Token(this.reader.consume().toString(), Token.Type.SEPARATOR, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (this.reader.current().is('{')) {
            return new Token(this.reader.consume().toString(), Token.Type.BLOCK_BEGIN, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (this.reader.current().is('}')) {
            return new Token(this.reader.consume().toString(), Token.Type.BLOCK_END, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (this.reader.current().is('=')) {
            return new Token(this.reader.consume().toString(), Token.Type.ASSIGNMENT, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (this.reader.current().is('+')) {
            return new Token(this.reader.consume().toString(), Token.Type.ADDITION_OPERATOR, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (this.reader.current().is('-')) {
            return new Token(this.reader.consume().toString(), Token.Type.SUBTRACTION_OPERATOR, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (this.reader.current().is('*')) {
            return new Token(this.reader.consume().toString(), Token.Type.MULTIPLICATION_OPERATOR, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (this.reader.current().is('/')) {
            return new Token(this.reader.consume().toString(), Token.Type.DIVISION_OPERATOR, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (this.reader.current().is('%')) {
            return new Token(this.reader.consume().toString(), Token.Type.MODULO_OPERATOR, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (this.reader.current().is('!')) {
            return new Token(this.reader.consume().toString(), Token.Type.BOOLEAN_NOT, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        StringBuilder token = new StringBuilder();
        while (!(this.reader.current().isEOF() || this.isSyntaxSignificant(this.reader.current().getCharacter()) || (c = this.reader.consume()).isWhitespace())) {
            token.append(c);
        }
        String tokenString = token.toString();
        if (tokenString.equals("true")) {
            return new Token(tokenString, Token.Type.BOOLEAN, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (tokenString.equals("false")) {
            return new Token(tokenString, Token.Type.BOOLEAN, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (tokenString.equals("num")) {
            return new Token(tokenString, Token.Type.NUMBER_VARIABLE, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (tokenString.equals("str")) {
            return new Token(tokenString, Token.Type.STRING_VARIABLE, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (tokenString.equals("bool")) {
            return new Token(tokenString, Token.Type.BOOLEAN_VARIABLE, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (tokenString.equals("if")) {
            return new Token(tokenString, Token.Type.IF_STATEMENT, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (tokenString.equals("else")) {
            return new Token(tokenString, Token.Type.ELSE, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (tokenString.equals("while")) {
            return new Token(tokenString, Token.Type.WHILE_LOOP, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (tokenString.equals("for")) {
            return new Token(tokenString, Token.Type.FOR_LOOP, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (tokenString.equals("return")) {
            return new Token(tokenString, Token.Type.RETURN, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (tokenString.equals("continue")) {
            return new Token(tokenString, Token.Type.CONTINUE, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (tokenString.equals("break")) {
            return new Token(tokenString, Token.Type.BREAK, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        if (tokenString.equals("fail")) {
            return new Token(tokenString, Token.Type.FAIL, new Position(this.reader.getLine(), this.reader.getIndex()));
        }
        return new Token(tokenString, Token.Type.IDENTIFIER, new Position(this.reader.getLine(), this.reader.getIndex()));
    }

    private void skipLine() {
        while (!this.reader.current().isEOF() && !this.reader.current().isNewLine()) {
            this.reader.consume();
        }
        this.consumeWhitespace();
    }

    private void consumeWhitespace() {
        while (!this.reader.current().isEOF() && this.reader.current().isWhitespace()) {
            this.reader.consume();
        }
    }

    private void skipTo(String s) throws EOFException {
        Position begin = new Position(this.reader.getLine(), this.reader.getIndex());
        while (!this.reader.current().isEOF()) {
            if (this.reader.matches(s, true)) {
                this.consumeWhitespace();
                return;
            }
            this.reader.consume();
        }
        throw new EOFException("No end of expression found.", begin);
    }

    public boolean hasNext() {
        return this.current != null;
    }

    private boolean isNumberLike() {
        return this.reader.current().isDigit() || this.reader.current().is('_', '.', 'E');
    }

    private boolean isNumberStart() {
        return this.reader.current().isDigit() || this.reader.current().is('.') && this.reader.next(1).isDigit();
    }

    public boolean isSyntaxSignificant(char c) {
        return syntaxSignificant.contains(Character.valueOf(c));
    }
}

