/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.recipes.IRecipeGuiLogic;
import mezz.jei.gui.recipes.RecipeGuiTab;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6880;

public class RecipeCategoryTab
extends RecipeGuiTab {
    private final IRecipeGuiLogic logic;
    private final IRecipeCategory<?> category;
    private final IIngredientManager ingredientManager;

    public RecipeCategoryTab(IRecipeGuiLogic logic, IRecipeCategory<?> category, Textures textures, int x, int y, IIngredientManager ingredientManager) {
        super(textures, x, y);
        this.logic = logic;
        this.category = category;
        this.ingredientManager = ingredientManager;
    }

    @Override
    public Optional<IUserInputHandler> handleUserInput(class_437 screen, UserInput input, IInternalKeyMappings keyBindings) {
        if (!this.isMouseOver(input.getMouseX(), input.getMouseY())) {
            return Optional.empty();
        }
        if (input.is(keyBindings.getLeftClick())) {
            if (!input.isSimulate()) {
                this.logic.setRecipeCategory(this.category);
                class_1144 soundHandler = class_310.method_1551().method_1483();
                soundHandler.method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            }
            return Optional.of(this);
        }
        return Optional.empty();
    }

    @Override
    public void draw(boolean selected, class_332 guiGraphics, int mouseX, int mouseY) {
        super.draw(selected, guiGraphics, mouseX, mouseY);
        int iconX = this.x + 4;
        int iconY = this.y + 4;
        IDrawable icon = this.category.getIcon();
        if (icon != null) {
            icon.draw(guiGraphics, iconX += (16 - icon.getWidth()) / 2, iconY += (16 - icon.getHeight()) / 2);
        } else {
            Optional<ITypedIngredient<?>> firstCatalyst = this.logic.getRecipeCatalysts(this.category).findFirst();
            if (firstCatalyst.isPresent()) {
                ITypedIngredient<?> ingredient = firstCatalyst.get();
                RecipeCategoryTab.renderIngredient(guiGraphics, iconX, iconY, ingredient, this.ingredientManager);
            } else {
                String text = this.category.getTitle().getString().substring(0, 2);
                class_310 minecraft = class_310.method_1551();
                class_327 fontRenderer = minecraft.field_1772;
                int textCenterX = this.x + 12;
                int textCenterY = this.y + 12 - 3;
                int color = this.isMouseOver(mouseX, mouseY) ? 0xFFFFA0 : 0xE0E0E0;
                int stringCenter = fontRenderer.method_1727(text) / 2;
                guiGraphics.method_25303(fontRenderer, text, textCenterX - stringCenter, textCenterY, color);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    private static <T> void renderIngredient(class_332 guiGraphics, int iconX, int iconY, ITypedIngredient<T> ingredient, IIngredientManager ingredientManager) {
        IIngredientRenderer<T> ingredientRenderer = ingredientManager.getIngredientRenderer(ingredient.getType());
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416((float)iconX, (float)iconY, 0.0f);
        RenderSystem.enableDepthTest();
        ingredientRenderer.render(guiGraphics, ingredient.getIngredient());
        RenderSystem.disableDepthTest();
        poseStack.method_22909();
    }

    @Override
    public boolean isSelected(IRecipeCategory<?> selectedCategory) {
        class_2960 categoryUid = this.category.getRecipeType().getUid();
        class_2960 selectedCategoryUid = selectedCategory.getRecipeType().getUid();
        return categoryUid.equals((Object)selectedCategoryUid);
    }

    @Override
    public List<class_2561> getTooltip(IModIdHelper modIdHelper) {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        class_2561 title = this.category.getTitle();
        if (title != null) {
            tooltip.add(title);
        }
        class_2960 uid = this.category.getRecipeType().getUid();
        String modId = uid.method_12836();
        if (modIdHelper.isDisplayingModNameEnabled()) {
            String modName = modIdHelper.getFormattedModNameForModId(modId);
            tooltip.add((class_2561)class_2561.method_43470((String)modName));
        }
        return tooltip;
    }
}

