/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.heat.solarheatingplate;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import org.antarcticgardens.newage.config.CommonConfig;
import org.antarcticgardens.newage.config.NewAgeConfig;
import org.antarcticgardens.newage.content.heat.HeatBlockEntity;
import org.antarcticgardens.newage.tools.StringFormattingTool;
import org.jetbrains.annotations.Nullable;

public class SolarHeatingPlateBlockEntity
extends class_2586
implements HeatBlockEntity,
IHaveGoggleInformation {
    private final int energyPerSecond;
    private float last;
    public float heat = 0.0f;

    public SolarHeatingPlateBlockEntity(class_2591<?> type, class_2338 pos, class_2680 blockState, int energyPerSecond) {
        super(type, pos, blockState);
        this.energyPerSecond = energyPerSecond;
    }

    public static SolarHeatingPlateBlockEntity createBasic(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        return new SolarHeatingPlateBlockEntity(type, pos, blockState, 20);
    }

    public static SolarHeatingPlateBlockEntity createAdvanced(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        return new SolarHeatingPlateBlockEntity(type, pos, blockState, 60);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.heat = tag.method_10583("heat");
        this.last = tag.method_10583("last");
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10548("heat", this.heat);
        tag.method_10548("last", this.last);
    }

    @Override
    public float getHeat() {
        return this.heat;
    }

    @Override
    public void addHeat(float amount) {
        this.heat += amount;
        this.method_5431();
    }

    @Override
    public void setHeat(float amount) {
        this.heat = amount;
        this.method_5431();
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        HeatBlockEntity.addToolTips(this, tooltip);
        Lang.translate((String)"tooltip.create_new_age.generating", (Object[])new Object[0]).style(class_124.field_1080).forGoggles(tooltip, 1);
        Lang.translate((String)"tooltip.create_new_age.temperature.ps", (Object[])new Object[]{StringFormattingTool.formatFloat(this.last)}).style(class_124.field_1075).forGoggles(tooltip, 2);
        return true;
    }

    public void tick(class_2338 blockPos, class_1937 world, class_2680 blockState) {
        CommonConfig common = NewAgeConfig.getCommon();
        double generationMultiplier = (Double)common.solarPanelHeatMultiplier.get();
        int dark = 0;
        if (world.method_8608()) {
            double d = 1.0 - (double)(world.method_8430(1.0f) * 5.0f) / 16.0;
            double e = 1.0 - (double)(world.method_8478(1.0f) * 5.0f) / 16.0;
            double f = 0.5 + 2.0 * class_3532.method_15350((double)class_3532.method_15362((float)(world.method_30274(1.0f) * ((float)Math.PI * 2))), (double)-0.25, (double)0.25);
            dark = (int)((1.0 - f * d * e) * 11.0);
        } else {
            dark = world.method_8594();
        }
        HeatBlockEntity.transferAround(this);
        HeatBlockEntity.handleOverheat(this);
        float light = world.method_8314(class_1944.field_9284, blockPos.method_10084()) - (dark *= 2);
        this.last = (float)Math.max((double)(light / 15.0f * (float)this.energyPerSecond) * generationMultiplier - Math.max(0.0, (double)this.heat - (double)(20 * this.energyPerSecond) * generationMultiplier), 0.0);
        this.addHeat(this.last);
    }
}

