/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.client.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_5614;
import net.minecraft.class_811;
import net.minecraft.class_827;
import wraith.fabricaeexnihilo.client.BlockModelRendererFlags;
import wraith.fabricaeexnihilo.modules.barrels.BarrelBlockEntity;
import wraith.fabricaeexnihilo.util.Color;

public class BarrelBlockEntityRenderer
implements class_827<BarrelBlockEntity> {
    private static final float XZ_SCALE = 0.75f;
    private static final float X_MIN = 0.125f;
    private static final float X_MAX = 0.875f;
    private static final float Z_MIN = 0.125f;
    private static final float Z_MAX = 0.875f;
    private static final float Y_MIN = 0.1875f;
    private static final float Y_MAX = 0.9375f;

    public BarrelBlockEntityRenderer(class_5614.class_5615 ctx) {
    }

    public void render(BarrelBlockEntity barrel, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlays) {
        class_2338 pos = barrel.method_11016();
        class_1937 world = barrel.method_10997();
        switch (barrel.getState()) {
            case EMPTY: {
                break;
            }
            case FLUID: {
                this.renderFluid(barrel.getFluid(), barrel.getFluidAmount(), matrices, vertexConsumers, light, overlays);
                break;
            }
            case ITEM: {
                this.renderItem(barrel.getItem(), pos, matrices, vertexConsumers, light, overlays, world);
                break;
            }
            case COMPOST: {
                this.renderCompost(barrel.getItem(), barrel.getCompostLevel(), barrel.getRecipeProgress(), new Color(5717783), pos, matrices, vertexConsumers, light, overlays, world);
            }
        }
    }

    private void renderFluid(FluidVariant fluid, long amount, class_4587 matrices, class_4597 vertexConsumers, int light, int overlays) {
        class_1058 sprite = FluidVariantRendering.getSprite((FluidVariant)fluid);
        int color = FluidVariantRendering.getColor((FluidVariant)fluid);
        float r = (float)(color >> 16 & 0xFF) / 256.0f;
        float g = (float)(color >> 8 & 0xFF) / 256.0f;
        float b = (float)(color & 0xFF) / 256.0f;
        if (sprite == null) {
            return;
        }
        RenderSystem.enableDepthTest();
        QuadEmitter emitter = RendererAccess.INSTANCE.getRenderer().meshBuilder().getEmitter();
        emitter.square(class_2350.field_11036, 0.125f, 0.125f, 0.875f, 0.875f, 1.0f - class_3532.method_16439((float)((float)amount / 81000.0f), (float)0.1875f, (float)0.9375f));
        emitter.spriteBake(sprite, 4);
        vertexConsumers.getBuffer(class_1921.method_23583()).method_22919(matrices.method_23760(), emitter.toBakedQuad(sprite), r, g, b, light, overlays);
    }

    private void renderItem(class_1799 stack, class_2338 pos, class_4587 matrices, class_4597 vertexConsumers, int light, int overlays, class_1937 world) {
        float yScale = 0.75f;
        matrices.method_22903();
        matrices.method_22904(0.5, (double)(0.1875f + yScale / 2.0f), 0.5);
        matrices.method_22905(0.75f, yScale, 0.75f);
        class_310.method_1551().method_1480().method_23178(stack, class_811.field_4315, light, overlays, matrices, vertexConsumers, world, (int)pos.method_10063());
        matrices.method_22909();
    }

    private void renderCompost(class_1799 result, double amount, double progress, Color color, class_2338 pos, class_4587 matrices, class_4597 vertexConsumers, int light, int overlays, class_1937 world) {
        Color finalColor = Color.average(Color.WHITE, color, Math.pow(progress, 4.0));
        float r = finalColor.r;
        float g = finalColor.g;
        float b = finalColor.b;
        matrices.method_22903();
        float yScale = class_3532.method_15363((float)((float)(0.75 * Math.min(amount, 1.0))), (float)0.0f, (float)1.0f);
        class_1792 class_17922 = result.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            class_2680 block = blockItem.method_7711().method_9564();
            class_1087 model = class_310.method_1551().method_1554().method_4743().method_3335(block);
            class_4588 consumer = vertexConsumers.getBuffer(class_4722.method_24074());
            matrices.method_46416(0.125f, 0.1875f, 0.125f);
            matrices.method_22905(0.75f, yScale, 0.75f);
            BlockModelRendererFlags.setColorOverride(true);
            class_310.method_1551().method_1541().method_3350().method_3367(matrices.method_23760(), consumer, block, model, r, g, b, light, overlays);
            BlockModelRendererFlags.setColorOverride(false);
        } else {
            matrices.method_46416(0.125f, 0.1875f, 0.125f);
            matrices.method_22905(0.75f, yScale, 0.75f);
            class_310.method_1551().method_1480().method_23178(result, class_811.field_4315, light, overlays, matrices, vertexConsumers, world, (int)pos.method_10063());
        }
        matrices.method_22909();
    }
}

