/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.compatibility.rei.barrel;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.fabric.FluidStackHooksFabric;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import wraith.fabricaeexnihilo.FabricaeExNihilo;
import wraith.fabricaeexnihilo.compatibility.rei.PluginEntry;
import wraith.fabricaeexnihilo.compatibility.rei.ReiIngredientUtil;
import wraith.fabricaeexnihilo.config.FabricaeExNihiloConfig;
import wraith.fabricaeexnihilo.recipe.barrel.BarrelRecipe;
import wraith.fabricaeexnihilo.recipe.barrel.BarrelRecipeAction;
import wraith.fabricaeexnihilo.recipe.barrel.BarrelRecipeCondition;
import wraith.fabricaeexnihilo.recipe.barrel.BarrelRecipeTrigger;

public class BarrelDisplay
implements Display {
    private final class_2960 id;
    final int duration;
    @Nullable
    final EntryIngredient triggerItem;
    @Nullable
    EntryIngredient above;
    @Nullable
    EntryIngredient below;
    @Nullable
    EntryIngredient inputFluid;
    @Nullable
    EntryIngredient nearby;
    @Nullable
    EntryIngredient conversionOutput;
    @Nullable
    EntryIngredient compostResult;
    float compostAmount;
    final List<EntryIngredient> outputs = new ArrayList<EntryIngredient>();

    public BarrelDisplay(BarrelRecipe recipe) {
        this.id = recipe.method_8114();
        this.duration = recipe.getDuration() * ((FabricaeExNihiloConfig)FabricaeExNihilo.CONFIG.get()).barrels().tickRate() / 20;
        this.triggerItem = this.getTriggerItem(recipe);
        recipe.getConditions().forEach(this::processCondition);
        recipe.getActions().forEach(this::processAction);
    }

    private void processCondition(BarrelRecipeCondition condition) {
        if (condition instanceof BarrelRecipeCondition.BlockAbove) {
            BarrelRecipeCondition.BlockAbove blockAbove = (BarrelRecipeCondition.BlockAbove)condition;
            this.above = ReiIngredientUtil.of(blockAbove.block());
        } else if (condition instanceof BarrelRecipeCondition.FluidAbove) {
            BarrelRecipeCondition.FluidAbove fluidAbove = (BarrelRecipeCondition.FluidAbove)condition;
            this.above = ReiIngredientUtil.of(fluidAbove.fluid());
        } else if (condition instanceof BarrelRecipeCondition.BlockBelow) {
            BarrelRecipeCondition.BlockBelow blockBelow = (BarrelRecipeCondition.BlockBelow)condition;
            this.below = ReiIngredientUtil.of(blockBelow.block());
        } else if (condition instanceof BarrelRecipeCondition.FluidIn) {
            BarrelRecipeCondition.FluidIn fluidIn = (BarrelRecipeCondition.FluidIn)condition;
            this.inputFluid = ReiIngredientUtil.of(fluidIn.fluid());
        } else {
            FabricaeExNihilo.LOGGER.warn("Unsupported barrel recipe condition in REI code: " + condition);
        }
    }

    private void processAction(BarrelRecipeAction action) {
        if (action instanceof BarrelRecipeAction.SpawnEntity) {
            BarrelRecipeAction.SpawnEntity spawnEntity = (BarrelRecipeAction.SpawnEntity)action;
            class_1826 egg = class_1826.method_8019(spawnEntity.entities().getType());
            if (egg == null) {
                return;
            }
            class_1799 stack = new class_1799((class_1935)egg, spawnEntity.entities().getSize());
            this.outputs.add(EntryIngredients.of((class_1799)stack));
        } else if (action instanceof BarrelRecipeAction.StoreItem) {
            BarrelRecipeAction.StoreItem storeItem = (BarrelRecipeAction.StoreItem)action;
            this.outputs.add(EntryIngredients.of((class_1799)storeItem.stack()));
        } else if (action instanceof BarrelRecipeAction.StoreFluid) {
            BarrelRecipeAction.StoreFluid storeFluid = (BarrelRecipeAction.StoreFluid)action;
            if (storeFluid.fluid().isBlank()) {
                return;
            }
            this.outputs.add(EntryIngredients.of((FluidStack)FluidStackHooksFabric.fromFabric((FluidVariant)storeFluid.fluid(), (long)storeFluid.amount())));
        } else if (action instanceof BarrelRecipeAction.ConsumeFluid) {
            BarrelRecipeAction.ConsumeFluid consumeFluid = (BarrelRecipeAction.ConsumeFluid)action;
            if (consumeFluid.fluid().isEmpty()) {
                return;
            }
            this.inputFluid = ReiIngredientUtil.of(consumeFluid.fluid()).map(entryStack -> ClientEntryStacks.setFluidRenderRatio((EntryStack)EntryStacks.of((FluidStack)((FluidStack)entryStack.cast().getValue()).copyWithAmount(consumeFluid.amount())), (float)((float)consumeFluid.amount() / 81000.0f)));
        } else if (action instanceof BarrelRecipeAction.ConvertBlock) {
            BarrelRecipeAction.ConvertBlock convertBlock = (BarrelRecipeAction.ConvertBlock)action;
            this.nearby = ReiIngredientUtil.of(convertBlock.filter());
            this.conversionOutput = EntryIngredients.of((class_1935)convertBlock.result().method_26204());
        } else if (action instanceof BarrelRecipeAction.DropItem) {
            BarrelRecipeAction.DropItem dropItem = (BarrelRecipeAction.DropItem)action;
            this.outputs.add(EntryIngredients.of((class_1799)dropItem.stack()));
        } else if (action instanceof BarrelRecipeAction.FillCompost) {
            BarrelRecipeAction.FillCompost fillCompost = (BarrelRecipeAction.FillCompost)action;
            this.compostResult = EntryIngredients.of((class_1799)fillCompost.result());
            this.compostAmount = fillCompost.increment();
        } else {
            FabricaeExNihilo.LOGGER.warn("Unsupported barrel recipe action in REI code: " + action);
        }
    }

    @Nullable
    private EntryIngredient getTriggerItem(BarrelRecipe recipe) {
        BarrelRecipeTrigger trigger = recipe.getTrigger();
        if (trigger instanceof BarrelRecipeTrigger.ItemInserted) {
            BarrelRecipeTrigger.ItemInserted itemInsertedTrigger = (BarrelRecipeTrigger.ItemInserted)trigger;
            return EntryIngredients.ofIngredient((class_1856)itemInsertedTrigger.predicate());
        }
        return null;
    }

    public List<EntryIngredient> getInputEntries() {
        ArrayList<EntryIngredient> inputs = new ArrayList<EntryIngredient>();
        if (this.triggerItem != null) {
            inputs.add(this.triggerItem);
        }
        if (this.above != null) {
            inputs.add(this.above);
        }
        if (this.below != null) {
            inputs.add(this.below);
        }
        if (this.nearby != null) {
            inputs.add(this.nearby);
        }
        if (this.inputFluid != null) {
            inputs.add(this.inputFluid);
        }
        return inputs;
    }

    public List<EntryIngredient> getOutputEntries() {
        ArrayList<EntryIngredient> outputs = new ArrayList<EntryIngredient>(this.outputs);
        if (this.conversionOutput != null) {
            outputs.add(this.conversionOutput);
        }
        if (this.compostResult != null) {
            outputs.add(this.compostResult);
        }
        return outputs;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return PluginEntry.BARREL;
    }

    public Optional<class_2960> getDisplayLocation() {
        return Optional.of(this.id);
    }
}

