/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.modules.witchwater;

import java.util.Optional;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1463;
import net.minecraft.class_1538;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1667;
import net.minecraft.class_1678;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3730;
import net.minecraft.class_4970;
import net.minecraft.class_5425;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import wraith.fabricaeexnihilo.FabricaeExNihilo;
import wraith.fabricaeexnihilo.config.FabricaeExNihiloConfig;
import wraith.fabricaeexnihilo.modules.ModEffects;
import wraith.fabricaeexnihilo.modules.witchwater.WitchWaterFluid;
import wraith.fabricaeexnihilo.recipe.witchwater.WitchWaterEntityRecipe;
import wraith.fabricaeexnihilo.recipe.witchwater.WitchWaterWorldRecipe;

public class WitchWaterBlock
extends class_2404 {
    public WitchWaterBlock(class_3609 fluid, class_4970.class_2251 settings) {
        super(fluid, settings);
    }

    public static void applyStatusEffect(class_1309 entity, class_1293 statusEffect) {
        int entityEffectDuration;
        boolean hasEffect = entity.method_6088().containsKey(statusEffect.method_5579());
        int n = entityEffectDuration = hasEffect ? ((class_1293)entity.method_6088().get(statusEffect.method_5579())).method_5584() : Integer.MIN_VALUE;
        if (entityEffectDuration <= statusEffect.method_5584() - 20) {
            entity.method_6092(statusEffect);
        }
    }

    public static boolean fluidInteraction(class_1937 world, class_2338 witchPos, class_2338 otherPos) {
        class_3610 fluidState = world.method_8316(otherPos);
        if (fluidState.method_15769() || fluidState.method_15767(WitchWaterFluid.TAG)) {
            return false;
        }
        Optional<WitchWaterWorldRecipe> recipe = WitchWaterWorldRecipe.find(fluidState.method_15772(), world);
        if (recipe.isEmpty()) {
            return false;
        }
        class_2338 changePos = witchPos.method_10093(class_2350.field_11033) == otherPos ? otherPos : witchPos;
        world.method_8501(changePos, recipe.get().getResult().choose(world.field_9229).method_9564());
        world.method_8396(null, changePos, class_3417.field_19198, class_3419.field_15245, 0.7f, 0.8f + world.field_9229.method_43057() * 0.2f);
        return true;
    }

    public static boolean isMarked(class_1309 entity) {
        return entity.method_6059((class_1291)ModEffects.WITCH_WATERED);
    }

    public static void markEntity(class_1309 entity) {
        WitchWaterBlock.applyStatusEffect(entity, ModEffects.WITCH_WATERED.getInstance());
    }

    public static boolean receiveNeighborFluids(class_1937 world, class_2338 pos) {
        for (class_2350 direction : class_2350.values()) {
            class_3610 fluidState = world.method_8316(pos.method_10093(direction));
            if (fluidState.method_15769() || !WitchWaterBlock.fluidInteraction(world, pos, pos.method_10093(direction)) || direction == class_2350.field_11033) continue;
            return false;
        }
        return true;
    }

    public static void replaceMob(class_1937 world, class_1297 toKill, @Nullable class_1297 toSpawn) {
        toKill.method_5650(class_1297.class_5529.field_26999);
        if (toSpawn != null) {
            if (toSpawn instanceof class_1309) {
                class_1309 livingEntity = (class_1309)toSpawn;
                WitchWaterBlock.markEntity(livingEntity);
            }
            world.method_8649(toSpawn);
        }
    }

    public static void replaceMob(class_1937 world, class_1309 toKill, class_1299<?> spawnType) {
        class_1297 toSpawn = spawnType.method_5883(world);
        if (toSpawn instanceof class_1309) {
            class_1309 livingEntity = (class_1309)toSpawn;
            livingEntity.method_5725(toKill.method_24515(), toKill.method_36454(), toKill.method_36455());
            livingEntity.method_18799(toKill.method_18798());
            livingEntity.field_6241 = toKill.field_6241;
            livingEntity.method_6033(livingEntity.method_6063() * toKill.method_6032() / toKill.method_6063());
            if (livingEntity instanceof class_1308) {
                class_1308 mob = (class_1308)livingEntity;
                if (world instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)world;
                    mob.method_5943((class_5425)serverWorld, world.method_8404(mob.method_24515()), class_3730.field_16468, null, null);
                }
            }
        }
        WitchWaterBlock.replaceMob(world, (class_1297)toKill, toSpawn);
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        class_1309 livingEntity;
        if (world == null || entity == null || !entity.method_5805() || entity.method_31481()) {
            return;
        }
        if (entity instanceof class_1309 && !WitchWaterBlock.isMarked(livingEntity = (class_1309)entity)) {
            class_1657 player;
            if (livingEntity instanceof class_1548) {
                class_1548 creeper = (class_1548)livingEntity;
                WitchWaterBlock.markEntity(livingEntity);
                if (!creeper.method_7000()) {
                    class_1538 lightning = (class_1538)class_1299.field_6112.method_5883(world);
                    if (world instanceof class_3218) {
                        class_3218 serverWorld = (class_3218)world;
                        if (lightning != null) {
                            lightning.method_23327(creeper.method_19538().field_1352, creeper.method_19538().field_1351, creeper.method_19538().field_1350);
                            creeper.method_5800(serverWorld, lightning);
                        }
                    }
                }
                creeper.method_6033(creeper.method_6063());
                return;
            }
            if (livingEntity instanceof class_1463) {
                class_1463 rabbit = (class_1463)livingEntity;
                WitchWaterBlock.markEntity((class_1309)rabbit);
                if (rabbit.method_47855() != class_1463.class_7990.field_41567) {
                    rabbit.method_47853(class_1463.class_7990.field_41567);
                }
                return;
            }
            if (livingEntity instanceof class_1657 && !(player = (class_1657)livingEntity).method_7337()) {
                ((FabricaeExNihiloConfig)FabricaeExNihilo.CONFIG.get()).witchwater().effects().forEach(effect -> {
                    class_1291 type = (class_1291)class_7923.field_41174.method_10223(effect.type());
                    if (type != null) {
                        WitchWaterBlock.applyStatusEffect((class_1309)player, new class_1293(type, effect.duration(), effect.amplifier()));
                    }
                });
                return;
            }
            Optional<WitchWaterEntityRecipe> recipe = WitchWaterEntityRecipe.find(entity, world);
            if (recipe.isPresent()) {
                WitchWaterBlock.replaceMob(world, livingEntity, recipe.get().getResult());
                return;
            }
            WitchWaterBlock.markEntity(livingEntity);
            return;
        }
        if (entity instanceof class_1667) {
            class_1667 arrow = (class_1667)entity;
            class_1678 bullet = (class_1678)class_1299.field_6100.method_5883(world);
            if (bullet != null) {
                bullet.method_18799(arrow.method_18798());
                bullet.method_5725(arrow.method_24515(), arrow.method_36454(), arrow.method_36455());
            }
            WitchWaterBlock.replaceMob(world, (class_1297)arrow, (class_1297)bullet);
        }
    }
}

