/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.recipe.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Either;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_2248;
import net.minecraft.class_2359;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class BlockIngredient
implements Predicate<class_2680> {
    protected final Map<String, String> properties;

    protected BlockIngredient(Map<String, String> properties) {
        this.properties = Map.copyOf(properties);
    }

    public static BlockIngredient fromJson(JsonElement json) {
        String id;
        HashMap<String, String> states = new HashMap<String, String>();
        if (json instanceof JsonObject) {
            JsonObject object = (JsonObject)json;
            id = class_3518.method_15265((JsonObject)object, (String)"id");
            for (Map.Entry entry : class_3518.method_15281((JsonObject)object, (String)"states", (JsonObject)new JsonObject()).entrySet()) {
                states.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
        } else {
            id = class_3518.method_15287((JsonElement)json, (String)"block ingredient");
        }
        if (id.startsWith("#")) {
            return new Tag((class_6862<class_2248>)class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960(id.substring(1))), states);
        }
        return new Single((class_2248)class_7923.field_41175.method_10223(new class_2960(id)), states);
    }

    public static BlockIngredient fromPacket(class_2540 buf) {
        Map states = buf.method_34067(class_2540::method_19772, class_2540::method_19772);
        byte id = buf.readByte();
        return switch (id) {
            case 0 -> new Single((class_2248)buf.method_42064((class_2359)class_7923.field_41175), states);
            case 1 -> new Tag((class_6862<class_2248>)class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)buf.method_10810()), states);
            default -> throw new IllegalStateException("Unexpected block ingredient type: " + id);
        };
    }

    protected boolean stateMatches(class_2680 state) {
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            Optional<class_2769> found = state.method_28501().stream().filter(property -> property.method_11899().equals(entry.getKey())).findFirst();
            if (found.isEmpty()) {
                return false;
            }
            Comparable current = state.method_11654(found.get());
            Optional parsed = found.get().method_11900(entry.getValue());
            if (!parsed.isPresent() || current.equals(parsed.get())) continue;
            return false;
        }
        return true;
    }

    public static BlockIngredient single(class_2248 block) {
        return new Single(block, Map.of());
    }

    public static BlockIngredient tag(class_6862<class_2248> tag) {
        return new Tag(tag, Map.of());
    }

    public abstract void toPacket(class_2540 var1);

    public abstract JsonElement toJson();

    public abstract Either<class_2248, class_6862<class_2248>> getValue();

    private static final class Tag
    extends BlockIngredient {
        private final class_6862<class_2248> tag;

        private Tag(class_6862<class_2248> tag, Map<String, String> properties) {
            super(properties);
            this.tag = tag;
        }

        @Override
        public boolean test(class_2680 state) {
            return state.method_41520().method_40220(this.tag) && this.stateMatches(state);
        }

        @Override
        public void toPacket(class_2540 buf) {
            buf.method_34063(this.properties, class_2540::method_10814, class_2540::method_10814);
            buf.writeByte(1);
            buf.method_10812(this.tag.comp_327());
        }

        @Override
        public JsonElement toJson() {
            if (this.properties.isEmpty()) {
                return new JsonPrimitive("#" + this.tag.comp_327().toString());
            }
            JsonObject json = new JsonObject();
            json.addProperty("id", "#" + this.tag.comp_327().toString());
            JsonObject states = new JsonObject();
            this.properties.forEach((arg_0, arg_1) -> ((JsonObject)states).addProperty(arg_0, arg_1));
            json.add("states", (JsonElement)states);
            return json;
        }

        @Override
        public Either<class_2248, class_6862<class_2248>> getValue() {
            return Either.right(this.tag);
        }
    }

    private static final class Single
    extends BlockIngredient {
        private final class_2248 block;

        private Single(class_2248 block, Map<String, String> properties) {
            super(properties);
            this.block = block;
        }

        @Override
        public boolean test(class_2680 state) {
            return state.method_27852(this.block) && this.stateMatches(state);
        }

        @Override
        public void toPacket(class_2540 buf) {
            buf.method_34063(this.properties, class_2540::method_10814, class_2540::method_10814);
            buf.writeByte(0);
            buf.method_42065((class_2359)class_7923.field_41175, (Object)this.block);
        }

        @Override
        public JsonElement toJson() {
            if (this.properties.isEmpty()) {
                return new JsonPrimitive(class_7923.field_41175.method_10221((Object)this.block).toString());
            }
            JsonObject json = new JsonObject();
            json.addProperty("id", class_7923.field_41175.method_10221((Object)this.block).toString());
            JsonObject states = new JsonObject();
            this.properties.forEach((arg_0, arg_1) -> ((JsonObject)states).addProperty(arg_0, arg_1));
            json.add("states", (JsonElement)states);
            return json;
        }

        @Override
        public Either<class_2248, class_6862<class_2248>> getValue() {
            return Either.left((Object)this.block);
        }
    }
}

