/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.recipe.witchwater;

import com.google.gson.JsonObject;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;
import wraith.fabricaeexnihilo.recipe.BaseRecipe;
import wraith.fabricaeexnihilo.recipe.ModRecipes;
import wraith.fabricaeexnihilo.recipe.RecipeContext;
import wraith.fabricaeexnihilo.recipe.util.FluidIngredient;
import wraith.fabricaeexnihilo.recipe.util.WeightedList;
import wraith.fabricaeexnihilo.util.CodecUtils;

public class WitchWaterWorldRecipe
extends BaseRecipe<Context> {
    private final FluidIngredient target;
    private final WeightedList result;

    public WitchWaterWorldRecipe(class_2960 id, FluidIngredient target, WeightedList result) {
        super(id);
        this.target = target;
        this.result = result;
    }

    public static Optional<WitchWaterWorldRecipe> find(class_3611 fluid, @Nullable class_1937 world) {
        if (world == null) {
            return Optional.empty();
        }
        return world.method_8433().method_8132(ModRecipes.WITCH_WATER_WORLD, (class_1263)new Context(fluid), world);
    }

    @Override
    public boolean matches(Context context, class_1937 world) {
        return this.target.test(context.fluid);
    }

    public class_1865<?> method_8119() {
        return ModRecipes.WITCH_WATER_WORLD_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return ModRecipes.WITCH_WATER_WORLD;
    }

    @Override
    public class_1799 getDisplayStack() {
        return this.result.asListOfStacks().get(0);
    }

    public FluidIngredient getTarget() {
        return this.target;
    }

    public WeightedList getResult() {
        return this.result;
    }

    protected record Context(class_3611 fluid) implements RecipeContext
    {
    }

    public static class Serializer
    implements class_1865<WitchWaterWorldRecipe> {
        public WitchWaterWorldRecipe read(class_2960 id, JsonObject json) {
            FluidIngredient target = FluidIngredient.fromJson(class_3518.method_52226((JsonObject)json, (String)"target"));
            WeightedList result = CodecUtils.fromJson(WeightedList.CODEC, class_3518.method_52226((JsonObject)json, (String)"result"));
            return new WitchWaterWorldRecipe(id, target, result);
        }

        public WitchWaterWorldRecipe read(class_2960 id, class_2540 buf) {
            FluidIngredient target = FluidIngredient.fromPacket(buf);
            WeightedList result = CodecUtils.fromPacket(WeightedList.CODEC, buf);
            return new WitchWaterWorldRecipe(id, target, result);
        }

        public void write(class_2540 buf, WitchWaterWorldRecipe recipe) {
            recipe.target.toPacket(buf);
            CodecUtils.toPacket(WeightedList.CODEC, recipe.result, buf);
        }
    }
}

