/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentType;
import io.ktor.http.ContentTypesKt;
import io.ktor.http.Cookie;
import io.ktor.http.CookieKt;
import io.ktor.http.HeaderValue;
import io.ktor.http.HttpHeaderValueParserKt;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMessage;
import io.ktor.http.HttpMessageBuilder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\u001a\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0019\u0010\u0007\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006*\u00020\u0000\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u0019\u0010\u0007\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006*\u00020\t\u00a2\u0006\u0004\b\u0007\u0010\n\u001a!\u0010\u0007\u001a\u0004\u0018\u00010\u000b*\u00020\t2\n\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006H\u0007\u00a2\u0006\u0004\b\u0007\u0010\f\u001a\u0013\u0010\u000e\u001a\u0004\u0018\u00010\r*\u00020\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u0013\u0010\u000e\u001a\u0004\u0018\u00010\r*\u00020\t\u00a2\u0006\u0004\b\u000e\u0010\u0010\u001a\u001b\u0010\u000e\u001a\u00020\u000b*\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u000e\u0010\u0013\u001a\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u0014*\u00020\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u0014*\u00020\t\u00a2\u0006\u0004\b\u0015\u0010\u0017\u001a\u0019\u0010\u0015\u001a\u00020\u000b*\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0019\u001a\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0001*\u00020\t\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001a\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u001d*\u00020\u0000\u00a2\u0006\u0004\b\u001e\u0010\u001f\u001a\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u001d*\u00020\t\u00a2\u0006\u0004\b\u001e\u0010 \u001a\u0019\u0010\"\u001a\u00020\u000b*\u00020\t2\u0006\u0010!\u001a\u00020\u001d\u00a2\u0006\u0004\b\"\u0010#\u001a\u0019\u0010%\u001a\u00020\u000b*\u00020\t2\u0006\u0010$\u001a\u00020\u0011\u00a2\u0006\u0004\b%\u0010\u0013\u001a\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0001*\u00020\u0000\u00a2\u0006\u0004\b&\u0010\u0004\u001a\u0019\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0001*\u00020\u001dH\u0000\u00a2\u0006\u0004\b'\u0010(\u001a\u0019\u0010*\u001a\u00020\u000b*\u00020\t2\u0006\u0010)\u001a\u00020\u001d\u00a2\u0006\u0004\b*\u0010#\u001a\u0019\u0010+\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u0001*\u00020\u0000\u00a2\u0006\u0004\b+\u0010\u0004\u001a\u0019\u0010+\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u0001*\u00020\t\u00a2\u0006\u0004\b+\u0010\u001c\u00a8\u0006,"}, d2={"Lio/ktor/http/HttpMessage;", "", "Lio/ktor/http/HeaderValue;", "cacheControl", "(Lio/ktor/http/HttpMessage;)Ljava/util/List;", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "charset", "(Lio/ktor/http/HttpMessage;)Ljava/nio/charset/Charset;", "Lio/ktor/http/HttpMessageBuilder;", "(Lio/ktor/http/HttpMessageBuilder;)Ljava/nio/charset/Charset;", "", "(Lio/ktor/http/HttpMessageBuilder;Ljava/nio/charset/Charset;)Lkotlin/Unit;", "", "contentLength", "(Lio/ktor/http/HttpMessage;)Ljava/lang/Long;", "(Lio/ktor/http/HttpMessageBuilder;)Ljava/lang/Long;", "", "length", "(Lio/ktor/http/HttpMessageBuilder;I)V", "Lio/ktor/http/ContentType;", "contentType", "(Lio/ktor/http/HttpMessage;)Lio/ktor/http/ContentType;", "(Lio/ktor/http/HttpMessageBuilder;)Lio/ktor/http/ContentType;", "type", "(Lio/ktor/http/HttpMessageBuilder;Lio/ktor/http/ContentType;)V", "Lio/ktor/http/Cookie;", "cookies", "(Lio/ktor/http/HttpMessageBuilder;)Ljava/util/List;", "", "etag", "(Lio/ktor/http/HttpMessage;)Ljava/lang/String;", "(Lio/ktor/http/HttpMessageBuilder;)Ljava/lang/String;", "value", "ifNoneMatch", "(Lio/ktor/http/HttpMessageBuilder;Ljava/lang/String;)V", "seconds", "maxAge", "setCookie", "splitSetCookieHeader", "(Ljava/lang/String;)Ljava/util/List;", "content", "userAgent", "vary", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nHttpMessageProperties.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpMessageProperties.kt\nio/ktor/http/HttpMessagePropertiesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n1#2:169\n1549#3:170\n1620#3,3:171\n1549#3:174\n1620#3,3:175\n1360#3:178\n1446#3,5:179\n1549#3:184\n1620#3,3:185\n1549#3:188\n1620#3,3:189\n*S KotlinDebug\n*F\n+ 1 HttpMessageProperties.kt\nio/ktor/http/HttpMessagePropertiesKt\n*L\n64#1:170\n64#1:171,3\n89#1:174\n89#1:175,3\n100#1:178\n100#1:179,5\n101#1:184\n101#1:185,3\n108#1:188\n108#1:189,3\n*E\n"})
public final class HttpMessagePropertiesKt {
    public static final void contentType(@NotNull HttpMessageBuilder $this$contentType, @NotNull ContentType type) {
        Intrinsics.checkNotNullParameter((Object)$this$contentType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        $this$contentType.getHeaders().set(HttpHeaders.INSTANCE.getContentType(), type.toString());
    }

    @Deprecated(message="Content-Length is controlled by underlying engine. Don't specify it explicitly.", level=DeprecationLevel.ERROR)
    public static final void contentLength(@NotNull HttpMessageBuilder $this$contentLength, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$contentLength, (String)"<this>");
        $this$contentLength.getHeaders().set(HttpHeaders.INSTANCE.getContentLength(), String.valueOf(length));
    }

    @Deprecated(message="Use content with particular content type and charset instead", level=DeprecationLevel.ERROR)
    @Nullable
    public static final Unit charset(@NotNull HttpMessageBuilder $this$charset, @NotNull Charset charset) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)$this$charset, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        ContentType contentType2 = HttpMessagePropertiesKt.contentType($this$charset);
        if (contentType2 != null) {
            ContentType it = contentType2;
            boolean bl = false;
            HttpMessagePropertiesKt.contentType($this$charset, ContentTypesKt.withCharset(it, charset));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public static final void maxAge(@NotNull HttpMessageBuilder $this$maxAge, int seconds) {
        Intrinsics.checkNotNullParameter((Object)$this$maxAge, (String)"<this>");
        $this$maxAge.getHeaders().append(HttpHeaders.INSTANCE.getCacheControl(), "max-age=" + seconds);
    }

    public static final void ifNoneMatch(@NotNull HttpMessageBuilder $this$ifNoneMatch, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$ifNoneMatch, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        $this$ifNoneMatch.getHeaders().set(HttpHeaders.INSTANCE.getIfNoneMatch(), value);
    }

    public static final void userAgent(@NotNull HttpMessageBuilder $this$userAgent, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)$this$userAgent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        $this$userAgent.getHeaders().set(HttpHeaders.INSTANCE.getUserAgent(), content);
    }

    @Nullable
    public static final ContentType contentType(@NotNull HttpMessageBuilder $this$contentType) {
        ContentType contentType2;
        Intrinsics.checkNotNullParameter((Object)$this$contentType, (String)"<this>");
        String string = $this$contentType.getHeaders().get(HttpHeaders.INSTANCE.getContentType());
        if (string != null) {
            String it = string;
            boolean bl = false;
            contentType2 = ContentType.Companion.parse(it);
        } else {
            contentType2 = null;
        }
        return contentType2;
    }

    @Nullable
    public static final Charset charset(@NotNull HttpMessageBuilder $this$charset) {
        Intrinsics.checkNotNullParameter((Object)$this$charset, (String)"<this>");
        ContentType contentType2 = HttpMessagePropertiesKt.contentType($this$charset);
        return contentType2 != null ? ContentTypesKt.charset(contentType2) : null;
    }

    @Nullable
    public static final String etag(@NotNull HttpMessageBuilder $this$etag) {
        Intrinsics.checkNotNullParameter((Object)$this$etag, (String)"<this>");
        return $this$etag.getHeaders().get(HttpHeaders.INSTANCE.getETag());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final List<String> vary(@NotNull HttpMessageBuilder $this$vary) {
        List list;
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)$this$vary, (String)"<this>");
        Object object = $this$vary.getHeaders().get(HttpHeaders.INSTANCE.getVary());
        if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{","}), (boolean)false, (int)0, (int)6, null)) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    public static final Long contentLength(@NotNull HttpMessageBuilder $this$contentLength) {
        Intrinsics.checkNotNullParameter((Object)$this$contentLength, (String)"<this>");
        String string = $this$contentLength.getHeaders().get(HttpHeaders.INSTANCE.getContentLength());
        return string != null ? Long.valueOf(Long.parseLong(string)) : null;
    }

    @Nullable
    public static final ContentType contentType(@NotNull HttpMessage $this$contentType) {
        ContentType contentType2;
        Intrinsics.checkNotNullParameter((Object)$this$contentType, (String)"<this>");
        String string = $this$contentType.getHeaders().get(HttpHeaders.INSTANCE.getContentType());
        if (string != null) {
            String it = string;
            boolean bl = false;
            contentType2 = ContentType.Companion.parse(it);
        } else {
            contentType2 = null;
        }
        return contentType2;
    }

    @Nullable
    public static final Charset charset(@NotNull HttpMessage $this$charset) {
        Intrinsics.checkNotNullParameter((Object)$this$charset, (String)"<this>");
        ContentType contentType2 = HttpMessagePropertiesKt.contentType($this$charset);
        return contentType2 != null ? ContentTypesKt.charset(contentType2) : null;
    }

    @Nullable
    public static final String etag(@NotNull HttpMessage $this$etag) {
        Intrinsics.checkNotNullParameter((Object)$this$etag, (String)"<this>");
        return $this$etag.getHeaders().get(HttpHeaders.INSTANCE.getETag());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final List<String> vary(@NotNull HttpMessage $this$vary) {
        List list;
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)$this$vary, (String)"<this>");
        Object object = $this$vary.getHeaders().get(HttpHeaders.INSTANCE.getVary());
        if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{","}), (boolean)false, (int)0, (int)6, null)) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    public static final Long contentLength(@NotNull HttpMessage $this$contentLength) {
        Intrinsics.checkNotNullParameter((Object)$this$contentLength, (String)"<this>");
        String string = $this$contentLength.getHeaders().get(HttpHeaders.INSTANCE.getContentLength());
        return string != null ? Long.valueOf(Long.parseLong(string)) : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Cookie> setCookie(@NotNull HttpMessage $this$setCookie) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$setCookie, (String)"<this>");
        List<String> list2 = $this$setCookie.getHeaders().getAll(HttpHeaders.INSTANCE.getSetCookie());
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = list2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = HttpMessagePropertiesKt.splitSetCookieHeader(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String bl = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(CookieKt.parseServerSetCookieHeader((String)it));
            }
            list = (List)destination$iv$iv2;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Cookie> cookies(@NotNull HttpMessageBuilder $this$cookies) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$cookies, (String)"<this>");
        List<String> list2 = $this$cookies.getHeaders().getAll(HttpHeaders.INSTANCE.getSetCookie());
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(CookieKt.parseServerSetCookieHeader((String)it));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public static final List<HeaderValue> cacheControl(@NotNull HttpMessage $this$cacheControl) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$cacheControl, (String)"<this>");
                object = $this$cacheControl.getHeaders().get(HttpHeaders.INSTANCE.getCacheControl());
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                List<HeaderValue> list = HttpHeaderValueParserKt.parseHeaderValue(it);
                object = list;
                if (list != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public static final List<String> splitSetCookieHeader(@NotNull String $this$splitSetCookieHeader) {
        Intrinsics.checkNotNullParameter((Object)$this$splitSetCookieHeader, (String)"<this>");
        int comma = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, (char)',', (int)0, (boolean)false, (int)6, null);
        if (comma == -1) {
            return CollectionsKt.listOf((Object)$this$splitSetCookieHeader);
        }
        List result2 = new ArrayList();
        int current = 0;
        int equals = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, (char)'=', (int)comma, (boolean)false, (int)4, null);
        int semicolon = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, (char)';', (int)comma, (boolean)false, (int)4, null);
        while (current < $this$splitSetCookieHeader.length() && comma > 0) {
            int nextComma;
            block11: {
                block10: {
                    if (equals < comma) {
                        equals = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, (char)'=', (int)comma, (boolean)false, (int)4, null);
                    }
                    nextComma = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, (char)',', (int)(comma + 1), (boolean)false, (int)4, null);
                    while (nextComma >= 0 && nextComma < equals) {
                        comma = nextComma;
                        nextComma = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, (char)',', (int)(nextComma + 1), (boolean)false, (int)4, null);
                    }
                    if (semicolon < comma) {
                        semicolon = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, (char)';', (int)comma, (boolean)false, (int)4, null);
                    }
                    if (equals < 0) {
                        Collection collection = result2;
                        String string = $this$splitSetCookieHeader.substring(current);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                        collection.add(string);
                        return result2;
                    }
                    if (semicolon == -1) break block10;
                    if (semicolon <= equals) break block11;
                }
                Collection collection = result2;
                String string = $this$splitSetCookieHeader.substring(current, comma);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                collection.add(string);
                current = comma + 1;
            }
            comma = nextComma;
        }
        if (current < $this$splitSetCookieHeader.length()) {
            Collection collection = result2;
            String string = $this$splitSetCookieHeader.substring(current);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            collection.add(string);
        }
        return result2;
    }
}

