/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentRange;
import io.ktor.http.RangeUnits;
import io.ktor.http.RangesKt;
import io.ktor.http.RangesSpecifier;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\t\u001a\u00020)\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b*\u0010+B\u001f\u0012\b\b\u0002\u0010\t\u001a\u00020\u0002\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b*\u0010,J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ*\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\t\u001a\u00020\u00022\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\u000f\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0012\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J#\u0010\u0016\u001a\u00020\u000e2\u0014\b\u0002\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000e0\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001b\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00052\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001b\u0010\u001cJ%\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00052\u0006\u0010\u0019\u001a\u00020\u00182\b\b\u0002\u0010\u001d\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001b\u0010\u001eJ\u0017\u0010\u001f\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010!\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b!\u0010\u0004J!\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\"\u0004\b\u0000\u0010\"*\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0004\b#\u0010$R\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006\u00a2\u0006\f\n\u0004\b\n\u0010%\u001a\u0004\b&\u0010\bR\u0017\u0010\t\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\t\u0010'\u001a\u0004\b(\u0010\u0004\u00a8\u0006-"}, d2={"Lio/ktor/http/RangesSpecifier;", "", "", "component1", "()Ljava/lang/String;", "", "Lio/ktor/http/ContentRange;", "component2", "()Ljava/util/List;", "unit", "ranges", "copy", "(Ljava/lang/String;Ljava/util/List;)Lio/ktor/http/RangesSpecifier;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Lkotlin/Function1;", "rangeUnitPredicate", "isValid", "(Lkotlin/jvm/functions/Function1;)Z", "", "length", "Lkotlin/ranges/LongRange;", "merge", "(J)Ljava/util/List;", "maxRangeCount", "(JI)Ljava/util/List;", "mergeToSingle", "(J)Lkotlin/ranges/LongRange;", "toString", "T", "toList", "(Ljava/lang/Object;)Ljava/util/List;", "Ljava/util/List;", "getRanges", "Ljava/lang/String;", "getUnit", "Lio/ktor/http/RangeUnits;", "<init>", "(Lio/ktor/http/RangeUnits;Ljava/util/List;)V", "(Ljava/lang/String;Ljava/util/List;)V", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nRangesSpecifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RangesSpecifier.kt\nio/ktor/http/RangesSpecifier\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1#2:73\n2624#3,3:74\n2333#3,14:77\n1963#3,14:91\n*S KotlinDebug\n*F\n+ 1 RangesSpecifier.kt\nio/ktor/http/RangesSpecifier\n*L\n24#1:74,3\n62#1:77,14\n63#1:91,14\n*E\n"})
public final class RangesSpecifier {
    @NotNull
    private final String unit;
    @NotNull
    private final List<ContentRange> ranges;

    public RangesSpecifier(@NotNull String unit, @NotNull List<? extends ContentRange> ranges) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        this.unit = unit;
        this.ranges = ranges;
        if (!(!((Collection)this.ranges).isEmpty())) {
            boolean bl = false;
            String string = "It should be at least one range";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ RangesSpecifier(String string, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = RangeUnits.Bytes.getUnitToken();
        }
        this(string, (List<? extends ContentRange>)list);
    }

    @NotNull
    public final String getUnit() {
        return this.unit;
    }

    @NotNull
    public final List<ContentRange> getRanges() {
        return this.ranges;
    }

    public RangesSpecifier(@NotNull RangeUnits unit, @NotNull List<? extends ContentRange> ranges) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        this(unit.getUnitToken(), ranges);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isValid(@NotNull Function1<? super String, Boolean> rangeUnitPredicate) {
        boolean bl;
        Intrinsics.checkNotNullParameter(rangeUnitPredicate, (String)"rangeUnitPredicate");
        if ((Boolean)rangeUnitPredicate.invoke((Object)this.unit) == false) return false;
        Iterable $this$none$iv = this.ranges;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$none$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            ContentRange it = (ContentRange)element$iv;
            boolean bl2 = false;
            ContentRange contentRange = it;
            if (contentRange instanceof ContentRange.Bounded) {
                if (((ContentRange.Bounded)it).getFrom() < 0L) return false;
                if (((ContentRange.Bounded)it).getTo() < ((ContentRange.Bounded)it).getFrom()) {
                    return false;
                }
                bl = false;
                continue;
            }
            if (contentRange instanceof ContentRange.TailFrom) {
                if (((ContentRange.TailFrom)it).getFrom() < 0L) {
                    return false;
                }
                bl = false;
                continue;
            }
            if (!(contentRange instanceof ContentRange.Suffix)) throw new NoWhenBranchMatchedException();
            if (((ContentRange.Suffix)it).getLastCount() < 0L) {
                return false;
            }
            bl = false;
        } while (!bl);
        return false;
    }

    public static /* synthetic */ boolean isValid$default(RangesSpecifier rangesSpecifier, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = isValid.1.INSTANCE;
        }
        return rangesSpecifier.isValid((Function1<? super String, Boolean>)function1);
    }

    @NotNull
    public final List<LongRange> merge(long length, int maxRangeCount) {
        if (this.ranges.size() > maxRangeCount) {
            return this.toList(this.mergeToSingle(length));
        }
        return this.merge(length);
    }

    public static /* synthetic */ List merge$default(RangesSpecifier rangesSpecifier, long l, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 50;
        }
        return rangesSpecifier.merge(l, n);
    }

    @NotNull
    public final List<LongRange> merge(long length) {
        return RangesKt.mergeRangesKeepOrder(RangesKt.toLongRanges(this.ranges, length));
    }

    @Nullable
    public final LongRange mergeToSingle(long length) {
        Object v1;
        Object v0;
        List<LongRange> mapped = RangesKt.toLongRanges(this.ranges, length);
        if (mapped.isEmpty()) {
            return null;
        }
        Iterable $this$minByOrNull$iv = mapped;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                LongRange it = (LongRange)minElem$iv;
                boolean bl = false;
                long minValue$iv = it.getStart();
                do {
                    Object e$iv = iterator$iv.next();
                    LongRange it2 = (LongRange)e$iv;
                    $i$a$-minByOrNull-RangesSpecifier$mergeToSingle$start$1 = false;
                    long v$iv = it2.getStart();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        Intrinsics.checkNotNull(v0);
        long start2 = ((LongRange)v0).getStart();
        Iterable $this$maxByOrNull$iv = mapped;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv2 = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv2.hasNext()) {
            v1 = null;
        } else {
            Object maxElem$iv = iterator$iv2.next();
            if (!iterator$iv2.hasNext()) {
                v1 = maxElem$iv;
            } else {
                LongRange it = (LongRange)maxElem$iv;
                boolean bl = false;
                long maxValue$iv = it.getEndInclusive();
                do {
                    Object e$iv = iterator$iv2.next();
                    LongRange it3 = (LongRange)e$iv;
                    $i$a$-maxByOrNull-RangesSpecifier$mergeToSingle$endInclusive$1 = false;
                    long v$iv = it3.getEndInclusive();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv2.hasNext());
                v1 = maxElem$iv;
            }
        }
        Intrinsics.checkNotNull(v1);
        long endInclusive = kotlin.ranges.RangesKt.coerceAtMost((long)((LongRange)v1).getEndInclusive(), (long)(length - 1L));
        return new LongRange(start2, endInclusive);
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.ranges, (CharSequence)",", (CharSequence)(this.unit + '='), null, (int)0, null, null, (int)60, null);
    }

    private final <T> List<T> toList(T $this$toList) {
        T t = $this$toList;
        return t == null ? CollectionsKt.emptyList() : CollectionsKt.listOf(t);
    }

    @NotNull
    public final String component1() {
        return this.unit;
    }

    @NotNull
    public final List<ContentRange> component2() {
        return this.ranges;
    }

    @NotNull
    public final RangesSpecifier copy(@NotNull String unit, @NotNull List<? extends ContentRange> ranges) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        return new RangesSpecifier(unit, ranges);
    }

    public static /* synthetic */ RangesSpecifier copy$default(RangesSpecifier rangesSpecifier, String string, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = rangesSpecifier.unit;
        }
        if ((n & 2) != 0) {
            list = rangesSpecifier.ranges;
        }
        return rangesSpecifier.copy(string, list);
    }

    public int hashCode() {
        int result2 = this.unit.hashCode();
        result2 = result2 * 31 + ((Object)this.ranges).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RangesSpecifier)) {
            return false;
        }
        RangesSpecifier rangesSpecifier = (RangesSpecifier)other;
        if (!Intrinsics.areEqual((Object)this.unit, (Object)rangesSpecifier.unit)) {
            return false;
        }
        return Intrinsics.areEqual(this.ranges, rangesSpecifier.ranges);
    }
}

