/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.sockets;

import io.ktor.network.selector.SelectableBase;
import io.ktor.network.selector.SelectorManager;
import io.ktor.network.sockets.CIOReaderKt;
import io.ktor.network.sockets.CIOWriterKt;
import io.ktor.network.sockets.ReadWriteSocket;
import io.ktor.network.sockets.SocketOptions;
import io.ktor.utils.io.ByteChannel;
import io.ktor.utils.io.ByteWriteChannel;
import io.ktor.utils.io.ByteWriteChannelKt;
import io.ktor.utils.io.ReaderJob;
import io.ktor.utils.io.WriterJob;
import io.ktor.utils.io.pool.ObjectPool;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\b \u0018\u0000*\u000e\b\u0000\u0010\u0003 \u0001*\u00020\u0001*\u00020\u00022\u00020\u00042\u00020\u00052\u00020\u0006B3\u0012\u0006\u0010\u000f\u001a\u00028\u0000\u0012\u0006\u00108\u001a\u000207\u0012\u000e\u00101\u001a\n\u0012\u0004\u0012\u000200\u0018\u00010/\u0012\n\b\u0002\u0010B\u001a\u0004\u0018\u00010A\u00a2\u0006\u0004\bN\u0010OJ\u0011\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0004\b\b\u0010\tJG\u0010\u0014\u001a\u00028\u0001\"\b\b\u0001\u0010\u000b*\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001f\u0010\u001eJ%\u0010\"\u001a\u0004\u0018\u00010\u00072\b\u0010 \u001a\u0004\u0018\u00010\u00072\b\u0010!\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0004\b\"\u0010#J\u000f\u0010$\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b$\u0010\u001eR\u001a\u0010\u000f\u001a\u00028\u00008\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000f\u0010%\u001a\u0004\b&\u0010'R\u0014\u0010)\u001a\u00020(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0014\u0010.\u001a\u00020+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u001f\u00101\u001a\n\u0012\u0004\u0012\u000200\u0018\u00010/8\u0006\u00a2\u0006\f\n\u0004\b1\u00102\u001a\u0004\b3\u00104R\u001c\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00106R\u0017\u00108\u001a\u0002078\u0006\u00a2\u0006\f\n\u0004\b8\u00109\u001a\u0004\b:\u0010;R\u001a\u0010=\u001a\u00020<8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b=\u0010>\u001a\u0004\b?\u0010@R\u0016\u0010B\u001a\u0004\u0018\u00010A8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bB\u0010CR\u001c\u0010D\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bD\u00106R\"\u0010H\u001a\u00020E*\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\n0\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010GR*\u0010M\u001a\u0004\u0018\u00010\u0007*\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\n0\u00108BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\bK\u0010L\u001a\u0004\bI\u0010J\u00a8\u0006P"}, d2={"Lio/ktor/network/sockets/NIOSocketImpl;", "Ljava/nio/channels/ByteChannel;", "Ljava/nio/channels/SelectableChannel;", "S", "Lio/ktor/network/sockets/ReadWriteSocket;", "Lio/ktor/network/selector/SelectableBase;", "Lkotlinx/coroutines/CoroutineScope;", "", "actualClose", "()Ljava/lang/Throwable;", "Lkotlinx/coroutines/Job;", "J", "", "name", "Lio/ktor/utils/io/ByteChannel;", "channel", "Ljava/util/concurrent/atomic/AtomicReference;", "ref", "Lkotlin/Function0;", "producer", "attachFor", "(Ljava/lang/String;Lio/ktor/utils/io/ByteChannel;Ljava/util/concurrent/atomic/AtomicReference;Lkotlin/jvm/functions/Function0;)Lkotlinx/coroutines/Job;", "Lio/ktor/utils/io/WriterJob;", "attachForReading", "(Lio/ktor/utils/io/ByteChannel;)Lio/ktor/utils/io/WriterJob;", "Lio/ktor/utils/io/ReaderJob;", "attachForWriting", "(Lio/ktor/utils/io/ByteChannel;)Lio/ktor/utils/io/ReaderJob;", "", "checkChannels", "()V", "close", "e1", "e2", "combine", "(Ljava/lang/Throwable;Ljava/lang/Throwable;)Ljava/lang/Throwable;", "dispose", "Ljava/nio/channels/SelectableChannel;", "getChannel", "()Ljava/nio/channels/SelectableChannel;", "Ljava/util/concurrent/atomic/AtomicBoolean;", "closeFlag", "Ljava/util/concurrent/atomic/AtomicBoolean;", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "coroutineContext", "Lio/ktor/utils/io/pool/ObjectPool;", "Ljava/nio/ByteBuffer;", "pool", "Lio/ktor/utils/io/pool/ObjectPool;", "getPool", "()Lio/ktor/utils/io/pool/ObjectPool;", "readerJob", "Ljava/util/concurrent/atomic/AtomicReference;", "Lio/ktor/network/selector/SelectorManager;", "selector", "Lio/ktor/network/selector/SelectorManager;", "getSelector", "()Lio/ktor/network/selector/SelectorManager;", "Lkotlinx/coroutines/CompletableJob;", "socketContext", "Lkotlinx/coroutines/CompletableJob;", "getSocketContext", "()Lkotlinx/coroutines/CompletableJob;", "Lio/ktor/network/sockets/SocketOptions$TCPClientSocketOptions;", "socketOptions", "Lio/ktor/network/sockets/SocketOptions$TCPClientSocketOptions;", "writerJob", "", "getCompletedOrNotStarted", "(Ljava/util/concurrent/atomic/AtomicReference;)Z", "completedOrNotStarted", "getException", "(Ljava/util/concurrent/atomic/AtomicReference;)Ljava/lang/Throwable;", "getException$annotations", "(Ljava/util/concurrent/atomic/AtomicReference;)V", "exception", "<init>", "(Ljava/nio/channels/SelectableChannel;Lio/ktor/network/selector/SelectorManager;Lio/ktor/utils/io/pool/ObjectPool;Lio/ktor/network/sockets/SocketOptions$TCPClientSocketOptions;)V", "ktor-network"})
@SourceDebugExtension(value={"SMAP\nNIOSocketImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NIOSocketImpl.kt\nio/ktor/network/sockets/NIOSocketImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n1#2:146\n*E\n"})
public abstract class NIOSocketImpl<S extends SelectableChannel>
extends SelectableBase
implements ReadWriteSocket,
CoroutineScope {
    @NotNull
    private final S channel;
    @NotNull
    private final SelectorManager selector;
    @Nullable
    private final ObjectPool<ByteBuffer> pool;
    @Nullable
    private final SocketOptions.TCPClientSocketOptions socketOptions;
    @NotNull
    private final AtomicBoolean closeFlag;
    @NotNull
    private final AtomicReference<ReaderJob> readerJob;
    @NotNull
    private final AtomicReference<WriterJob> writerJob;
    @NotNull
    private final CompletableJob socketContext;

    public NIOSocketImpl(@NotNull S channel, @NotNull SelectorManager selector, @Nullable ObjectPool<ByteBuffer> pool, @Nullable SocketOptions.TCPClientSocketOptions socketOptions) {
        Intrinsics.checkNotNullParameter(channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        super((SelectableChannel)channel);
        this.channel = channel;
        this.selector = selector;
        this.pool = pool;
        this.socketOptions = socketOptions;
        this.closeFlag = new AtomicBoolean();
        this.readerJob = new AtomicReference();
        this.writerJob = new AtomicReference();
        this.socketContext = JobKt.Job$default(null, (int)1, null);
    }

    public /* synthetic */ NIOSocketImpl(SelectableChannel selectableChannel, SelectorManager selectorManager, ObjectPool objectPool, SocketOptions.TCPClientSocketOptions tCPClientSocketOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            tCPClientSocketOptions = null;
        }
        this(selectableChannel, selectorManager, objectPool, tCPClientSocketOptions);
    }

    @NotNull
    public S getChannel() {
        return this.channel;
    }

    @NotNull
    public final SelectorManager getSelector() {
        return this.selector;
    }

    @Nullable
    public final ObjectPool<ByteBuffer> getPool() {
        return this.pool;
    }

    @NotNull
    public CompletableJob getSocketContext() {
        return this.socketContext;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return (CoroutineContext)this.getSocketContext();
    }

    @Override
    @NotNull
    public final WriterJob attachForReading(@NotNull ByteChannel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        return this.attachFor("reading", channel, this.writerJob, (Function0)new Function0<WriterJob>(this, channel){
            final /* synthetic */ NIOSocketImpl<S> this$0;
            final /* synthetic */ ByteChannel $channel;
            {
                this.this$0 = $receiver;
                this.$channel = $channel;
                super(0);
            }

            @NotNull
            public final WriterJob invoke() {
                return this.this$0.getPool() != null ? CIOReaderKt.attachForReadingImpl(this.this$0, this.$channel, (ReadableByteChannel)this.this$0.getChannel(), this.this$0, this.this$0.getSelector(), this.this$0.getPool(), NIOSocketImpl.access$getSocketOptions$p(this.this$0)) : CIOReaderKt.attachForReadingDirectImpl(this.this$0, this.$channel, (ReadableByteChannel)this.this$0.getChannel(), this.this$0, this.this$0.getSelector(), NIOSocketImpl.access$getSocketOptions$p(this.this$0));
            }
        });
    }

    @Override
    @NotNull
    public final ReaderJob attachForWriting(@NotNull ByteChannel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        return this.attachFor("writing", channel, this.readerJob, (Function0)new Function0<ReaderJob>(this, channel){
            final /* synthetic */ NIOSocketImpl<S> this$0;
            final /* synthetic */ ByteChannel $channel;
            {
                this.this$0 = $receiver;
                this.$channel = $channel;
                super(0);
            }

            @NotNull
            public final ReaderJob invoke() {
                return CIOWriterKt.attachForWritingDirectImpl(this.this$0, this.$channel, (WritableByteChannel)this.this$0.getChannel(), this.this$0, this.this$0.getSelector(), NIOSocketImpl.access$getSocketOptions$p(this.this$0));
            }
        });
    }

    @Override
    public void dispose() {
        this.close();
    }

    @Override
    public void close() {
        if (!this.closeFlag.compareAndSet(false, true)) {
            return;
        }
        Object object = this.readerJob.get();
        if (object != null && (object = object.getChannel()) != null) {
            ByteWriteChannelKt.close((ByteWriteChannel)object);
        }
        WriterJob writerJob2 = this.writerJob.get();
        if (writerJob2 != null) {
            Job.DefaultImpls.cancel$default((Job)writerJob2, null, (int)1, null);
        }
        this.checkChannels();
    }

    private final <J extends Job> J attachFor(String name, ByteChannel channel, AtomicReference<J> ref, Function0<? extends J> producer) {
        if (this.closeFlag.get()) {
            ClosedChannelException e = new ClosedChannelException();
            channel.close(e);
            throw e;
        }
        Job j = (Job)producer.invoke();
        if (!ref.compareAndSet(null, j)) {
            IllegalStateException e = new IllegalStateException(name + " channel has already been set");
            Job.DefaultImpls.cancel$default((Job)j, null, (int)1, null);
            throw e;
        }
        if (this.closeFlag.get()) {
            ClosedChannelException e = new ClosedChannelException();
            Job.DefaultImpls.cancel$default((Job)j, null, (int)1, null);
            channel.close(e);
            throw e;
        }
        channel.attachJob(j);
        j.invokeOnCompletion((Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ NIOSocketImpl<S> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable Throwable it) {
                NIOSocketImpl.access$checkChannels(this.this$0);
            }
        });
        return (J)j;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Throwable actualClose() {
        Throwable throwable;
        try {
            ((java.nio.channels.ByteChannel)this.getChannel()).close();
            super.close();
            throwable = null;
        }
        catch (Throwable cause) {
            throwable = cause;
        }
        finally {
            this.selector.notifyClosed(this);
        }
        return throwable;
    }

    private final void checkChannels() {
        if (this.closeFlag.get() && this.getCompletedOrNotStarted(this.readerJob) && this.getCompletedOrNotStarted(this.writerJob)) {
            Throwable e1 = this.getException(this.readerJob);
            Throwable e2 = this.getException(this.writerJob);
            Throwable e3 = this.actualClose();
            Throwable combined = this.combine(this.combine(e1, e2), e3);
            if (combined == null) {
                this.getSocketContext().complete();
            } else {
                this.getSocketContext().completeExceptionally(combined);
            }
        }
    }

    private final Throwable combine(Throwable e1, Throwable e2) {
        Throwable throwable;
        if (e1 == null) {
            throwable = e2;
        } else if (e2 == null) {
            throwable = e1;
        } else if (e1 == e2) {
            throwable = e1;
        } else {
            ExceptionsKt.addSuppressed((Throwable)e1, (Throwable)e2);
            throwable = e1;
        }
        return throwable;
    }

    private final boolean getCompletedOrNotStarted(AtomicReference<? extends Job> $this$completedOrNotStarted) {
        Job it = $this$completedOrNotStarted.get();
        boolean bl = false;
        return it == null || it.isCompleted();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Throwable getException(AtomicReference<? extends Job> $this$exception) {
        Job job2 = $this$exception.get();
        if (job2 == null) return null;
        Object object = job2;
        Job it = object;
        boolean bl = false;
        if (!it.isCancelled()) return null;
        Job job3 = object;
        Job job4 = job3;
        if (job4 == null) return null;
        object = job4.getCancellationException();
        if (object == null) return null;
        Throwable throwable = ((Throwable)object).getCause();
        return throwable;
    }

    private static /* synthetic */ void getException$annotations(AtomicReference atomicReference) {
    }

    public static final /* synthetic */ SocketOptions.TCPClientSocketOptions access$getSocketOptions$p(NIOSocketImpl $this) {
        return $this.socketOptions;
    }

    public static final /* synthetic */ void access$checkChannels(NIOSocketImpl $this) {
        $this.checkChannels();
    }
}

