/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0016B\u001f\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J#\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0014\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lio/ktor/server/engine/OverridingClassLoader;", "Ljava/lang/ClassLoader;", "Ljava/io/Closeable;", "", "close", "()V", "", "name", "", "resolve", "Ljava/lang/Class;", "loadClass", "(Ljava/lang/String;Z)Ljava/lang/Class;", "Lio/ktor/server/engine/OverridingClassLoader$ChildURLClassLoader;", "childClassLoader", "Lio/ktor/server/engine/OverridingClassLoader$ChildURLClassLoader;", "", "Ljava/net/URL;", "classpath", "parentClassLoader", "<init>", "(Ljava/util/List;Ljava/lang/ClassLoader;)V", "ChildURLClassLoader", "ktor-server-host-common"})
@SourceDebugExtension(value={"SMAP\nOverridingClassLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OverridingClassLoader.kt\nio/ktor/server/engine/OverridingClassLoader\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,70:1\n37#2,2:71\n*S KotlinDebug\n*F\n+ 1 OverridingClassLoader.kt\nio/ktor/server/engine/OverridingClassLoader\n*L\n18#1:71,2\n*E\n"})
public final class OverridingClassLoader
extends ClassLoader
implements Closeable {
    @NotNull
    private final ChildURLClassLoader childClassLoader;

    public OverridingClassLoader(@NotNull List<URL> classpath, @Nullable ClassLoader parentClassLoader) {
        Intrinsics.checkNotNullParameter(classpath, (String)"classpath");
        super(parentClassLoader);
        Collection $this$toTypedArray$iv = classpath;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ClassLoader classLoader = this.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"parent");
        this.childClassLoader = new ChildURLClassLoader(thisCollection$iv.toArray(new URL[0]), classLoader);
    }

    @Override
    @NotNull
    protected synchronized Class<?> loadClass(@NotNull String name, boolean resolve) {
        Class<?> clazz;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        try {
            clazz = this.childClassLoader.findClass(name);
        }
        catch (ClassNotFoundException e) {
            Class<?> clazz2 = super.loadClass(name, resolve);
            Intrinsics.checkNotNullExpressionValue(clazz2, (String)"{\n        // didn't find\u2026lass(name, resolve)\n    }");
            clazz = clazz2;
        }
        return clazz;
    }

    @Override
    public void close() {
        this.childClassLoader.close();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001b\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001b\u0010\r\u001a\u0004\u0018\u00010\u00072\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\r\u0010\tJ\u001b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u0011\u0010\fR\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lio/ktor/server/engine/OverridingClassLoader$ChildURLClassLoader;", "Ljava/net/URLClassLoader;", "", "name", "Ljava/lang/Class;", "findClass", "(Ljava/lang/String;)Ljava/lang/Class;", "Ljava/net/URL;", "findResource", "(Ljava/lang/String;)Ljava/net/URL;", "Ljava/util/Enumeration;", "findResources", "(Ljava/lang/String;)Ljava/util/Enumeration;", "getResource", "Ljava/io/InputStream;", "getResourceAsStream", "(Ljava/lang/String;)Ljava/io/InputStream;", "getResources", "Ljava/lang/ClassLoader;", "realParent", "Ljava/lang/ClassLoader;", "", "urls", "<init>", "([Ljava/net/URL;Ljava/lang/ClassLoader;)V", "ktor-server-host-common"})
    private static final class ChildURLClassLoader
    extends URLClassLoader {
        @NotNull
        private final ClassLoader realParent;

        public ChildURLClassLoader(@NotNull URL[] urls, @NotNull ClassLoader realParent) {
            Intrinsics.checkNotNullParameter((Object)urls, (String)"urls");
            Intrinsics.checkNotNullParameter((Object)realParent, (String)"realParent");
            super(urls, (ClassLoader)null);
            this.realParent = realParent;
        }

        @Override
        @NotNull
        public Class<?> findClass(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Class<?> loaded = super.findLoadedClass(name);
            if (loaded != null) {
                return loaded;
            }
            try {
                Class<?> clazz = super.findClass(name);
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"super.findClass(name)");
                return clazz;
            }
            catch (ClassNotFoundException e) {
                Class<?> clazz = this.realParent.loadClass(name);
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"realParent.loadClass(name)");
                return clazz;
            }
        }

        @Override
        @NotNull
        public Enumeration<URL> getResources(@Nullable String name) {
            Enumeration<URL> enumeration = this.realParent.getResources(name);
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"realParent.getResources(name)");
            return enumeration;
        }

        @Override
        @Nullable
        public URL getResource(@Nullable String name) {
            return this.realParent.getResource(name);
        }

        @Override
        @Nullable
        public InputStream getResourceAsStream(@Nullable String name) {
            return this.realParent.getResourceAsStream(name);
        }

        @Override
        @Nullable
        public URL findResource(@Nullable String name) {
            return null;
        }

        @Override
        @NotNull
        public Enumeration<URL> findResources(@Nullable String name) {
            Enumeration<URL> enumeration = Collections.emptyEnumeration();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"emptyEnumeration()");
            return enumeration;
        }
    }
}

