/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.http.content;

import io.ktor.http.ContentType;
import io.ktor.http.FileContentTypeJvmKt;
import io.ktor.http.content.OutgoingContent;
import io.ktor.http.content.VersionsKt;
import io.ktor.server.http.content.LastModifiedJavaTimeKt;
import io.ktor.util.cio.FileChannelsKt;
import io.ktor.utils.io.ByteReadChannel;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0007R\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\r\u001a\u00020\f8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0012\u001a\u00020\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lio/ktor/server/http/content/LocalFileContent;", "Lio/ktor/http/content/OutgoingContent$ReadChannelContent;", "Lio/ktor/utils/io/ByteReadChannel;", "readFrom", "()Lio/ktor/utils/io/ByteReadChannel;", "Lkotlin/ranges/LongRange;", "range", "(Lkotlin/ranges/LongRange;)Lio/ktor/utils/io/ByteReadChannel;", "", "getContentLength", "()Ljava/lang/Long;", "contentLength", "Lio/ktor/http/ContentType;", "contentType", "Lio/ktor/http/ContentType;", "getContentType", "()Lio/ktor/http/ContentType;", "Ljava/io/File;", "file", "Ljava/io/File;", "getFile", "()Ljava/io/File;", "<init>", "(Ljava/io/File;Lio/ktor/http/ContentType;)V", "ktor-server-core"})
public final class LocalFileContent
extends OutgoingContent.ReadChannelContent {
    @NotNull
    private final File file;
    @NotNull
    private final ContentType contentType;

    public LocalFileContent(@NotNull File file2, @NotNull ContentType contentType2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)contentType2, (String)"contentType");
        this.file = file2;
        this.contentType = contentType2;
        if (!this.file.exists()) {
            throw new IOException("No such file " + this.file.getAbsolutePath());
        }
        long lastModifiedVersion = this.file.lastModified();
        VersionsKt.setVersions(this, CollectionsKt.plus((Collection)VersionsKt.getVersions(this), (Object)LastModifiedJavaTimeKt.LastModifiedVersion(lastModifiedVersion)));
    }

    public /* synthetic */ LocalFileContent(File file2, ContentType contentType2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            contentType2 = FileContentTypeJvmKt.defaultForFile(ContentType.Companion, file2);
        }
        this(file2, contentType2);
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @Override
    @NotNull
    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    @NotNull
    public Long getContentLength() {
        return this.file.length();
    }

    @Override
    @NotNull
    public ByteReadChannel readFrom() {
        return FileChannelsKt.readChannel$default(this.file, 0L, 0L, null, 7, null);
    }

    @Override
    @NotNull
    public ByteReadChannel readFrom(@NotNull LongRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return FileChannelsKt.readChannel$default(this.file, range.getStart(), range.getEndInclusive(), null, 4, null);
    }
}

