/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.http.BadContentTypeFormatException;
import io.ktor.http.ContentType;
import io.ktor.http.HeaderValue;
import io.ktor.http.HttpHeaderValueParserKt;
import io.ktor.http.HttpHeaders;
import io.ktor.server.plugins.BadRequestException;
import io.ktor.server.routing.RouteSelector;
import io.ktor.server.routing.RouteSelectorEvaluation;
import io.ktor.server.routing.RoutingResolveContext;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0007\u001a\u00020\u00002\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\f\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u00d6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0010H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001a\u001a\u0004\b\u001b\u0010\u0005\u00a8\u0006\u001e"}, d2={"Lio/ktor/server/routing/HttpMultiAcceptRouteSelector;", "Lio/ktor/server/routing/RouteSelector;", "", "Lio/ktor/http/ContentType;", "component1", "()Ljava/util/List;", "contentTypes", "copy", "(Ljava/util/List;)Lio/ktor/server/routing/HttpMultiAcceptRouteSelector;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "Lio/ktor/server/routing/RoutingResolveContext;", "context", "", "segmentIndex", "Lio/ktor/server/routing/RouteSelectorEvaluation;", "evaluate", "(Lio/ktor/server/routing/RoutingResolveContext;I)Lio/ktor/server/routing/RouteSelectorEvaluation;", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/util/List;", "getContentTypes", "<init>", "(Ljava/util/List;)V", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nRouteSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RouteSelector.kt\nio/ktor/server/routing/HttpMultiAcceptRouteSelector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,697:1\n288#2:698\n1747#2,3:699\n289#2:702\n*S KotlinDebug\n*F\n+ 1 RouteSelector.kt\nio/ktor/server/routing/HttpMultiAcceptRouteSelector\n*L\n635#1:698\n635#1:699,3\n635#1:702\n*E\n"})
public final class HttpMultiAcceptRouteSelector
extends RouteSelector {
    @NotNull
    private final List<ContentType> contentTypes;

    public HttpMultiAcceptRouteSelector(@NotNull List<ContentType> contentTypes) {
        Intrinsics.checkNotNullParameter(contentTypes, (String)"contentTypes");
        this.contentTypes = contentTypes;
    }

    @NotNull
    public final List<ContentType> getContentTypes() {
        return this.contentTypes;
    }

    @Override
    @NotNull
    public RouteSelectorEvaluation evaluate(@NotNull RoutingResolveContext context, int segmentIndex) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String acceptHeaderContent = context.getCall().getRequest().getHeaders().get(HttpHeaders.INSTANCE.getAccept());
        try {
            Object v1;
            block9: {
                List<HeaderValue> parsedHeaders = HttpHeaderValueParserKt.parseAndSortContentTypeHeader(acceptHeaderContent);
                if (parsedHeaders.isEmpty()) {
                    return RouteSelectorEvaluation.Companion.getMissing();
                }
                Iterable $this$firstOrNull$iv = parsedHeaders;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    boolean bl;
                    block8: {
                        HeaderValue header = (HeaderValue)element$iv;
                        boolean bl2 = false;
                        Iterable $this$any$iv = this.contentTypes;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                ContentType it = (ContentType)element$iv2;
                                boolean bl3 = false;
                                if (!it.match(header.getValue())) continue;
                                bl = true;
                                break block8;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    v1 = element$iv;
                    break block9;
                }
                v1 = null;
            }
            HeaderValue header = v1;
            if (header != null) {
                return new RouteSelectorEvaluation.Success(header.getQuality(), null, 0, 6, null);
            }
            return RouteSelectorEvaluation.Companion.getFailedParameter();
        }
        catch (BadContentTypeFormatException failedToParse) {
            throw new BadRequestException("Illegal Accept header format: " + acceptHeaderContent, failedToParse);
        }
    }

    @NotNull
    public String toString() {
        return "(contentTypes:" + this.contentTypes + ')';
    }

    @NotNull
    public final List<ContentType> component1() {
        return this.contentTypes;
    }

    @NotNull
    public final HttpMultiAcceptRouteSelector copy(@NotNull List<ContentType> contentTypes) {
        Intrinsics.checkNotNullParameter(contentTypes, (String)"contentTypes");
        return new HttpMultiAcceptRouteSelector(contentTypes);
    }

    public static /* synthetic */ HttpMultiAcceptRouteSelector copy$default(HttpMultiAcceptRouteSelector httpMultiAcceptRouteSelector, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = httpMultiAcceptRouteSelector.contentTypes;
        }
        return httpMultiAcceptRouteSelector.copy(list);
    }

    public int hashCode() {
        return ((Object)this.contentTypes).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpMultiAcceptRouteSelector)) {
            return false;
        }
        HttpMultiAcceptRouteSelector httpMultiAcceptRouteSelector = (HttpMultiAcceptRouteSelector)other;
        return Intrinsics.areEqual(this.contentTypes, httpMultiAcceptRouteSelector.contentTypes);
    }
}

