/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.http.Parameters;
import io.ktor.http.ParametersBuilder;
import io.ktor.http.ParametersKt;
import io.ktor.server.routing.IgnoreTrailingSlashKt;
import io.ktor.server.routing.RouteSelector;
import io.ktor.server.routing.RouteSelectorEvaluation;
import io.ktor.server.routing.RoutingResolveContext;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchNamedGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0015\u0010\u0016J'\u0010\b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lio/ktor/server/routing/PathSegmentRegexRouteSelector;", "Lio/ktor/server/routing/RouteSelector;", "Lkotlin/text/MatchResult;", "result", "", "lastSlashPosition", "", "prefix", "countSegments", "(Lkotlin/text/MatchResult;ILjava/lang/String;)I", "Lio/ktor/server/routing/RoutingResolveContext;", "context", "segmentIndex", "Lio/ktor/server/routing/RouteSelectorEvaluation;", "evaluate", "(Lio/ktor/server/routing/RoutingResolveContext;I)Lio/ktor/server/routing/RouteSelectorEvaluation;", "toString", "()Ljava/lang/String;", "Lkotlin/text/Regex;", "regex", "Lkotlin/text/Regex;", "<init>", "(Lkotlin/text/Regex;)V", "Companion", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nRegexRouting.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegexRouting.kt\nio/ktor/server/routing/PathSegmentRegexRouteSelector\n+ 2 Parameters.kt\nio/ktor/http/Parameters$Companion\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,285:1\n24#2:286\n1295#3,2:287\n1099#4,3:289\n*S KotlinDebug\n*F\n+ 1 RegexRouting.kt\nio/ktor/server/routing/PathSegmentRegexRouteSelector\n*L\n259#1:286\n260#1:287,2\n275#1:289,3\n*E\n"})
public final class PathSegmentRegexRouteSelector
extends RouteSelector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Regex regex;
    @NotNull
    private static final Regex GROUP_NAME_MATCHER = new Regex("(^|[^\\\\])\\(\\?<(\\p{Alpha}\\p{Alnum}*)>(.*?[^\\\\])?\\)");

    public PathSegmentRegexRouteSelector(@NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        this.regex = regex;
    }

    @Override
    @NotNull
    public RouteSelectorEvaluation evaluate(@NotNull RoutingResolveContext context, int segmentIndex) {
        ParametersBuilder parametersBuilder;
        int n;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String prefix2 = StringsKt.startsWith$default((CharSequence)this.regex.getPattern(), (char)'/', (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)this.regex.getPattern(), (String)"\\/", (boolean)false, (int)2, null) ? "/" : "";
        String postfix = StringsKt.endsWith$default((CharSequence)this.regex.getPattern(), (char)'/', (boolean)false, (int)2, null) && IgnoreTrailingSlashKt.getIgnoreTrailingSlash(context.getCall()) ? "/" : "";
        String pathSegments = CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)context.getSegments(), (int)segmentIndex), (CharSequence)"/", (CharSequence)prefix2, (CharSequence)postfix, (int)0, null, null, (int)56, null);
        MatchResult matchResult = Regex.find$default((Regex)this.regex, (CharSequence)pathSegments, (int)0, (int)2, null);
        if (matchResult == null) {
            return RouteSelectorEvaluation.Companion.getFailed();
        }
        MatchResult result2 = matchResult;
        int consumedLength = result2.getValue().length();
        boolean bl = false;
        if (pathSegments.length() == consumedLength) {
            n = context.getSegments().size() - segmentIndex;
        } else if (pathSegments.charAt(consumedLength) == '/') {
            n = this.countSegments(result2, consumedLength, prefix2);
        } else if (consumedLength >= 1 && pathSegments.charAt(consumedLength - 1) == '/') {
            n = this.countSegments(result2, consumedLength - 1, prefix2);
        } else {
            return RouteSelectorEvaluation.Companion.getFailed();
        }
        int segmentIncrement = n;
        MatchGroupCollection matchGroupCollection = result2.getGroups();
        Intrinsics.checkNotNull((Object)matchGroupCollection, (String)"null cannot be cast to non-null type kotlin.text.MatchNamedGroupCollection");
        MatchNamedGroupCollection groups = (MatchNamedGroupCollection)matchGroupCollection;
        Parameters.Companion this_$iv = Parameters.Companion;
        boolean $i$f$build = false;
        ParametersBuilder $this$evaluate_u24lambda_u242 = parametersBuilder = ParametersKt.ParametersBuilder$default(0, 1, null);
        boolean bl2 = false;
        Sequence $this$forEach$iv = Regex.findAll$default((Regex)GROUP_NAME_MATCHER, (CharSequence)this.regex.getPattern(), (int)0, (int)2, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MatchResult matchResult2 = (MatchResult)element$iv;
            boolean bl3 = false;
            String name = (String)matchResult2.getDestructured().getMatch().getGroupValues().get(2);
            Object object = groups.get(name);
            if (object == null || (object = object.getValue()) == null) {
                object = "";
            }
            Object value = object;
            $this$evaluate_u24lambda_u242.append(name, (String)value);
        }
        Parameters parameters2 = parametersBuilder.build();
        return new RouteSelectorEvaluation.Success(1.0, parameters2, segmentIncrement);
    }

    private final int countSegments(MatchResult result2, int lastSlashPosition, String prefix2) {
        String string = result2.getValue().substring(0, lastSlashPosition);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String segments2 = string;
        CharSequence $this$count$iv = segments2;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(it == '/')) continue;
            ++count$iv;
        }
        int count = count$iv;
        return Intrinsics.areEqual((Object)prefix2, (Object)"/") ? count : count + 1;
    }

    @NotNull
    public String toString() {
        return "Regex(" + this.regex.getPattern() + ')';
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Lio/ktor/server/routing/PathSegmentRegexRouteSelector$Companion;", "", "Lkotlin/text/Regex;", "GROUP_NAME_MATCHER", "Lkotlin/text/Regex;", "<init>", "()V", "ktor-server-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

