/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import io.ktor.util.CaseInsensitiveMap;
import io.ktor.util.InternalAPI;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableSet;
import org.jetbrains.annotations.NotNull;

@InternalAPI
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010)\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0004\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\b\u0016\u0012\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u001f\u00a2\u0006\u0004\b!\u0010\"B\u0007\u00a2\u0006\u0004\b!\u0010\rJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\t\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0004\b\u000e\u0010\u0006J\u001d\u0010\u000f\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u000f\u0010\nJ\u000f\u0010\u0010\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0096\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0006J\u001d\u0010\u0016\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0016\u0010\nJ\u001d\u0010\u0017\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0017\u0010\nR\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001e\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006#"}, d2={"Lio/ktor/util/CaseInsensitiveSet;", "", "", "element", "", "add", "(Ljava/lang/String;)Z", "", "elements", "addAll", "(Ljava/util/Collection;)Z", "", "clear", "()V", "contains", "containsAll", "isEmpty", "()Z", "", "iterator", "()Ljava/util/Iterator;", "remove", "removeAll", "retainAll", "Lio/ktor/util/CaseInsensitiveMap;", "backingMap", "Lio/ktor/util/CaseInsensitiveMap;", "", "getSize", "()I", "size", "", "initial", "<init>", "(Ljava/lang/Iterable;)V", "ktor-utils"})
public final class CaseInsensitiveSet
implements Set<String>,
KMutableSet {
    @NotNull
    private final CaseInsensitiveMap<Boolean> backingMap;

    public CaseInsensitiveSet() {
        this.backingMap = new CaseInsensitiveMap();
    }

    public CaseInsensitiveSet(@NotNull Iterable<String> initial) {
        Intrinsics.checkNotNullParameter(initial, (String)"initial");
        this();
        CollectionsKt.addAll((Collection)this, initial);
    }

    @Override
    public boolean add(@NotNull String element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (((Map)this.backingMap).containsKey(element)) {
            return false;
        }
        ((Map)this.backingMap).put(element, true);
        return true;
    }

    public int getSize() {
        return this.backingMap.size();
    }

    public boolean remove(@NotNull String element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return Intrinsics.areEqual((Object)this.backingMap.remove((Object)element), (Object)true);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends String> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean added = false;
        for (String string : elements) {
            if (!this.add(string)) continue;
            added = true;
        }
        return added;
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.backingMap.keySet().removeAll(elements);
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.backingMap.keySet().retainAll(elements);
    }

    public boolean contains(@NotNull String element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return ((Map)this.backingMap).containsKey(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.backingMap.keySet().containsAll(elements);
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<String> iterator() {
        return this.backingMap.keySet().iterator();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }
}

