/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.css;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.css.Color;
import kotlinx.css.CssValue;
import kotlinx.css.ExtensionsKt;
import kotlinx.css.StyleEnumsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\f\u0018\u0000 $2\u00020\u0001:\u0003$%&B\u0019\b\u0012\u0012\u0006\u0010\u001e\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b!\u0010\"B\u000f\u0012\u0006\u0010\u001e\u001a\u00020\u001b\u00a2\u0006\u0004\b!\u0010#J\u0015\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\r\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\r\u0010\fJ\u000f\u0010\u0011\u001a\u00020\u000eH\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0015\u001a\u00020\u0012H\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0016\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0016\u0010\fJ\u0015\u0010\u0017\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0017\u0010\fJ\u000f\u0010\u0019\u001a\u00020\u0012H\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0014J\u0015\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u001a\u0010\bR\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001d\u001a\u0004\b\u001f\u0010 \u00a8\u0006'"}, d2={"Lkotlinx/css/Color;", "Lkotlinx/css/CssValue;", "backgroundColor", "blend", "(Lkotlinx/css/Color;)Lkotlinx/css/Color;", "", "alpha", "changeAlpha", "(D)Lkotlinx/css/Color;", "", "percent", "darken", "(I)Lkotlinx/css/Color;", "desaturate", "Lkotlinx/css/Color$HSLA;", "fromHSLANotation$kotlin_css", "()Lkotlinx/css/Color$HSLA;", "fromHSLANotation", "Lkotlinx/css/Color$RGBA;", "fromRGBANotation$kotlin_css", "()Lkotlinx/css/Color$RGBA;", "fromRGBANotation", "lighten", "saturate", "toRGBA$kotlin_css", "toRGBA", "withAlpha", "", "rgb", "Ljava/lang/String;", "value", "getValue", "()Ljava/lang/String;", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "(Ljava/lang/String;)V", "Companion", "HSLA", "RGBA", "kotlin-css"})
@SourceDebugExtension(value={"SMAP\nStyleEnums.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StyleEnums.kt\nkotlinx/css/Color\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1124:1\n1#2:1125\n*E\n"})
public final class Color
extends CssValue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String value;
    @Nullable
    private String rgb;
    @NotNull
    private static final Color initial = new Color("initial");
    @NotNull
    private static final Color inherit = new Color("inherit");
    @NotNull
    private static final Color unset = new Color("unset");
    @NotNull
    private static final Color transparent = new Color("transparent");
    @NotNull
    private static final Color currentColor = new Color("currentColor");
    @NotNull
    private static final Color aliceBlue = new Color("aliceblue", "#f0f8ff");
    @NotNull
    private static final Color antiqueWhite = new Color("antiquewhite", "#faebd7");
    @NotNull
    private static final Color aqua = new Color("aqua", "#00ffff");
    @NotNull
    private static final Color aquamarine = new Color("aquamarine", "#7fffd4");
    @NotNull
    private static final Color azure = new Color("azure", "#f0ffff");
    @NotNull
    private static final Color beige = new Color("beige", "#f5f5dc");
    @NotNull
    private static final Color bisque = new Color("bisque", "#ffe4c4");
    @NotNull
    private static final Color black = new Color("black", "#000000");
    @NotNull
    private static final Color blanchedAlmond = new Color("blanchedalmond", "#ffebcd");
    @NotNull
    private static final Color blue = new Color("blue", "#0000ff");
    @NotNull
    private static final Color blueViolet = new Color("blueviolet", "#8a2be2");
    @NotNull
    private static final Color brown = new Color("brown", "#a52a2a");
    @NotNull
    private static final Color burlyWood = new Color("burlywood", "#deb887");
    @NotNull
    private static final Color cadetBlue = new Color("cadetblue", "#5f9ea0");
    @NotNull
    private static final Color chartreuse = new Color("chartreuse", "#7fff00");
    @NotNull
    private static final Color chocolate = new Color("chocolate", "#d2691e");
    @NotNull
    private static final Color coral = new Color("coral", "#ff7f50");
    @NotNull
    private static final Color cornflowerBlue = new Color("cornflowerblue", "#6495ed");
    @NotNull
    private static final Color cornsilk = new Color("cornsilk", "#fff8dc");
    @NotNull
    private static final Color crimson = new Color("crimson", "#dc143c");
    @NotNull
    private static final Color cyan = new Color("cyan", "#00ffff");
    @NotNull
    private static final Color darkBlue = new Color("darkblue", "#00008b");
    @NotNull
    private static final Color darkCyan = new Color("darkcyan", "#008b8b");
    @NotNull
    private static final Color darkGoldenrod = new Color("darkgoldenrod", "#b8860b");
    @NotNull
    private static final Color darkGray = new Color("darkgray", "#a9a9a9");
    @NotNull
    private static final Color darkGreen = new Color("darkgreen", "#006400");
    @NotNull
    private static final Color darkGrey = new Color("darkgrey", "#a9a9a9");
    @NotNull
    private static final Color darkKhaki = new Color("darkkhaki", "#bdb76b");
    @NotNull
    private static final Color darkMagenta = new Color("darkmagenta", "#8b008b");
    @NotNull
    private static final Color darkOliveGreen = new Color("darkolivegreen", "#556b2f");
    @NotNull
    private static final Color darkOrange = new Color("darkorange", "#ff8c00");
    @NotNull
    private static final Color darkOrchid = new Color("darkorchid", "#9932cc");
    @NotNull
    private static final Color darkRed = new Color("darkred", "#8b0000");
    @NotNull
    private static final Color darkSalmon = new Color("darksalmon", "#e9967a");
    @NotNull
    private static final Color darkSeaGreen = new Color("darkseagreen", "#8fbc8f");
    @NotNull
    private static final Color darkSlateBlue = new Color("darkslateblue", "#483d8b");
    @NotNull
    private static final Color darkSlateGray = new Color("darkslategray", "#2f4f4f");
    @NotNull
    private static final Color darkSlateGrey = new Color("darkslategrey", "#2f4f4f");
    @NotNull
    private static final Color darkTurquoise = new Color("darkturquoise", "#00ced1");
    @NotNull
    private static final Color darkViolet = new Color("darkviolet", "#9400d3");
    @NotNull
    private static final Color deepPink = new Color("deeppink", "#ff1493");
    @NotNull
    private static final Color deepSkyBlue = new Color("deepskyblue", "#00bfff");
    @NotNull
    private static final Color dimGray = new Color("dimgray", "#696969");
    @NotNull
    private static final Color dimGrey = new Color("dimgrey", "#696969");
    @NotNull
    private static final Color dodgerBlue = new Color("dodgerblue", "#1e90ff");
    @NotNull
    private static final Color firebrick = new Color("firebrick", "#b22222");
    @NotNull
    private static final Color floralWhite = new Color("floralwhite", "#fffaf0");
    @NotNull
    private static final Color forestGreen = new Color("forestgreen", "#228b22");
    @NotNull
    private static final Color fuchsia = new Color("fuchsia", "#ff00ff");
    @NotNull
    private static final Color gainsboro = new Color("gainsboro", "#dcdcdc");
    @NotNull
    private static final Color ghostWhite = new Color("ghostwhite", "#f8f8ff");
    @NotNull
    private static final Color gold = new Color("gold", "#ffd700");
    @NotNull
    private static final Color goldenrod = new Color("goldenrod", "#daa520");
    @NotNull
    private static final Color gray = new Color("gray", "#808080");
    @NotNull
    private static final Color green = new Color("green", "#008000");
    @NotNull
    private static final Color greenYellow = new Color("greenyellow", "#adff2f");
    @NotNull
    private static final Color grey = new Color("grey", "#808080");
    @NotNull
    private static final Color honeydew = new Color("honeydew", "#f0fff0");
    @NotNull
    private static final Color hotPink = new Color("hotpink", "#ff69b4");
    @NotNull
    private static final Color indianRed = new Color("indianred", "#cd5c5c");
    @NotNull
    private static final Color indigo = new Color("indigo", "#4b0082");
    @NotNull
    private static final Color ivory = new Color("ivory", "#fffff0");
    @NotNull
    private static final Color khaki = new Color("khaki", "#f0e68c");
    @NotNull
    private static final Color lavender = new Color("lavender", "#e6e6fa");
    @NotNull
    private static final Color lavenderBlush = new Color("lavenderblush", "#fff0f5");
    @NotNull
    private static final Color lawnGreen = new Color("lawngreen", "#7cfc00");
    @NotNull
    private static final Color lemonChiffon = new Color("lemonchiffon", "#fffacd");
    @NotNull
    private static final Color lightBlue = new Color("lightblue", "#add8e6");
    @NotNull
    private static final Color lightCoral = new Color("lightcoral", "#f08080");
    @NotNull
    private static final Color lightCyan = new Color("lightcyan", "#e0ffff");
    @NotNull
    private static final Color lightGoldenrodYellow = new Color("lightgoldenrodyellow", "#fafad2");
    @NotNull
    private static final Color lightGray = new Color("lightgray", "#d3d3d3");
    @NotNull
    private static final Color lightGreen = new Color("lightgreen", "#90ee90");
    @NotNull
    private static final Color lightGrey = new Color("lightgrey", "#d3d3d3");
    @NotNull
    private static final Color lightPink = new Color("lightpink", "#ffb6c1");
    @NotNull
    private static final Color lightSalmon = new Color("lightsalmon", "#ffa07a");
    @NotNull
    private static final Color lightSeaGreen = new Color("lightseagreen", "#20b2aa");
    @NotNull
    private static final Color lightSkyBlue = new Color("lightskyblue", "#87cefa");
    @NotNull
    private static final Color lightSlateGray = new Color("lightslategray", "#778899");
    @NotNull
    private static final Color lightSlateGrey = new Color("lightslategrey", "#778899");
    @NotNull
    private static final Color lightSteelBlue = new Color("lightsteelblue", "#b0c4de");
    @NotNull
    private static final Color lightYellow = new Color("lightyellow", "#ffffe0");
    @NotNull
    private static final Color lime = new Color("lime", "#00ff00");
    @NotNull
    private static final Color limeGreen = new Color("limegreen", "#32cd32");
    @NotNull
    private static final Color linen = new Color("linen", "#faf0e6");
    @NotNull
    private static final Color magenta = new Color("magenta", "#ff00ff");
    @NotNull
    private static final Color maroon = new Color("maroon", "#800000");
    @NotNull
    private static final Color mediumAquamarine = new Color("mediumaquamarine", "#66cdaa");
    @NotNull
    private static final Color mediumBlue = new Color("mediumblue", "#0000cd");
    @NotNull
    private static final Color mediumOrchid = new Color("mediumorchid", "#ba55d3");
    @NotNull
    private static final Color mediumPurple = new Color("mediumpurple", "#9370d8");
    @NotNull
    private static final Color mediumSeaGreen = new Color("mediumseagreen", "#3cb371");
    @NotNull
    private static final Color mediumSlateBlue = new Color("mediumslateblue", "#7b68ee");
    @NotNull
    private static final Color mediumSpringGreen = new Color("mediumspringgreen", "#00fa9a");
    @NotNull
    private static final Color mediumTurquoise = new Color("mediumturquoise", "#48d1cc");
    @NotNull
    private static final Color mediumVioletRed = new Color("mediumvioletred", "#c71585");
    @NotNull
    private static final Color midnightBlue = new Color("midnightblue", "#191970");
    @NotNull
    private static final Color mintCream = new Color("mintcream", "#f5fffa");
    @NotNull
    private static final Color mistyRose = new Color("mistyrose", "#ffe4e1");
    @NotNull
    private static final Color moccasin = new Color("moccasin", "#ffe4b5");
    @NotNull
    private static final Color navajoWhite = new Color("navajowhite", "#ffdead");
    @NotNull
    private static final Color navy = new Color("navy", "#000080");
    @NotNull
    private static final Color oldLace = new Color("oldlace", "#fdf5e6");
    @NotNull
    private static final Color olive = new Color("olive", "#808000");
    @NotNull
    private static final Color oliveDrab = new Color("olivedrab", "#6b8e23");
    @NotNull
    private static final Color orange = new Color("orange", "#ffa500");
    @NotNull
    private static final Color orangeRed = new Color("orangered", "#ff4500");
    @NotNull
    private static final Color orchid = new Color("orchid", "#da70d6");
    @NotNull
    private static final Color paleGoldenrod = new Color("palegoldenrod", "#eee8aa");
    @NotNull
    private static final Color paleGreen = new Color("palegreen", "#98fb98");
    @NotNull
    private static final Color paleTurquoise = new Color("paleturquoise", "#afeeee");
    @NotNull
    private static final Color paleVioletRed = new Color("palevioletred", "#db7093");
    @NotNull
    private static final Color papayaWhip = new Color("papayawhip", "#ffefd5");
    @NotNull
    private static final Color peachPuff = new Color("peachpuff", "#ffdab9");
    @NotNull
    private static final Color peru = new Color("peru", "#cd853f");
    @NotNull
    private static final Color pink = new Color("pink", "#ffc0cb");
    @NotNull
    private static final Color plum = new Color("plum", "#dda0dd");
    @NotNull
    private static final Color powderBlue = new Color("powderblue", "#b0e0e6");
    @NotNull
    private static final Color purple = new Color("purple", "#800080");
    @NotNull
    private static final Color red = new Color("red", "#ff0000");
    @NotNull
    private static final Color rosyBrown = new Color("rosybrown", "#bc8f8f");
    @NotNull
    private static final Color royalBlue = new Color("royalblue", "#4169e1");
    @NotNull
    private static final Color saddleBrown = new Color("saddlebrown", "#8b4513");
    @NotNull
    private static final Color salmon = new Color("salmon", "#fa8072");
    @NotNull
    private static final Color sandyBrown = new Color("sandybrown", "#f4a460");
    @NotNull
    private static final Color seaGreen = new Color("seagreen", "#2e8b57");
    @NotNull
    private static final Color seaShell = new Color("seashell", "#fff5ee");
    @NotNull
    private static final Color sienna = new Color("sienna", "#a0522d");
    @NotNull
    private static final Color silver = new Color("silver", "#c0c0c0");
    @NotNull
    private static final Color skyBlue = new Color("skyblue", "#87ceeb");
    @NotNull
    private static final Color slateBlue = new Color("slateblue", "#6a5acd");
    @NotNull
    private static final Color slateGray = new Color("slategray", "#708090");
    @NotNull
    private static final Color slateGrey = new Color("slategrey", "#708090");
    @NotNull
    private static final Color snow = new Color("snow", "#fffafa");
    @NotNull
    private static final Color springGreen = new Color("springgreen", "#00ff7f");
    @NotNull
    private static final Color steelBlue = new Color("steelblue", "#4682b4");
    @NotNull
    private static final Color tan = new Color("tan", "#d2b48c");
    @NotNull
    private static final Color teal = new Color("teal", "#008080");
    @NotNull
    private static final Color thistle = new Color("thistle", "#d8bfd8");
    @NotNull
    private static final Color tomato = new Color("tomato", "#ff6347");
    @NotNull
    private static final Color turquoise = new Color("turquoise", "#40e0d0");
    @NotNull
    private static final Color violet = new Color("violet", "#ee82ee");
    @NotNull
    private static final Color wheat = new Color("wheat", "#f5deb3");
    @NotNull
    private static final Color white = new Color("white", "#ffffff");
    @NotNull
    private static final Color whiteSmoke = new Color("whitesmoke", "#f5f5f5");
    @NotNull
    private static final Color yellow = new Color("yellow", "#ffff00");
    @NotNull
    private static final Color yellowGreen = new Color("yellowgreen", "#9acd32");
    @NotNull
    private static final Lazy<Regex> HSLA_REGEX$delegate = LazyKt.lazy((Function0)Companion.HSLA_REGEX.2.INSTANCE);
    @NotNull
    private static final Lazy<Regex> RGBA_REGEX$delegate = LazyKt.lazy((Function0)Companion.RGBA_REGEX.2.INSTANCE);

    public Color(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        super(value);
        this.value = value;
    }

    @Override
    @NotNull
    public String getValue() {
        return this.value;
    }

    private Color(String value, String rgb) {
        this(value);
        this.rgb = rgb;
    }

    @NotNull
    public final Color withAlpha(double alpha) {
        Color color;
        if (StringsKt.startsWith((String)this.getValue(), (String)"hsl", (boolean)true)) {
            HSLA $this$withAlpha_u24lambda_u240 = this.fromHSLANotation$kotlin_css();
            boolean bl = false;
            color = StyleEnumsKt.hsla($this$withAlpha_u24lambda_u240.getHue(), $this$withAlpha_u24lambda_u240.getSaturation(), $this$withAlpha_u24lambda_u240.getLightness(), Companion.normalizeAlpha(alpha) * $this$withAlpha_u24lambda_u240.getAlpha());
        } else {
            RGBA $this$withAlpha_u24lambda_u241 = this.toRGBA$kotlin_css();
            boolean bl = false;
            color = StyleEnumsKt.rgba($this$withAlpha_u24lambda_u241.getRed(), $this$withAlpha_u24lambda_u241.getGreen(), $this$withAlpha_u24lambda_u241.getBlue(), Companion.normalizeAlpha(alpha) * $this$withAlpha_u24lambda_u241.getAlpha());
        }
        return color;
    }

    @NotNull
    public final Color changeAlpha(double alpha) {
        Color color;
        if (StringsKt.startsWith((String)this.getValue(), (String)"hsl", (boolean)true)) {
            HSLA $this$changeAlpha_u24lambda_u242 = this.fromHSLANotation$kotlin_css();
            boolean bl = false;
            color = StyleEnumsKt.hsla($this$changeAlpha_u24lambda_u242.getHue(), $this$changeAlpha_u24lambda_u242.getSaturation(), $this$changeAlpha_u24lambda_u242.getLightness(), Companion.normalizeAlpha(alpha));
        } else {
            RGBA $this$changeAlpha_u24lambda_u243 = this.toRGBA$kotlin_css();
            boolean bl = false;
            color = StyleEnumsKt.rgba($this$changeAlpha_u24lambda_u243.getRed(), $this$changeAlpha_u24lambda_u243.getGreen(), $this$changeAlpha_u24lambda_u243.getBlue(), Companion.normalizeAlpha(alpha));
        }
        return color;
    }

    @NotNull
    public final Color blend(@NotNull Color backgroundColor) {
        Intrinsics.checkNotNullParameter((Object)backgroundColor, (String)"backgroundColor");
        RGBA source = this.toRGBA$kotlin_css();
        RGBA background = backgroundColor.toRGBA$kotlin_css();
        double targetR = (1.0 - source.getAlpha()) * (double)background.getRed() + source.getAlpha() * (double)source.getRed();
        double targetG = (1.0 - source.getAlpha()) * (double)background.getGreen() + source.getAlpha() * (double)source.getGreen();
        double targetB = (1.0 - source.getAlpha()) * (double)background.getBlue() + source.getAlpha() * (double)source.getBlue();
        return StyleEnumsKt.rgb(MathKt.roundToInt((double)targetR), MathKt.roundToInt((double)targetG), MathKt.roundToInt((double)targetB));
    }

    @NotNull
    public final Color lighten(int percent) {
        Color color;
        boolean isHSLA = StringsKt.startsWith((String)this.getValue(), (String)"hsl", (boolean)true);
        HSLA hsla = isHSLA ? this.fromHSLANotation$kotlin_css() : this.toRGBA$kotlin_css().asHSLA();
        int lightness = hsla.getLightness() + MathKt.roundToInt((double)((double)hsla.getLightness() * ((double)Companion.normalizePercent(percent) / 100.0)));
        HSLA newHSLa = HSLA.copy$default(hsla, 0, 0, Companion.normalizePercent(lightness), 0.0, 11, null);
        if (isHSLA) {
            color = StyleEnumsKt.hsla(newHSLa.getHue(), newHSLa.getSaturation(), newHSLa.getLightness(), newHSLa.getAlpha());
        } else {
            RGBA $this$lighten_u24lambda_u244 = newHSLa.asRGBA();
            boolean bl = false;
            color = StyleEnumsKt.rgba($this$lighten_u24lambda_u244.getRed(), $this$lighten_u24lambda_u244.getGreen(), $this$lighten_u24lambda_u244.getBlue(), $this$lighten_u24lambda_u244.getAlpha());
        }
        return color;
    }

    @NotNull
    public final Color darken(int percent) {
        Color color;
        boolean isHSLA = StringsKt.startsWith((String)this.getValue(), (String)"hsl", (boolean)true);
        HSLA hsla = isHSLA ? this.fromHSLANotation$kotlin_css() : this.toRGBA$kotlin_css().asHSLA();
        int darkness = hsla.getLightness() - MathKt.roundToInt((double)((double)hsla.getLightness() * ((double)Companion.normalizePercent(percent) / 100.0)));
        HSLA newHSLa = HSLA.copy$default(hsla, 0, 0, Companion.normalizePercent(darkness), 0.0, 11, null);
        if (isHSLA) {
            color = StyleEnumsKt.hsla(newHSLa.getHue(), newHSLa.getSaturation(), newHSLa.getLightness(), newHSLa.getAlpha());
        } else {
            RGBA $this$darken_u24lambda_u245 = newHSLa.asRGBA();
            boolean bl = false;
            color = StyleEnumsKt.rgba($this$darken_u24lambda_u245.getRed(), $this$darken_u24lambda_u245.getGreen(), $this$darken_u24lambda_u245.getBlue(), $this$darken_u24lambda_u245.getAlpha());
        }
        return color;
    }

    @NotNull
    public final Color saturate(int percent) {
        Color color;
        boolean isHSLA = StringsKt.startsWith((String)this.getValue(), (String)"hsl", (boolean)true);
        HSLA hsla = isHSLA ? this.fromHSLANotation$kotlin_css() : this.toRGBA$kotlin_css().asHSLA();
        int saturation = hsla.getSaturation() + MathKt.roundToInt((double)((double)hsla.getSaturation() * ((double)Companion.normalizePercent(percent) / 100.0)));
        HSLA newHSLa = HSLA.copy$default(hsla, 0, Companion.normalizePercent(saturation), 0, 0.0, 13, null);
        if (isHSLA) {
            color = StyleEnumsKt.hsla(newHSLa.getHue(), newHSLa.getSaturation(), newHSLa.getLightness(), newHSLa.getAlpha());
        } else {
            RGBA $this$saturate_u24lambda_u246 = newHSLa.asRGBA();
            boolean bl = false;
            color = StyleEnumsKt.rgba($this$saturate_u24lambda_u246.getRed(), $this$saturate_u24lambda_u246.getGreen(), $this$saturate_u24lambda_u246.getBlue(), $this$saturate_u24lambda_u246.getAlpha());
        }
        return color;
    }

    @NotNull
    public final Color desaturate(int percent) {
        Color color;
        boolean isHSLA = StringsKt.startsWith((String)this.getValue(), (String)"hsl", (boolean)true);
        HSLA hsla = isHSLA ? this.fromHSLANotation$kotlin_css() : this.toRGBA$kotlin_css().asHSLA();
        int desaturation = hsla.getSaturation() - MathKt.roundToInt((double)((double)hsla.getSaturation() * ((double)Companion.normalizePercent(percent) / 100.0)));
        HSLA newHSLa = HSLA.copy$default(hsla, 0, Companion.normalizePercent(desaturation), 0, 0.0, 13, null);
        if (isHSLA) {
            color = StyleEnumsKt.hsla(newHSLa.getHue(), newHSLa.getSaturation(), newHSLa.getLightness(), newHSLa.getAlpha());
        } else {
            RGBA $this$desaturate_u24lambda_u247 = newHSLa.asRGBA();
            boolean bl = false;
            color = StyleEnumsKt.rgba($this$desaturate_u24lambda_u247.getRed(), $this$desaturate_u24lambda_u247.getGreen(), $this$desaturate_u24lambda_u247.getBlue(), $this$desaturate_u24lambda_u247.getAlpha());
        }
        return color;
    }

    @NotNull
    public final HSLA fromHSLANotation$kotlin_css() {
        MatchResult match = Regex.find$default((Regex)Color.Companion.getHSLA_REGEX(), (CharSequence)this.getValue(), (int)0, (int)2, null);
        String hueShape = Color.fromHSLANotation$getHSLParameter(match, this, 1);
        int hue = Companion.normalizeHue(StringsKt.endsWith((String)hueShape, (String)"grad", (boolean)true) ? Double.parseDouble(StringsKt.substringBefore$default((String)hueShape, (String)"grad", null, (int)2, null)) * 0.9 : (StringsKt.endsWith((String)hueShape, (String)"rad", (boolean)true) ? Double.parseDouble(StringsKt.substringBefore$default((String)hueShape, (String)"rad", null, (int)2, null)) * (double)180 / Math.PI : (StringsKt.endsWith((String)hueShape, (String)"turn", (boolean)true) ? Double.parseDouble(StringsKt.substringBefore$default((String)hueShape, (String)"turn", null, (int)2, null)) * 360.0 : (StringsKt.endsWith((String)hueShape, (String)"deg", (boolean)true) ? Double.parseDouble(StringsKt.substringBefore$default((String)hueShape, (String)"deg", null, (int)2, null)) : Double.parseDouble(hueShape)))));
        int saturation = Companion.normalizePercent(Integer.parseInt(Color.fromHSLANotation$getHSLParameter(match, this, 2)));
        int lightness = Companion.normalizePercent(Integer.parseInt(Color.fromHSLANotation$getHSLParameter(match, this, 3)));
        Object object = match;
        double alpha = Companion.normalizeAlpha(object != null && (object = object.getGroups()) != null && (object = object.get(4)) != null && (object = object.getValue()) != null ? Double.parseDouble((String)object) : 1.0);
        return new HSLA(hue, saturation, lightness, alpha);
    }

    @NotNull
    public final RGBA fromRGBANotation$kotlin_css() {
        MatchResult match = Regex.find$default((Regex)Color.Companion.getRGBA_REGEX(), (CharSequence)this.getValue(), (int)0, (int)2, null);
        int red = Color.fromRGBANotation$getRGBParameter(match, this, 1);
        int green = Color.fromRGBANotation$getRGBParameter(match, this, 2);
        int blue = Color.fromRGBANotation$getRGBParameter(match, this, 3);
        Object object = match;
        double alpha = Companion.normalizeAlpha(object != null && (object = object.getGroups()) != null && (object = object.get(4)) != null && (object = object.getValue()) != null ? Double.parseDouble((String)object) : 1.0);
        return new RGBA(red, green, blue, alpha);
    }

    @NotNull
    public final RGBA toRGBA$kotlin_css() {
        RGBA rGBA;
        String string = this.rgb;
        if (string == null) {
            string = this.getValue();
        }
        String v = string;
        if (StringsKt.startsWith$default((String)v, (String)"rgb", (boolean)false, (int)2, null)) {
            rGBA = this.fromRGBANotation$kotlin_css();
        } else if (StringsKt.startsWith$default((String)v, (String)"#", (boolean)false, (int)2, null) && v.length() == 4) {
            rGBA = new RGBA(Integer.parseInt(ExtensionsKt.times(String.valueOf(v.charAt(1)), 2), CharsKt.checkRadix((int)16)), Integer.parseInt(ExtensionsKt.times(String.valueOf(v.charAt(2)), 2), CharsKt.checkRadix((int)16)), Integer.parseInt(ExtensionsKt.times(String.valueOf(v.charAt(3)), 2), CharsKt.checkRadix((int)16)), 0.0, 8, null);
        } else if (StringsKt.startsWith$default((String)v, (String)"#", (boolean)false, (int)2, null) && (v.length() == 7 || v.length() == 9)) {
            rGBA = new RGBA(Integer.parseInt(StringsKt.substring((String)v, (IntRange)new IntRange(1, 2)), CharsKt.checkRadix((int)16)), Integer.parseInt(StringsKt.substring((String)v, (IntRange)new IntRange(3, 4)), CharsKt.checkRadix((int)16)), Integer.parseInt(StringsKt.substring((String)v, (IntRange)new IntRange(5, 6)), CharsKt.checkRadix((int)16)), 0.0, 8, null);
        } else {
            throw new IllegalArgumentException("Only hexadecimal, rgb, and rgba notations are accepted, got " + v);
        }
        return rGBA;
    }

    private static final String fromHSLANotation$getHSLParameter(MatchResult match, Color this$0, int index) {
        Object object = match;
        if (object == null || (object = object.getGroups()) == null || (object = object.get(index)) == null || (object = object.getValue()) == null) {
            throw new IllegalArgumentException("Expected hsl or hsla notation, got " + this$0.getValue());
        }
        return object;
    }

    private static final int fromRGBANotation$getRGBParameter(MatchResult match, Color this$0, int index) {
        Object object = match;
        if (object == null || (object = object.getGroups()) == null || (object = object.get(index)) == null || (object = object.getValue()) == null) {
            throw new IllegalArgumentException("Expected rgb or rgba notation, got " + this$0.getValue());
        }
        Object group = object;
        return StringsKt.endsWith$default((CharSequence)((CharSequence)group), (char)'%', (boolean)false, (int)2, null) ? (int)(Companion.normalizeFractionalPercent(Double.parseDouble(StringsKt.substringBefore$default((String)group, (char)'%', null, (int)2, null)) / 100.0) * 255.0) : Companion.normalizeRGB(Integer.parseInt((String)group));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000)\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0003\b\u00b5\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u000b\b\u0002\u00a2\u0006\u0006\b\u00c9\u0002\u0010\u00ca\u0002J\u0015\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0005J\u0015\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\n\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\f\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\u000bR\u001b\u0010\u0012\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0015\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000f\u001a\u0004\b\u0014\u0010\u0011R\u0017\u0010\u0017\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0018\u001a\u0004\b\u001c\u0010\u001aR\u0017\u0010\u001d\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0018\u001a\u0004\b\u001e\u0010\u001aR\u0017\u0010\u001f\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0018\u001a\u0004\b \u0010\u001aR\u0017\u0010!\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b!\u0010\u0018\u001a\u0004\b\"\u0010\u001aR\u0017\u0010#\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b#\u0010\u0018\u001a\u0004\b$\u0010\u001aR\u0017\u0010%\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b%\u0010\u0018\u001a\u0004\b&\u0010\u001aR\u0017\u0010'\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b'\u0010\u0018\u001a\u0004\b(\u0010\u001aR\u0017\u0010)\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b)\u0010\u0018\u001a\u0004\b*\u0010\u001aR\u0017\u0010+\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b+\u0010\u0018\u001a\u0004\b,\u0010\u001aR\u0017\u0010-\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b-\u0010\u0018\u001a\u0004\b.\u0010\u001aR\u0017\u0010/\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b/\u0010\u0018\u001a\u0004\b0\u0010\u001aR\u0017\u00101\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b1\u0010\u0018\u001a\u0004\b2\u0010\u001aR\u0017\u00103\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b3\u0010\u0018\u001a\u0004\b4\u0010\u001aR\u0017\u00105\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b5\u0010\u0018\u001a\u0004\b6\u0010\u001aR\u0017\u00107\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b7\u0010\u0018\u001a\u0004\b8\u0010\u001aR\u0017\u00109\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b9\u0010\u0018\u001a\u0004\b:\u0010\u001aR\u0017\u0010;\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b;\u0010\u0018\u001a\u0004\b<\u0010\u001aR\u0017\u0010=\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b=\u0010\u0018\u001a\u0004\b>\u0010\u001aR\u0017\u0010?\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b?\u0010\u0018\u001a\u0004\b@\u0010\u001aR\u0017\u0010A\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\bA\u0010\u0018\u001a\u0004\bB\u0010\u001aR\u0017\u0010C\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\bC\u0010\u0018\u001a\u0004\bD\u0010\u001aR\u0017\u0010E\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\bE\u0010\u0018\u001a\u0004\bF\u0010\u001aR\u0017\u0010G\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\bG\u0010\u0018\u001a\u0004\bH\u0010\u001aR\u0017\u0010I\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\bI\u0010\u0018\u001a\u0004\bJ\u0010\u001aR\u0017\u0010K\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\bK\u0010\u0018\u001a\u0004\bL\u0010\u001aR\u0017\u0010M\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\bM\u0010\u0018\u001a\u0004\bN\u0010\u001aR\u0017\u0010O\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\bO\u0010\u0018\u001a\u0004\bP\u0010\u001aR\u0017\u0010Q\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\bQ\u0010\u0018\u001a\u0004\bR\u0010\u001aR\u0017\u0010S\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\bS\u0010\u0018\u001a\u0004\bT\u0010\u001aR\u0017\u0010U\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\bU\u0010\u0018\u001a\u0004\bV\u0010\u001aR\u0017\u0010W\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\bW\u0010\u0018\u001a\u0004\bX\u0010\u001aR\u0017\u0010Y\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\bY\u0010\u0018\u001a\u0004\bZ\u0010\u001aR\u0017\u0010[\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b[\u0010\u0018\u001a\u0004\b\\\u0010\u001aR\u0017\u0010]\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b]\u0010\u0018\u001a\u0004\b^\u0010\u001aR\u0017\u0010_\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b_\u0010\u0018\u001a\u0004\b`\u0010\u001aR\u0017\u0010a\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\ba\u0010\u0018\u001a\u0004\bb\u0010\u001aR\u0017\u0010c\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\bc\u0010\u0018\u001a\u0004\bd\u0010\u001aR\u0017\u0010e\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\be\u0010\u0018\u001a\u0004\bf\u0010\u001aR\u0017\u0010g\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\bg\u0010\u0018\u001a\u0004\bh\u0010\u001aR\u0017\u0010i\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\bi\u0010\u0018\u001a\u0004\bj\u0010\u001aR\u0017\u0010k\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\bk\u0010\u0018\u001a\u0004\bl\u0010\u001aR\u0017\u0010m\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\bm\u0010\u0018\u001a\u0004\bn\u0010\u001aR\u0017\u0010o\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\bo\u0010\u0018\u001a\u0004\bp\u0010\u001aR\u0017\u0010q\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\bq\u0010\u0018\u001a\u0004\br\u0010\u001aR\u0017\u0010s\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\bs\u0010\u0018\u001a\u0004\bt\u0010\u001aR\u0017\u0010u\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\bu\u0010\u0018\u001a\u0004\bv\u0010\u001aR\u0017\u0010w\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\bw\u0010\u0018\u001a\u0004\bx\u0010\u001aR\u0017\u0010y\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\by\u0010\u0018\u001a\u0004\bz\u0010\u001aR\u0017\u0010{\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b{\u0010\u0018\u001a\u0004\b|\u0010\u001aR\u0017\u0010}\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b}\u0010\u0018\u001a\u0004\b~\u0010\u001aR\u0018\u0010\u007f\u001a\u00020\u00168\u0006\u00a2\u0006\r\n\u0004\b\u007f\u0010\u0018\u001a\u0005\b\u0080\u0001\u0010\u001aR\u001a\u0010\u0081\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u0081\u0001\u0010\u0018\u001a\u0005\b\u0082\u0001\u0010\u001aR\u001a\u0010\u0083\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u0083\u0001\u0010\u0018\u001a\u0005\b\u0084\u0001\u0010\u001aR\u001a\u0010\u0085\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u0085\u0001\u0010\u0018\u001a\u0005\b\u0086\u0001\u0010\u001aR\u001a\u0010\u0087\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u0087\u0001\u0010\u0018\u001a\u0005\b\u0088\u0001\u0010\u001aR\u001a\u0010\u0089\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u0089\u0001\u0010\u0018\u001a\u0005\b\u008a\u0001\u0010\u001aR\u001a\u0010\u008b\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u008b\u0001\u0010\u0018\u001a\u0005\b\u008c\u0001\u0010\u001aR\u001a\u0010\u008d\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u008d\u0001\u0010\u0018\u001a\u0005\b\u008e\u0001\u0010\u001aR\u001a\u0010\u008f\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u008f\u0001\u0010\u0018\u001a\u0005\b\u0090\u0001\u0010\u001aR\u001a\u0010\u0091\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u0091\u0001\u0010\u0018\u001a\u0005\b\u0092\u0001\u0010\u001aR\u001a\u0010\u0093\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u0093\u0001\u0010\u0018\u001a\u0005\b\u0094\u0001\u0010\u001aR\u001a\u0010\u0095\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u0095\u0001\u0010\u0018\u001a\u0005\b\u0096\u0001\u0010\u001aR\u001a\u0010\u0097\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u0097\u0001\u0010\u0018\u001a\u0005\b\u0098\u0001\u0010\u001aR\u001a\u0010\u0099\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u0099\u0001\u0010\u0018\u001a\u0005\b\u009a\u0001\u0010\u001aR\u001a\u0010\u009b\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u009b\u0001\u0010\u0018\u001a\u0005\b\u009c\u0001\u0010\u001aR\u001a\u0010\u009d\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u009d\u0001\u0010\u0018\u001a\u0005\b\u009e\u0001\u0010\u001aR\u001a\u0010\u009f\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u009f\u0001\u0010\u0018\u001a\u0005\b\u00a0\u0001\u0010\u001aR\u001a\u0010\u00a1\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00a1\u0001\u0010\u0018\u001a\u0005\b\u00a2\u0001\u0010\u001aR\u001a\u0010\u00a3\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00a3\u0001\u0010\u0018\u001a\u0005\b\u00a4\u0001\u0010\u001aR\u001a\u0010\u00a5\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00a5\u0001\u0010\u0018\u001a\u0005\b\u00a6\u0001\u0010\u001aR\u001a\u0010\u00a7\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00a7\u0001\u0010\u0018\u001a\u0005\b\u00a8\u0001\u0010\u001aR\u001a\u0010\u00a9\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00a9\u0001\u0010\u0018\u001a\u0005\b\u00aa\u0001\u0010\u001aR\u001a\u0010\u00ab\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00ab\u0001\u0010\u0018\u001a\u0005\b\u00ac\u0001\u0010\u001aR\u001a\u0010\u00ad\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00ad\u0001\u0010\u0018\u001a\u0005\b\u00ae\u0001\u0010\u001aR\u001a\u0010\u00af\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00af\u0001\u0010\u0018\u001a\u0005\b\u00b0\u0001\u0010\u001aR\u001a\u0010\u00b1\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00b1\u0001\u0010\u0018\u001a\u0005\b\u00b2\u0001\u0010\u001aR\u001a\u0010\u00b3\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00b3\u0001\u0010\u0018\u001a\u0005\b\u00b4\u0001\u0010\u001aR\u001a\u0010\u00b5\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00b5\u0001\u0010\u0018\u001a\u0005\b\u00b6\u0001\u0010\u001aR\u001a\u0010\u00b7\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00b7\u0001\u0010\u0018\u001a\u0005\b\u00b8\u0001\u0010\u001aR\u001a\u0010\u00b9\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00b9\u0001\u0010\u0018\u001a\u0005\b\u00ba\u0001\u0010\u001aR\u001a\u0010\u00bb\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00bb\u0001\u0010\u0018\u001a\u0005\b\u00bc\u0001\u0010\u001aR\u001a\u0010\u00bd\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00bd\u0001\u0010\u0018\u001a\u0005\b\u00be\u0001\u0010\u001aR\u001a\u0010\u00bf\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00bf\u0001\u0010\u0018\u001a\u0005\b\u00c0\u0001\u0010\u001aR\u001a\u0010\u00c1\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00c1\u0001\u0010\u0018\u001a\u0005\b\u00c2\u0001\u0010\u001aR\u001a\u0010\u00c3\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00c3\u0001\u0010\u0018\u001a\u0005\b\u00c4\u0001\u0010\u001aR\u001a\u0010\u00c5\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00c5\u0001\u0010\u0018\u001a\u0005\b\u00c6\u0001\u0010\u001aR\u001a\u0010\u00c7\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00c7\u0001\u0010\u0018\u001a\u0005\b\u00c8\u0001\u0010\u001aR\u001a\u0010\u00c9\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00c9\u0001\u0010\u0018\u001a\u0005\b\u00ca\u0001\u0010\u001aR\u001a\u0010\u00cb\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00cb\u0001\u0010\u0018\u001a\u0005\b\u00cc\u0001\u0010\u001aR\u001a\u0010\u00cd\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00cd\u0001\u0010\u0018\u001a\u0005\b\u00ce\u0001\u0010\u001aR\u001a\u0010\u00cf\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00cf\u0001\u0010\u0018\u001a\u0005\b\u00d0\u0001\u0010\u001aR\u001a\u0010\u00d1\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00d1\u0001\u0010\u0018\u001a\u0005\b\u00d2\u0001\u0010\u001aR\u001a\u0010\u00d3\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00d3\u0001\u0010\u0018\u001a\u0005\b\u00d4\u0001\u0010\u001aR\u001a\u0010\u00d5\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00d5\u0001\u0010\u0018\u001a\u0005\b\u00d6\u0001\u0010\u001aR\u001a\u0010\u00d7\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00d7\u0001\u0010\u0018\u001a\u0005\b\u00d8\u0001\u0010\u001aR\u001a\u0010\u00d9\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00d9\u0001\u0010\u0018\u001a\u0005\b\u00da\u0001\u0010\u001aR\u001a\u0010\u00db\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00db\u0001\u0010\u0018\u001a\u0005\b\u00dc\u0001\u0010\u001aR\u001a\u0010\u00dd\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00dd\u0001\u0010\u0018\u001a\u0005\b\u00de\u0001\u0010\u001aR\u001a\u0010\u00df\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00df\u0001\u0010\u0018\u001a\u0005\b\u00e0\u0001\u0010\u001aR\u001a\u0010\u00e1\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00e1\u0001\u0010\u0018\u001a\u0005\b\u00e2\u0001\u0010\u001aR\u001a\u0010\u00e3\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00e3\u0001\u0010\u0018\u001a\u0005\b\u00e4\u0001\u0010\u001aR\u001a\u0010\u00e5\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00e5\u0001\u0010\u0018\u001a\u0005\b\u00e6\u0001\u0010\u001aR\u001a\u0010\u00e7\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00e7\u0001\u0010\u0018\u001a\u0005\b\u00e8\u0001\u0010\u001aR\u001a\u0010\u00e9\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00e9\u0001\u0010\u0018\u001a\u0005\b\u00ea\u0001\u0010\u001aR\u001a\u0010\u00eb\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00eb\u0001\u0010\u0018\u001a\u0005\b\u00ec\u0001\u0010\u001aR\u001a\u0010\u00ed\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00ed\u0001\u0010\u0018\u001a\u0005\b\u00ee\u0001\u0010\u001aR\u001a\u0010\u00ef\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00ef\u0001\u0010\u0018\u001a\u0005\b\u00f0\u0001\u0010\u001aR\u001a\u0010\u00f1\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00f1\u0001\u0010\u0018\u001a\u0005\b\u00f2\u0001\u0010\u001aR\u001a\u0010\u00f3\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00f3\u0001\u0010\u0018\u001a\u0005\b\u00f4\u0001\u0010\u001aR\u001a\u0010\u00f5\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00f5\u0001\u0010\u0018\u001a\u0005\b\u00f6\u0001\u0010\u001aR\u001a\u0010\u00f7\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00f7\u0001\u0010\u0018\u001a\u0005\b\u00f8\u0001\u0010\u001aR\u001a\u0010\u00f9\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00f9\u0001\u0010\u0018\u001a\u0005\b\u00fa\u0001\u0010\u001aR\u001a\u0010\u00fb\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00fb\u0001\u0010\u0018\u001a\u0005\b\u00fc\u0001\u0010\u001aR\u001a\u0010\u00fd\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00fd\u0001\u0010\u0018\u001a\u0005\b\u00fe\u0001\u0010\u001aR\u001a\u0010\u00ff\u0001\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00ff\u0001\u0010\u0018\u001a\u0005\b\u0080\u0002\u0010\u001aR\u001a\u0010\u0081\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u0081\u0002\u0010\u0018\u001a\u0005\b\u0082\u0002\u0010\u001aR\u001a\u0010\u0083\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u0083\u0002\u0010\u0018\u001a\u0005\b\u0084\u0002\u0010\u001aR\u001a\u0010\u0085\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u0085\u0002\u0010\u0018\u001a\u0005\b\u0086\u0002\u0010\u001aR\u001a\u0010\u0087\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u0087\u0002\u0010\u0018\u001a\u0005\b\u0088\u0002\u0010\u001aR\u001a\u0010\u0089\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u0089\u0002\u0010\u0018\u001a\u0005\b\u008a\u0002\u0010\u001aR\u001a\u0010\u008b\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u008b\u0002\u0010\u0018\u001a\u0005\b\u008c\u0002\u0010\u001aR\u001a\u0010\u008d\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u008d\u0002\u0010\u0018\u001a\u0005\b\u008e\u0002\u0010\u001aR\u001a\u0010\u008f\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u008f\u0002\u0010\u0018\u001a\u0005\b\u0090\u0002\u0010\u001aR\u001a\u0010\u0091\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u0091\u0002\u0010\u0018\u001a\u0005\b\u0092\u0002\u0010\u001aR\u001a\u0010\u0093\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u0093\u0002\u0010\u0018\u001a\u0005\b\u0094\u0002\u0010\u001aR\u001a\u0010\u0095\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u0095\u0002\u0010\u0018\u001a\u0005\b\u0096\u0002\u0010\u001aR\u001a\u0010\u0097\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u0097\u0002\u0010\u0018\u001a\u0005\b\u0098\u0002\u0010\u001aR\u001a\u0010\u0099\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u0099\u0002\u0010\u0018\u001a\u0005\b\u009a\u0002\u0010\u001aR\u001a\u0010\u009b\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u009b\u0002\u0010\u0018\u001a\u0005\b\u009c\u0002\u0010\u001aR\u001a\u0010\u009d\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u009d\u0002\u0010\u0018\u001a\u0005\b\u009e\u0002\u0010\u001aR\u001a\u0010\u009f\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u009f\u0002\u0010\u0018\u001a\u0005\b\u00a0\u0002\u0010\u001aR\u001a\u0010\u00a1\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00a1\u0002\u0010\u0018\u001a\u0005\b\u00a2\u0002\u0010\u001aR\u001a\u0010\u00a3\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00a3\u0002\u0010\u0018\u001a\u0005\b\u00a4\u0002\u0010\u001aR\u001a\u0010\u00a5\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00a5\u0002\u0010\u0018\u001a\u0005\b\u00a6\u0002\u0010\u001aR\u001a\u0010\u00a7\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00a7\u0002\u0010\u0018\u001a\u0005\b\u00a8\u0002\u0010\u001aR\u001a\u0010\u00a9\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00a9\u0002\u0010\u0018\u001a\u0005\b\u00aa\u0002\u0010\u001aR\u001a\u0010\u00ab\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00ab\u0002\u0010\u0018\u001a\u0005\b\u00ac\u0002\u0010\u001aR\u001a\u0010\u00ad\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00ad\u0002\u0010\u0018\u001a\u0005\b\u00ae\u0002\u0010\u001aR\u001a\u0010\u00af\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00af\u0002\u0010\u0018\u001a\u0005\b\u00b0\u0002\u0010\u001aR\u001a\u0010\u00b1\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00b1\u0002\u0010\u0018\u001a\u0005\b\u00b2\u0002\u0010\u001aR\u001a\u0010\u00b3\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00b3\u0002\u0010\u0018\u001a\u0005\b\u00b4\u0002\u0010\u001aR\u001a\u0010\u00b5\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00b5\u0002\u0010\u0018\u001a\u0005\b\u00b6\u0002\u0010\u001aR\u001a\u0010\u00b7\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00b7\u0002\u0010\u0018\u001a\u0005\b\u00b8\u0002\u0010\u001aR\u001a\u0010\u00b9\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00b9\u0002\u0010\u0018\u001a\u0005\b\u00ba\u0002\u0010\u001aR\u001a\u0010\u00bb\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00bb\u0002\u0010\u0018\u001a\u0005\b\u00bc\u0002\u0010\u001aR\u001a\u0010\u00bd\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00bd\u0002\u0010\u0018\u001a\u0005\b\u00be\u0002\u0010\u001aR\u001a\u0010\u00bf\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00bf\u0002\u0010\u0018\u001a\u0005\b\u00c0\u0002\u0010\u001aR\u001a\u0010\u00c1\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00c1\u0002\u0010\u0018\u001a\u0005\b\u00c2\u0002\u0010\u001aR\u001a\u0010\u00c3\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00c3\u0002\u0010\u0018\u001a\u0005\b\u00c4\u0002\u0010\u001aR\u001a\u0010\u00c5\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00c5\u0002\u0010\u0018\u001a\u0005\b\u00c6\u0002\u0010\u001aR\u001a\u0010\u00c7\u0002\u001a\u00020\u00168\u0006\u00a2\u0006\u000e\n\u0005\b\u00c7\u0002\u0010\u0018\u001a\u0005\b\u00c8\u0002\u0010\u001a\u00a8\u0006\u00cb\u0002"}, d2={"Lkotlinx/css/Color$Companion;", "", "", "value", "normalizeAlpha", "(D)D", "normalizeFractionalPercent", "", "normalizeHue", "(D)I", "normalizePercent", "(I)I", "normalizeRGB", "Lkotlin/text/Regex;", "HSLA_REGEX$delegate", "Lkotlin/Lazy;", "getHSLA_REGEX", "()Lkotlin/text/Regex;", "HSLA_REGEX", "RGBA_REGEX$delegate", "getRGBA_REGEX", "RGBA_REGEX", "Lkotlinx/css/Color;", "aliceBlue", "Lkotlinx/css/Color;", "getAliceBlue", "()Lkotlinx/css/Color;", "antiqueWhite", "getAntiqueWhite", "aqua", "getAqua", "aquamarine", "getAquamarine", "azure", "getAzure", "beige", "getBeige", "bisque", "getBisque", "black", "getBlack", "blanchedAlmond", "getBlanchedAlmond", "blue", "getBlue", "blueViolet", "getBlueViolet", "brown", "getBrown", "burlyWood", "getBurlyWood", "cadetBlue", "getCadetBlue", "chartreuse", "getChartreuse", "chocolate", "getChocolate", "coral", "getCoral", "cornflowerBlue", "getCornflowerBlue", "cornsilk", "getCornsilk", "crimson", "getCrimson", "currentColor", "getCurrentColor", "cyan", "getCyan", "darkBlue", "getDarkBlue", "darkCyan", "getDarkCyan", "darkGoldenrod", "getDarkGoldenrod", "darkGray", "getDarkGray", "darkGreen", "getDarkGreen", "darkGrey", "getDarkGrey", "darkKhaki", "getDarkKhaki", "darkMagenta", "getDarkMagenta", "darkOliveGreen", "getDarkOliveGreen", "darkOrange", "getDarkOrange", "darkOrchid", "getDarkOrchid", "darkRed", "getDarkRed", "darkSalmon", "getDarkSalmon", "darkSeaGreen", "getDarkSeaGreen", "darkSlateBlue", "getDarkSlateBlue", "darkSlateGray", "getDarkSlateGray", "darkSlateGrey", "getDarkSlateGrey", "darkTurquoise", "getDarkTurquoise", "darkViolet", "getDarkViolet", "deepPink", "getDeepPink", "deepSkyBlue", "getDeepSkyBlue", "dimGray", "getDimGray", "dimGrey", "getDimGrey", "dodgerBlue", "getDodgerBlue", "firebrick", "getFirebrick", "floralWhite", "getFloralWhite", "forestGreen", "getForestGreen", "fuchsia", "getFuchsia", "gainsboro", "getGainsboro", "ghostWhite", "getGhostWhite", "gold", "getGold", "goldenrod", "getGoldenrod", "gray", "getGray", "green", "getGreen", "greenYellow", "getGreenYellow", "grey", "getGrey", "honeydew", "getHoneydew", "hotPink", "getHotPink", "indianRed", "getIndianRed", "indigo", "getIndigo", "inherit", "getInherit", "initial", "getInitial", "ivory", "getIvory", "khaki", "getKhaki", "lavender", "getLavender", "lavenderBlush", "getLavenderBlush", "lawnGreen", "getLawnGreen", "lemonChiffon", "getLemonChiffon", "lightBlue", "getLightBlue", "lightCoral", "getLightCoral", "lightCyan", "getLightCyan", "lightGoldenrodYellow", "getLightGoldenrodYellow", "lightGray", "getLightGray", "lightGreen", "getLightGreen", "lightGrey", "getLightGrey", "lightPink", "getLightPink", "lightSalmon", "getLightSalmon", "lightSeaGreen", "getLightSeaGreen", "lightSkyBlue", "getLightSkyBlue", "lightSlateGray", "getLightSlateGray", "lightSlateGrey", "getLightSlateGrey", "lightSteelBlue", "getLightSteelBlue", "lightYellow", "getLightYellow", "lime", "getLime", "limeGreen", "getLimeGreen", "linen", "getLinen", "magenta", "getMagenta", "maroon", "getMaroon", "mediumAquamarine", "getMediumAquamarine", "mediumBlue", "getMediumBlue", "mediumOrchid", "getMediumOrchid", "mediumPurple", "getMediumPurple", "mediumSeaGreen", "getMediumSeaGreen", "mediumSlateBlue", "getMediumSlateBlue", "mediumSpringGreen", "getMediumSpringGreen", "mediumTurquoise", "getMediumTurquoise", "mediumVioletRed", "getMediumVioletRed", "midnightBlue", "getMidnightBlue", "mintCream", "getMintCream", "mistyRose", "getMistyRose", "moccasin", "getMoccasin", "navajoWhite", "getNavajoWhite", "navy", "getNavy", "oldLace", "getOldLace", "olive", "getOlive", "oliveDrab", "getOliveDrab", "orange", "getOrange", "orangeRed", "getOrangeRed", "orchid", "getOrchid", "paleGoldenrod", "getPaleGoldenrod", "paleGreen", "getPaleGreen", "paleTurquoise", "getPaleTurquoise", "paleVioletRed", "getPaleVioletRed", "papayaWhip", "getPapayaWhip", "peachPuff", "getPeachPuff", "peru", "getPeru", "pink", "getPink", "plum", "getPlum", "powderBlue", "getPowderBlue", "purple", "getPurple", "red", "getRed", "rosyBrown", "getRosyBrown", "royalBlue", "getRoyalBlue", "saddleBrown", "getSaddleBrown", "salmon", "getSalmon", "sandyBrown", "getSandyBrown", "seaGreen", "getSeaGreen", "seaShell", "getSeaShell", "sienna", "getSienna", "silver", "getSilver", "skyBlue", "getSkyBlue", "slateBlue", "getSlateBlue", "slateGray", "getSlateGray", "slateGrey", "getSlateGrey", "snow", "getSnow", "springGreen", "getSpringGreen", "steelBlue", "getSteelBlue", "tan", "getTan", "teal", "getTeal", "thistle", "getThistle", "tomato", "getTomato", "transparent", "getTransparent", "turquoise", "getTurquoise", "unset", "getUnset", "violet", "getViolet", "wheat", "getWheat", "white", "getWhite", "whiteSmoke", "getWhiteSmoke", "yellow", "getYellow", "yellowGreen", "getYellowGreen", "<init>", "()V", "kotlin-css"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Color getInitial() {
            return initial;
        }

        @NotNull
        public final Color getInherit() {
            return inherit;
        }

        @NotNull
        public final Color getUnset() {
            return unset;
        }

        @NotNull
        public final Color getTransparent() {
            return transparent;
        }

        @NotNull
        public final Color getCurrentColor() {
            return currentColor;
        }

        @NotNull
        public final Color getAliceBlue() {
            return aliceBlue;
        }

        @NotNull
        public final Color getAntiqueWhite() {
            return antiqueWhite;
        }

        @NotNull
        public final Color getAqua() {
            return aqua;
        }

        @NotNull
        public final Color getAquamarine() {
            return aquamarine;
        }

        @NotNull
        public final Color getAzure() {
            return azure;
        }

        @NotNull
        public final Color getBeige() {
            return beige;
        }

        @NotNull
        public final Color getBisque() {
            return bisque;
        }

        @NotNull
        public final Color getBlack() {
            return black;
        }

        @NotNull
        public final Color getBlanchedAlmond() {
            return blanchedAlmond;
        }

        @NotNull
        public final Color getBlue() {
            return blue;
        }

        @NotNull
        public final Color getBlueViolet() {
            return blueViolet;
        }

        @NotNull
        public final Color getBrown() {
            return brown;
        }

        @NotNull
        public final Color getBurlyWood() {
            return burlyWood;
        }

        @NotNull
        public final Color getCadetBlue() {
            return cadetBlue;
        }

        @NotNull
        public final Color getChartreuse() {
            return chartreuse;
        }

        @NotNull
        public final Color getChocolate() {
            return chocolate;
        }

        @NotNull
        public final Color getCoral() {
            return coral;
        }

        @NotNull
        public final Color getCornflowerBlue() {
            return cornflowerBlue;
        }

        @NotNull
        public final Color getCornsilk() {
            return cornsilk;
        }

        @NotNull
        public final Color getCrimson() {
            return crimson;
        }

        @NotNull
        public final Color getCyan() {
            return cyan;
        }

        @NotNull
        public final Color getDarkBlue() {
            return darkBlue;
        }

        @NotNull
        public final Color getDarkCyan() {
            return darkCyan;
        }

        @NotNull
        public final Color getDarkGoldenrod() {
            return darkGoldenrod;
        }

        @NotNull
        public final Color getDarkGray() {
            return darkGray;
        }

        @NotNull
        public final Color getDarkGreen() {
            return darkGreen;
        }

        @NotNull
        public final Color getDarkGrey() {
            return darkGrey;
        }

        @NotNull
        public final Color getDarkKhaki() {
            return darkKhaki;
        }

        @NotNull
        public final Color getDarkMagenta() {
            return darkMagenta;
        }

        @NotNull
        public final Color getDarkOliveGreen() {
            return darkOliveGreen;
        }

        @NotNull
        public final Color getDarkOrange() {
            return darkOrange;
        }

        @NotNull
        public final Color getDarkOrchid() {
            return darkOrchid;
        }

        @NotNull
        public final Color getDarkRed() {
            return darkRed;
        }

        @NotNull
        public final Color getDarkSalmon() {
            return darkSalmon;
        }

        @NotNull
        public final Color getDarkSeaGreen() {
            return darkSeaGreen;
        }

        @NotNull
        public final Color getDarkSlateBlue() {
            return darkSlateBlue;
        }

        @NotNull
        public final Color getDarkSlateGray() {
            return darkSlateGray;
        }

        @NotNull
        public final Color getDarkSlateGrey() {
            return darkSlateGrey;
        }

        @NotNull
        public final Color getDarkTurquoise() {
            return darkTurquoise;
        }

        @NotNull
        public final Color getDarkViolet() {
            return darkViolet;
        }

        @NotNull
        public final Color getDeepPink() {
            return deepPink;
        }

        @NotNull
        public final Color getDeepSkyBlue() {
            return deepSkyBlue;
        }

        @NotNull
        public final Color getDimGray() {
            return dimGray;
        }

        @NotNull
        public final Color getDimGrey() {
            return dimGrey;
        }

        @NotNull
        public final Color getDodgerBlue() {
            return dodgerBlue;
        }

        @NotNull
        public final Color getFirebrick() {
            return firebrick;
        }

        @NotNull
        public final Color getFloralWhite() {
            return floralWhite;
        }

        @NotNull
        public final Color getForestGreen() {
            return forestGreen;
        }

        @NotNull
        public final Color getFuchsia() {
            return fuchsia;
        }

        @NotNull
        public final Color getGainsboro() {
            return gainsboro;
        }

        @NotNull
        public final Color getGhostWhite() {
            return ghostWhite;
        }

        @NotNull
        public final Color getGold() {
            return gold;
        }

        @NotNull
        public final Color getGoldenrod() {
            return goldenrod;
        }

        @NotNull
        public final Color getGray() {
            return gray;
        }

        @NotNull
        public final Color getGreen() {
            return green;
        }

        @NotNull
        public final Color getGreenYellow() {
            return greenYellow;
        }

        @NotNull
        public final Color getGrey() {
            return grey;
        }

        @NotNull
        public final Color getHoneydew() {
            return honeydew;
        }

        @NotNull
        public final Color getHotPink() {
            return hotPink;
        }

        @NotNull
        public final Color getIndianRed() {
            return indianRed;
        }

        @NotNull
        public final Color getIndigo() {
            return indigo;
        }

        @NotNull
        public final Color getIvory() {
            return ivory;
        }

        @NotNull
        public final Color getKhaki() {
            return khaki;
        }

        @NotNull
        public final Color getLavender() {
            return lavender;
        }

        @NotNull
        public final Color getLavenderBlush() {
            return lavenderBlush;
        }

        @NotNull
        public final Color getLawnGreen() {
            return lawnGreen;
        }

        @NotNull
        public final Color getLemonChiffon() {
            return lemonChiffon;
        }

        @NotNull
        public final Color getLightBlue() {
            return lightBlue;
        }

        @NotNull
        public final Color getLightCoral() {
            return lightCoral;
        }

        @NotNull
        public final Color getLightCyan() {
            return lightCyan;
        }

        @NotNull
        public final Color getLightGoldenrodYellow() {
            return lightGoldenrodYellow;
        }

        @NotNull
        public final Color getLightGray() {
            return lightGray;
        }

        @NotNull
        public final Color getLightGreen() {
            return lightGreen;
        }

        @NotNull
        public final Color getLightGrey() {
            return lightGrey;
        }

        @NotNull
        public final Color getLightPink() {
            return lightPink;
        }

        @NotNull
        public final Color getLightSalmon() {
            return lightSalmon;
        }

        @NotNull
        public final Color getLightSeaGreen() {
            return lightSeaGreen;
        }

        @NotNull
        public final Color getLightSkyBlue() {
            return lightSkyBlue;
        }

        @NotNull
        public final Color getLightSlateGray() {
            return lightSlateGray;
        }

        @NotNull
        public final Color getLightSlateGrey() {
            return lightSlateGrey;
        }

        @NotNull
        public final Color getLightSteelBlue() {
            return lightSteelBlue;
        }

        @NotNull
        public final Color getLightYellow() {
            return lightYellow;
        }

        @NotNull
        public final Color getLime() {
            return lime;
        }

        @NotNull
        public final Color getLimeGreen() {
            return limeGreen;
        }

        @NotNull
        public final Color getLinen() {
            return linen;
        }

        @NotNull
        public final Color getMagenta() {
            return magenta;
        }

        @NotNull
        public final Color getMaroon() {
            return maroon;
        }

        @NotNull
        public final Color getMediumAquamarine() {
            return mediumAquamarine;
        }

        @NotNull
        public final Color getMediumBlue() {
            return mediumBlue;
        }

        @NotNull
        public final Color getMediumOrchid() {
            return mediumOrchid;
        }

        @NotNull
        public final Color getMediumPurple() {
            return mediumPurple;
        }

        @NotNull
        public final Color getMediumSeaGreen() {
            return mediumSeaGreen;
        }

        @NotNull
        public final Color getMediumSlateBlue() {
            return mediumSlateBlue;
        }

        @NotNull
        public final Color getMediumSpringGreen() {
            return mediumSpringGreen;
        }

        @NotNull
        public final Color getMediumTurquoise() {
            return mediumTurquoise;
        }

        @NotNull
        public final Color getMediumVioletRed() {
            return mediumVioletRed;
        }

        @NotNull
        public final Color getMidnightBlue() {
            return midnightBlue;
        }

        @NotNull
        public final Color getMintCream() {
            return mintCream;
        }

        @NotNull
        public final Color getMistyRose() {
            return mistyRose;
        }

        @NotNull
        public final Color getMoccasin() {
            return moccasin;
        }

        @NotNull
        public final Color getNavajoWhite() {
            return navajoWhite;
        }

        @NotNull
        public final Color getNavy() {
            return navy;
        }

        @NotNull
        public final Color getOldLace() {
            return oldLace;
        }

        @NotNull
        public final Color getOlive() {
            return olive;
        }

        @NotNull
        public final Color getOliveDrab() {
            return oliveDrab;
        }

        @NotNull
        public final Color getOrange() {
            return orange;
        }

        @NotNull
        public final Color getOrangeRed() {
            return orangeRed;
        }

        @NotNull
        public final Color getOrchid() {
            return orchid;
        }

        @NotNull
        public final Color getPaleGoldenrod() {
            return paleGoldenrod;
        }

        @NotNull
        public final Color getPaleGreen() {
            return paleGreen;
        }

        @NotNull
        public final Color getPaleTurquoise() {
            return paleTurquoise;
        }

        @NotNull
        public final Color getPaleVioletRed() {
            return paleVioletRed;
        }

        @NotNull
        public final Color getPapayaWhip() {
            return papayaWhip;
        }

        @NotNull
        public final Color getPeachPuff() {
            return peachPuff;
        }

        @NotNull
        public final Color getPeru() {
            return peru;
        }

        @NotNull
        public final Color getPink() {
            return pink;
        }

        @NotNull
        public final Color getPlum() {
            return plum;
        }

        @NotNull
        public final Color getPowderBlue() {
            return powderBlue;
        }

        @NotNull
        public final Color getPurple() {
            return purple;
        }

        @NotNull
        public final Color getRed() {
            return red;
        }

        @NotNull
        public final Color getRosyBrown() {
            return rosyBrown;
        }

        @NotNull
        public final Color getRoyalBlue() {
            return royalBlue;
        }

        @NotNull
        public final Color getSaddleBrown() {
            return saddleBrown;
        }

        @NotNull
        public final Color getSalmon() {
            return salmon;
        }

        @NotNull
        public final Color getSandyBrown() {
            return sandyBrown;
        }

        @NotNull
        public final Color getSeaGreen() {
            return seaGreen;
        }

        @NotNull
        public final Color getSeaShell() {
            return seaShell;
        }

        @NotNull
        public final Color getSienna() {
            return sienna;
        }

        @NotNull
        public final Color getSilver() {
            return silver;
        }

        @NotNull
        public final Color getSkyBlue() {
            return skyBlue;
        }

        @NotNull
        public final Color getSlateBlue() {
            return slateBlue;
        }

        @NotNull
        public final Color getSlateGray() {
            return slateGray;
        }

        @NotNull
        public final Color getSlateGrey() {
            return slateGrey;
        }

        @NotNull
        public final Color getSnow() {
            return snow;
        }

        @NotNull
        public final Color getSpringGreen() {
            return springGreen;
        }

        @NotNull
        public final Color getSteelBlue() {
            return steelBlue;
        }

        @NotNull
        public final Color getTan() {
            return tan;
        }

        @NotNull
        public final Color getTeal() {
            return teal;
        }

        @NotNull
        public final Color getThistle() {
            return thistle;
        }

        @NotNull
        public final Color getTomato() {
            return tomato;
        }

        @NotNull
        public final Color getTurquoise() {
            return turquoise;
        }

        @NotNull
        public final Color getViolet() {
            return violet;
        }

        @NotNull
        public final Color getWheat() {
            return wheat;
        }

        @NotNull
        public final Color getWhite() {
            return white;
        }

        @NotNull
        public final Color getWhiteSmoke() {
            return whiteSmoke;
        }

        @NotNull
        public final Color getYellow() {
            return yellow;
        }

        @NotNull
        public final Color getYellowGreen() {
            return yellowGreen;
        }

        public final double normalizeFractionalPercent(double value) {
            return RangesKt.coerceIn((double)value, (double)0.0, (double)1.0);
        }

        public final int normalizePercent(int value) {
            return RangesKt.coerceIn((int)value, (int)0, (int)100);
        }

        public final int normalizeRGB(int value) {
            return RangesKt.coerceIn((int)value, (int)0, (int)255);
        }

        public final int normalizeHue(double value) {
            return MathKt.roundToInt((double)((value % (double)360 + (double)360) % (double)360));
        }

        public final double normalizeAlpha(double value) {
            return this.normalizeFractionalPercent(value);
        }

        private final Regex getHSLA_REGEX() {
            Lazy lazy = HSLA_REGEX$delegate;
            return (Regex)lazy.getValue();
        }

        private final Regex getRGBA_REGEX() {
            Lazy lazy = RGBA_REGEX$delegate;
            return (Regex)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0080\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\r\u001a\u00020\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u0005\u0012\u0006\u0010\u000f\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0010\u001a\u00020\n\u00a2\u0006\u0004\b!\u0010\"J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\u0007J\u0010\u0010\t\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\nH\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ8\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u00052\b\b\u0002\u0010\u0010\u001a\u00020\nH\u00c6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001a\u0010\u0015\u001a\u00020\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0007J\u0010\u0010\u0019\u001a\u00020\u0018H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0017\u0010\u0010\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\u001b\u001a\u0004\b\u001c\u0010\fR\u0017\u0010\r\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u001d\u001a\u0004\b\u001e\u0010\u0007R\u0017\u0010\u000f\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u001d\u001a\u0004\b\u001f\u0010\u0007R\u0017\u0010\u000e\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u001d\u001a\u0004\b \u0010\u0007\u00a8\u0006#"}, d2={"Lkotlinx/css/Color$HSLA;", "", "Lkotlinx/css/Color$RGBA;", "asRGBA", "()Lkotlinx/css/Color$RGBA;", "", "component1", "()I", "component2", "component3", "", "component4", "()D", "hue", "saturation", "lightness", "alpha", "copy", "(IIID)Lkotlinx/css/Color$HSLA;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "D", "getAlpha", "I", "getHue", "getLightness", "getSaturation", "<init>", "(IIID)V", "kotlin-css"})
    public static final class HSLA {
        private final int hue;
        private final int saturation;
        private final int lightness;
        private final double alpha;

        public HSLA(int hue, int saturation, int lightness, double alpha) {
            this.hue = hue;
            this.saturation = saturation;
            this.lightness = lightness;
            this.alpha = alpha;
        }

        public /* synthetic */ HSLA(int n, int n2, int n3, double d, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 8) != 0) {
                d = 1.0;
            }
            this(n, n2, n3, d);
        }

        public final int getHue() {
            return this.hue;
        }

        public final int getSaturation() {
            return this.saturation;
        }

        public final int getLightness() {
            return this.lightness;
        }

        public final double getAlpha() {
            return this.alpha;
        }

        @NotNull
        public final RGBA asRGBA() {
            if (this.saturation == 0) {
                return new RGBA(this.lightness, this.lightness, this.lightness, 0.0, 8, null);
            }
            double h = (double)this.hue % 360.0 / 360.0;
            double s = (double)this.saturation / 100.0;
            double lg = (double)this.lightness / 100.0;
            double m2 = lg < 0.5 ? lg * (1.0 + s) : lg + s - lg * s;
            double m1 = (double)2 * lg - m2;
            double r = Companion.normalizeFractionalPercent(HSLA.asRGBA$hueToRGB(m1, m2, h + 0.3333333333333333));
            double g = Companion.normalizeFractionalPercent(HSLA.asRGBA$hueToRGB(m1, m2, h));
            double b = Companion.normalizeFractionalPercent(HSLA.asRGBA$hueToRGB(m1, m2, h - 0.3333333333333333));
            return new RGBA(MathKt.roundToInt((double)(r * (double)255)), MathKt.roundToInt((double)(g * (double)255)), MathKt.roundToInt((double)(b * (double)255)), this.alpha);
        }

        public final int component1() {
            return this.hue;
        }

        public final int component2() {
            return this.saturation;
        }

        public final int component3() {
            return this.lightness;
        }

        public final double component4() {
            return this.alpha;
        }

        @NotNull
        public final HSLA copy(int hue, int saturation, int lightness, double alpha) {
            return new HSLA(hue, saturation, lightness, alpha);
        }

        public static /* synthetic */ HSLA copy$default(HSLA hSLA, int n, int n2, int n3, double d, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = hSLA.hue;
            }
            if ((n4 & 2) != 0) {
                n2 = hSLA.saturation;
            }
            if ((n4 & 4) != 0) {
                n3 = hSLA.lightness;
            }
            if ((n4 & 8) != 0) {
                d = hSLA.alpha;
            }
            return hSLA.copy(n, n2, n3, d);
        }

        @NotNull
        public String toString() {
            return "HSLA(hue=" + this.hue + ", saturation=" + this.saturation + ", lightness=" + this.lightness + ", alpha=" + this.alpha + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.hue);
            result2 = result2 * 31 + Integer.hashCode(this.saturation);
            result2 = result2 * 31 + Integer.hashCode(this.lightness);
            result2 = result2 * 31 + Double.hashCode(this.alpha);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HSLA)) {
                return false;
            }
            HSLA hSLA = (HSLA)other;
            if (this.hue != hSLA.hue) {
                return false;
            }
            if (this.saturation != hSLA.saturation) {
                return false;
            }
            if (this.lightness != hSLA.lightness) {
                return false;
            }
            return Double.compare(this.alpha, hSLA.alpha) == 0;
        }

        private static final double asRGBA$hueToRGB(double m1, double m2, double h) {
            double hu = h < 0.0 ? h + 1.0 : (h > 1.0 ? h - 1.0 : h);
            return hu < 0.16666666666666666 ? m1 + (m2 - m1) * (double)6 * hu : (hu < 0.5 ? m2 : (hu < 0.6666666666666666 ? m1 + (m2 - m1) * (double)6 * (0.6666666666666666 - hu) : m1));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0080\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\r\u001a\u00020\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u0005\u0012\u0006\u0010\u000f\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0010\u001a\u00020\n\u00a2\u0006\u0004\b!\u0010\"J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\u0007J\u0010\u0010\t\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\nH\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ8\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u00052\b\b\u0002\u0010\u0010\u001a\u00020\nH\u00c6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001a\u0010\u0015\u001a\u00020\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0007J\u0010\u0010\u0019\u001a\u00020\u0018H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0017\u0010\u0010\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\u001b\u001a\u0004\b\u001c\u0010\fR\u0017\u0010\u000f\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u001d\u001a\u0004\b\u001e\u0010\u0007R\u0017\u0010\u000e\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u001d\u001a\u0004\b\u001f\u0010\u0007R\u0017\u0010\r\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u001d\u001a\u0004\b \u0010\u0007\u00a8\u0006#"}, d2={"Lkotlinx/css/Color$RGBA;", "", "Lkotlinx/css/Color$HSLA;", "asHSLA", "()Lkotlinx/css/Color$HSLA;", "", "component1", "()I", "component2", "component3", "", "component4", "()D", "red", "green", "blue", "alpha", "copy", "(IIID)Lkotlinx/css/Color$RGBA;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "D", "getAlpha", "I", "getBlue", "getGreen", "getRed", "<init>", "(IIID)V", "kotlin-css"})
    public static final class RGBA {
        private final int red;
        private final int green;
        private final int blue;
        private final double alpha;

        public RGBA(int red, int green, int blue, double alpha) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
        }

        public /* synthetic */ RGBA(int n, int n2, int n3, double d, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 8) != 0) {
                d = 1.0;
            }
            this(n, n2, n3, d);
        }

        public final int getRed() {
            return this.red;
        }

        public final int getGreen() {
            return this.green;
        }

        public final int getBlue() {
            return this.blue;
        }

        public final double getAlpha() {
            return this.alpha;
        }

        @NotNull
        public final HSLA asHSLA() {
            double d;
            double r = (double)this.red / 255.0;
            double g = (double)this.green / 255.0;
            double b = (double)this.blue / 255.0;
            double cMax = Math.max(r, Math.max(g, b));
            double cMin = Math.min(r, Math.min(g, b));
            double chroma = cMax - cMin;
            double lg = Companion.normalizeFractionalPercent((cMax + cMin) / (double)2);
            double s = !(chroma == 0.0) ? Companion.normalizeFractionalPercent(chroma / (1.0 - Math.abs(2.0 * lg - 1.0))) : 0.0;
            double d2 = cMax;
            if (d2 == cMin) {
                d = 0.0;
            } else if (d2 == r) {
                d = (double)60 * ((g - b) / chroma % 6.0);
            } else if (d2 == g) {
                d = (double)60 * ((b - r) / chroma + (double)2);
            } else if (d2 == b) {
                d = (double)60 * ((r - g) / chroma + (double)4);
            } else {
                throw new IllegalStateException("Unexpected value for max".toString());
            }
            double h = d;
            return new HSLA(Companion.normalizeHue(h), MathKt.roundToInt((double)(s * (double)100)), MathKt.roundToInt((double)(lg * (double)100)), this.alpha);
        }

        public final int component1() {
            return this.red;
        }

        public final int component2() {
            return this.green;
        }

        public final int component3() {
            return this.blue;
        }

        public final double component4() {
            return this.alpha;
        }

        @NotNull
        public final RGBA copy(int red, int green, int blue, double alpha) {
            return new RGBA(red, green, blue, alpha);
        }

        public static /* synthetic */ RGBA copy$default(RGBA rGBA, int n, int n2, int n3, double d, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = rGBA.red;
            }
            if ((n4 & 2) != 0) {
                n2 = rGBA.green;
            }
            if ((n4 & 4) != 0) {
                n3 = rGBA.blue;
            }
            if ((n4 & 8) != 0) {
                d = rGBA.alpha;
            }
            return rGBA.copy(n, n2, n3, d);
        }

        @NotNull
        public String toString() {
            return "RGBA(red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + ", alpha=" + this.alpha + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.red);
            result2 = result2 * 31 + Integer.hashCode(this.green);
            result2 = result2 * 31 + Integer.hashCode(this.blue);
            result2 = result2 * 31 + Double.hashCode(this.alpha);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RGBA)) {
                return false;
            }
            RGBA rGBA = (RGBA)other;
            if (this.red != rGBA.red) {
                return false;
            }
            if (this.green != rGBA.green) {
                return false;
            }
            if (this.blue != rGBA.blue) {
                return false;
            }
            return Double.compare(this.alpha, rGBA.alpha) == 0;
        }
    }
}

