/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonLiteral;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.internal.StringOpsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000^\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0007\u001a\u0017\u0010\u0003\u001a\u00020\u00022\b\u0010\u0001\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0019\u0010\u0003\u001a\u00020\u00062\b\u0010\u0001\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0007\u001a\u0017\u0010\u0003\u001a\u00020\u00022\b\u0010\u0001\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0003\u0010\t\u001a\u0017\u0010\u0003\u001a\u00020\u00022\b\u0010\u0001\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0003\u0010\u000b\u001a\u001f\u0010\u000e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u001b\u0010\u0012\u001a\u00020\u0005*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013\"\u0015\u0010\u0016\u001a\u00020\u0000*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\"\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u0000*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\"\u0017\u0010\u001c\u001a\u0004\u0018\u00010\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\"\u0015\u0010 \u001a\u00020\u001d*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\"\u0017\u0010#\u001a\u0004\u0018\u00010\u001d*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\"\u0015\u0010'\u001a\u00020$*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\"\u0017\u0010*\u001a\u0004\u0018\u00010$*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\"\u0015\u0010.\u001a\u00020+*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\"\u0017\u00101\u001a\u0004\u0018\u00010+*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b/\u00100\"\u0015\u00105\u001a\u000202*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b3\u00104\"\u0015\u00108\u001a\u00020\u0006*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b6\u00107\"\u0015\u0010<\u001a\u000209*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b:\u0010;\"\u0015\u0010?\u001a\u00020\u0002*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b=\u0010>\"\u0015\u0010C\u001a\u00020@*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\bA\u0010B\"\u0017\u0010F\u001a\u0004\u0018\u00010@*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\bD\u0010E\u00a8\u0006G"}, d2={"", "value", "Lkotlinx/serialization/json/JsonPrimitive;", "JsonPrimitive", "(Ljava/lang/Boolean;)Lkotlinx/serialization/json/JsonPrimitive;", "", "Lkotlinx/serialization/json/JsonNull;", "(Ljava/lang/Void;)Lkotlinx/serialization/json/JsonNull;", "", "(Ljava/lang/Number;)Lkotlinx/serialization/json/JsonPrimitive;", "", "(Ljava/lang/String;)Lkotlinx/serialization/json/JsonPrimitive;", "key", "expected", "unexpectedJson", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Void;", "Lkotlinx/serialization/json/JsonElement;", "element", "error", "(Lkotlinx/serialization/json/JsonElement;Ljava/lang/String;)Ljava/lang/Void;", "getBoolean", "(Lkotlinx/serialization/json/JsonPrimitive;)Z", "boolean", "getBooleanOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/Boolean;", "booleanOrNull", "getContentOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/String;", "contentOrNull", "", "getDouble", "(Lkotlinx/serialization/json/JsonPrimitive;)D", "double", "getDoubleOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/Double;", "doubleOrNull", "", "getFloat", "(Lkotlinx/serialization/json/JsonPrimitive;)F", "float", "getFloatOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/Float;", "floatOrNull", "", "getInt", "(Lkotlinx/serialization/json/JsonPrimitive;)I", "int", "getIntOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/Integer;", "intOrNull", "Lkotlinx/serialization/json/JsonArray;", "getJsonArray", "(Lkotlinx/serialization/json/JsonElement;)Lkotlinx/serialization/json/JsonArray;", "jsonArray", "getJsonNull", "(Lkotlinx/serialization/json/JsonElement;)Lkotlinx/serialization/json/JsonNull;", "jsonNull", "Lkotlinx/serialization/json/JsonObject;", "getJsonObject", "(Lkotlinx/serialization/json/JsonElement;)Lkotlinx/serialization/json/JsonObject;", "jsonObject", "getJsonPrimitive", "(Lkotlinx/serialization/json/JsonElement;)Lkotlinx/serialization/json/JsonPrimitive;", "jsonPrimitive", "", "getLong", "(Lkotlinx/serialization/json/JsonPrimitive;)J", "long", "getLongOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/Long;", "longOrNull", "kotlinx-serialization-json"})
public final class JsonElementKt {
    @NotNull
    public static final JsonPrimitive JsonPrimitive(@Nullable Boolean value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonLiteral(value, false);
    }

    @NotNull
    public static final JsonPrimitive JsonPrimitive(@Nullable Number value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonLiteral(value, false);
    }

    @NotNull
    public static final JsonPrimitive JsonPrimitive(@Nullable String value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonLiteral(value, true);
    }

    @ExperimentalSerializationApi
    @NotNull
    public static final JsonNull JsonPrimitive(@Nullable Void value) {
        return JsonNull.INSTANCE;
    }

    @NotNull
    public static final JsonPrimitive getJsonPrimitive(@NotNull JsonElement $this$jsonPrimitive) {
        Intrinsics.checkNotNullParameter((Object)$this$jsonPrimitive, (String)"<this>");
        JsonPrimitive jsonPrimitive = $this$jsonPrimitive instanceof JsonPrimitive ? (JsonPrimitive)$this$jsonPrimitive : null;
        if (jsonPrimitive == null) {
            JsonElementKt.error($this$jsonPrimitive, "JsonPrimitive");
            throw new KotlinNothingValueException();
        }
        return jsonPrimitive;
    }

    @NotNull
    public static final JsonObject getJsonObject(@NotNull JsonElement $this$jsonObject) {
        Intrinsics.checkNotNullParameter((Object)$this$jsonObject, (String)"<this>");
        JsonObject jsonObject = $this$jsonObject instanceof JsonObject ? (JsonObject)$this$jsonObject : null;
        if (jsonObject == null) {
            JsonElementKt.error($this$jsonObject, "JsonObject");
            throw new KotlinNothingValueException();
        }
        return jsonObject;
    }

    @NotNull
    public static final JsonArray getJsonArray(@NotNull JsonElement $this$jsonArray) {
        Intrinsics.checkNotNullParameter((Object)$this$jsonArray, (String)"<this>");
        JsonArray jsonArray = $this$jsonArray instanceof JsonArray ? (JsonArray)$this$jsonArray : null;
        if (jsonArray == null) {
            JsonElementKt.error($this$jsonArray, "JsonArray");
            throw new KotlinNothingValueException();
        }
        return jsonArray;
    }

    @NotNull
    public static final JsonNull getJsonNull(@NotNull JsonElement $this$jsonNull) {
        Intrinsics.checkNotNullParameter((Object)$this$jsonNull, (String)"<this>");
        JsonNull jsonNull = $this$jsonNull instanceof JsonNull ? (JsonNull)$this$jsonNull : null;
        if (jsonNull == null) {
            JsonElementKt.error($this$jsonNull, "JsonNull");
            throw new KotlinNothingValueException();
        }
        return jsonNull;
    }

    public static final int getInt(@NotNull JsonPrimitive $this$int) {
        Intrinsics.checkNotNullParameter((Object)$this$int, (String)"<this>");
        return Integer.parseInt($this$int.getContent());
    }

    @Nullable
    public static final Integer getIntOrNull(@NotNull JsonPrimitive $this$intOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$intOrNull, (String)"<this>");
        return StringsKt.toIntOrNull((String)$this$intOrNull.getContent());
    }

    public static final long getLong(@NotNull JsonPrimitive $this$long) {
        Intrinsics.checkNotNullParameter((Object)$this$long, (String)"<this>");
        return Long.parseLong($this$long.getContent());
    }

    @Nullable
    public static final Long getLongOrNull(@NotNull JsonPrimitive $this$longOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$longOrNull, (String)"<this>");
        return StringsKt.toLongOrNull((String)$this$longOrNull.getContent());
    }

    public static final double getDouble(@NotNull JsonPrimitive $this$double) {
        Intrinsics.checkNotNullParameter((Object)$this$double, (String)"<this>");
        return Double.parseDouble($this$double.getContent());
    }

    @Nullable
    public static final Double getDoubleOrNull(@NotNull JsonPrimitive $this$doubleOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$doubleOrNull, (String)"<this>");
        return StringsKt.toDoubleOrNull((String)$this$doubleOrNull.getContent());
    }

    public static final float getFloat(@NotNull JsonPrimitive $this$float) {
        Intrinsics.checkNotNullParameter((Object)$this$float, (String)"<this>");
        return Float.parseFloat($this$float.getContent());
    }

    @Nullable
    public static final Float getFloatOrNull(@NotNull JsonPrimitive $this$floatOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$floatOrNull, (String)"<this>");
        return StringsKt.toFloatOrNull((String)$this$floatOrNull.getContent());
    }

    public static final boolean getBoolean(@NotNull JsonPrimitive $this$boolean) {
        Intrinsics.checkNotNullParameter((Object)$this$boolean, (String)"<this>");
        Boolean bl = StringOpsKt.toBooleanStrictOrNull($this$boolean.getContent());
        if (bl == null) {
            throw new IllegalStateException($this$boolean + " does not represent a Boolean");
        }
        return bl;
    }

    @Nullable
    public static final Boolean getBooleanOrNull(@NotNull JsonPrimitive $this$booleanOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$booleanOrNull, (String)"<this>");
        return StringOpsKt.toBooleanStrictOrNull($this$booleanOrNull.getContent());
    }

    @Nullable
    public static final String getContentOrNull(@NotNull JsonPrimitive $this$contentOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$contentOrNull, (String)"<this>");
        return $this$contentOrNull instanceof JsonNull ? null : $this$contentOrNull.getContent();
    }

    private static final Void error(JsonElement $this$error, String element) {
        throw new IllegalArgumentException("Element " + Reflection.getOrCreateKotlinClass($this$error.getClass()) + " is not a " + element);
    }

    @PublishedApi
    @NotNull
    public static final Void unexpectedJson(@NotNull String key2, @NotNull String expected) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        throw new IllegalArgumentException("Element " + key2 + " is not a " + expected);
    }
}

