/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.internal.JsonInternalDependenciesKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.JsonSchemaCacheKt;
import kotlinx.serialization.json.internal.AbstractJsonTreeDecoder;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.JsonNamesMapKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0012\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010+\u001a\u00020*\u0012\u0006\u0010&\u001a\u00020%\u0012\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b,\u0010-J\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0016\u0010!\u001a\u0004\u0018\u00010\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0016\u0010#\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u001a\u0010&\u001a\u00020%8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\u00a8\u0006."}, d2={"Lkotlinx/serialization/json/internal/JsonTreeDecoder;", "Lkotlinx/serialization/json/internal/AbstractJsonTreeDecoder;", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "", "index", "", "absenceIsNull", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I)Z", "Lkotlinx/serialization/encoding/CompositeDecoder;", "beginStructure", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)Lkotlinx/serialization/encoding/CompositeDecoder;", "", "tag", "coerceInputValue", "(Lkotlinx/serialization/descriptors/SerialDescriptor;ILjava/lang/String;)Z", "Lkotlinx/serialization/json/JsonElement;", "currentElement", "(Ljava/lang/String;)Lkotlinx/serialization/json/JsonElement;", "decodeElementIndex", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)I", "decodeNotNullMark", "()Z", "desc", "elementName", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I)Ljava/lang/String;", "", "endStructure", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "forceNull", "Z", "polyDescriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "polyDiscriminator", "Ljava/lang/String;", "position", "I", "Lkotlinx/serialization/json/JsonObject;", "value", "Lkotlinx/serialization/json/JsonObject;", "getValue", "()Lkotlinx/serialization/json/JsonObject;", "Lkotlinx/serialization/json/Json;", "json", "<init>", "(Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/JsonObject;Ljava/lang/String;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "kotlinx-serialization-json"})
class JsonTreeDecoder
extends AbstractJsonTreeDecoder {
    @NotNull
    private final JsonObject value;
    @Nullable
    private final String polyDiscriminator;
    @Nullable
    private final SerialDescriptor polyDescriptor;
    private int position;
    private boolean forceNull;

    public JsonTreeDecoder(@NotNull Json json, @NotNull JsonObject value, @Nullable String polyDiscriminator, @Nullable SerialDescriptor polyDescriptor) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        super(json, value, null);
        this.value = value;
        this.polyDiscriminator = polyDiscriminator;
        this.polyDescriptor = polyDescriptor;
    }

    public /* synthetic */ JsonTreeDecoder(Json json, JsonObject jsonObject, String string, SerialDescriptor serialDescriptor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            serialDescriptor = null;
        }
        this(json, jsonObject, string, serialDescriptor);
    }

    @Override
    @NotNull
    public JsonObject getValue() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean coerceInputValue(SerialDescriptor descriptor2, int index, String tag) {
        void $this$tryCoerceValue_u24default$iv;
        void elementDescriptor$iv;
        Json json = this.getJson();
        SerialDescriptor serialDescriptor = descriptor2.getElementDescriptor(index);
        boolean $i$f$tryCoerceValue = false;
        if (!elementDescriptor$iv.isNullable()) {
            boolean bl = false;
            if (this.currentElement(tag) instanceof JsonNull) {
                return true;
            }
        }
        if (!Intrinsics.areEqual((Object)elementDescriptor$iv.getKind(), (Object)SerialKind.ENUM.INSTANCE)) return false;
        boolean bl = false;
        JsonElement jsonElement = this.currentElement(tag);
        if (!(jsonElement instanceof JsonPrimitive)) return false;
        JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
        if (jsonPrimitive == null) return false;
        String string = JsonElementKt.getContentOrNull(jsonPrimitive);
        if (string == null) {
            return false;
        }
        String enumValue$iv = string;
        int enumIndex$iv = JsonNamesMapKt.getJsonNameIndex((SerialDescriptor)elementDescriptor$iv, (Json)$this$tryCoerceValue_u24default$iv, enumValue$iv);
        if (enumIndex$iv != -3) return false;
        return true;
    }

    @Override
    public int decodeElementIndex(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        while (this.position < descriptor2.getElementsCount()) {
            int n = this.position;
            this.position = n + 1;
            String name = this.getTag(descriptor2, n);
            int index = this.position - 1;
            this.forceNull = false;
            if (!((Map)this.getValue()).containsKey(name) && !this.absenceIsNull(descriptor2, index) || this.configuration.getCoerceInputValues() && this.coerceInputValue(descriptor2, index, name)) continue;
            return index;
        }
        return -1;
    }

    private final boolean absenceIsNull(SerialDescriptor descriptor2, int index) {
        this.forceNull = !this.getJson().getConfiguration().getExplicitNulls() && !descriptor2.isElementOptional(index) && descriptor2.getElementDescriptor(index).isNullable();
        return this.forceNull;
    }

    @Override
    public boolean decodeNotNullMark() {
        return !this.forceNull && super.decodeNotNullMark();
    }

    @Override
    @NotNull
    protected String elementName(@NotNull SerialDescriptor desc, int index) {
        String nameInObject;
        String string;
        Object v1;
        String mainName;
        block4: {
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            mainName = desc.getElementName(index);
            if (!this.configuration.getUseAlternativeNames()) {
                return mainName;
            }
            if (this.getValue().keySet().contains(mainName)) {
                return mainName;
            }
            Map<String, Integer> alternativeNamesMap2 = JsonSchemaCacheKt.getSchemaCache(this.getJson()).getOrPut(desc, JsonNamesMapKt.getJsonAlternativeNamesKey(), (Function0)new Function0<Map<String, ? extends Integer>>((Object)desc){

                @NotNull
                public final Map<String, Integer> invoke() {
                    return JsonNamesMapKt.buildAlternativeNamesMap((SerialDescriptor)this.receiver);
                }
            });
            Iterable iterable = this.getValue().keySet();
            for (Object t : iterable) {
                String it = (String)t;
                boolean bl = false;
                Integer n = alternativeNamesMap2.get(it);
                int n2 = index;
                if (!(n != null && n == n2)) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        if ((string = (nameInObject = (String)v1)) == null) {
            string = mainName;
        }
        return string;
    }

    @Override
    @NotNull
    protected JsonElement currentElement(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return (JsonElement)MapsKt.getValue((Map)this.getValue(), (Object)tag);
    }

    @Override
    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (descriptor2 == this.polyDescriptor) {
            return this;
        }
        return super.beginStructure(descriptor2);
    }

    @Override
    public void endStructure(@NotNull SerialDescriptor descriptor2) {
        Set set2;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (this.configuration.getIgnoreUnknownKeys() || descriptor2.getKind() instanceof PolymorphicKind) {
            return;
        }
        if (!this.configuration.getUseAlternativeNames()) {
            set2 = JsonInternalDependenciesKt.jsonCachedSerialNames(descriptor2);
        } else {
            Set<String> set3 = JsonInternalDependenciesKt.jsonCachedSerialNames(descriptor2);
            Map<String, Integer> map2 = JsonSchemaCacheKt.getSchemaCache(this.getJson()).get(descriptor2, JsonNamesMapKt.getJsonAlternativeNamesKey());
            Set set4 = map2 != null ? map2.keySet() : null;
            if (set4 == null) {
                set4 = SetsKt.emptySet();
            }
            set2 = SetsKt.plus(set3, (Iterable)set4);
        }
        Set names2 = set2;
        for (String key2 : this.getValue().keySet()) {
            if (names2.contains(key2) || Intrinsics.areEqual((Object)key2, (Object)this.polyDiscriminator)) continue;
            throw JsonExceptionsKt.UnknownKeyException(key2, this.getValue().toString());
        }
    }
}

