/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.server;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.server.ChestLootPoolBuilder;
import fzzyhmstrs.emi_loot.server.LootSender;
import fzzyhmstrs.emi_loot.server.MobLootPoolBuilder;
import fzzyhmstrs.emi_loot.util.TextKey;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1799;
import net.minecraft.class_2359;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class MobLootTableSender
implements LootSender<MobLootPoolBuilder> {
    private final String idToSend;
    private final String mobIdToSend;
    final List<MobLootPoolBuilder> builderList = new LinkedList<MobLootPoolBuilder>();
    public static class_2960 MOB_SENDER = new class_2960("e_l", "m_s");
    boolean isEmpty = true;

    public MobLootTableSender(class_2960 id, class_2960 mobId) {
        this.idToSend = LootSender.getIdToSend(id);
        this.mobIdToSend = LootSender.getIdToSend(mobId);
    }

    @Override
    public void build() {
        this.builderList.forEach(builder -> {
            builder.build();
            if (!builder.isEmpty) {
                this.isEmpty = false;
            }
        });
    }

    @Override
    public String getId() {
        return this.idToSend;
    }

    @Override
    public void send(class_3222 player) {
        if (this.isEmpty) {
            if (EMILoot.DEBUG) {
                EMILoot.LOGGER.info("avoiding empty mob: " + this.idToSend);
            }
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(this.idToSend);
        buf.method_10814(this.mobIdToSend);
        if (this.builderList.size() == 1 && this.builderList.get((int)0).isSimple) {
            if (EMILoot.DEBUG) {
                EMILoot.LOGGER.info("sending simple mob: " + this.idToSend);
            }
            buf.writeShort(-1);
            buf.method_42065((class_2359)class_7923.field_41178, (Object)this.builderList.get((int)0).simpleStack.method_7909());
            ServerPlayNetworking.send((class_3222)player, (class_2960)MOB_SENDER, (class_2540)buf);
            return;
        }
        if (this.builderList.isEmpty()) {
            if (EMILoot.DEBUG) {
                EMILoot.LOGGER.info("avoiding empty mob: " + this.idToSend);
            }
            return;
        }
        buf.writeShort(this.builderList.size());
        this.builderList.forEach(builder -> {
            builder.build();
            buf.writeShort(builder.conditions.size());
            builder.conditions.forEach(lootConditionResult -> lootConditionResult.text().toBuf(buf));
            buf.writeShort(builder.functions.size());
            builder.functions.forEach(lootFunctionResult -> lootFunctionResult.text().toBuf(buf));
            HashMap<List<TextKey>, ChestLootPoolBuilder> lootPoolBuilderMap = builder.builtMap;
            buf.writeShort(lootPoolBuilderMap.size());
            lootPoolBuilderMap.forEach((key, chestBuilder) -> {
                buf.writeShort(key.size());
                key.forEach(textKey -> textKey.toBuf(buf));
                Object2FloatMap<class_1799> keyPoolMap = lootPoolBuilderMap.getOrDefault((Object)key, new ChestLootPoolBuilder((float)1.0f)).builtMap;
                buf.writeShort(keyPoolMap.size());
                keyPoolMap.forEach((stack, weight) -> {
                    buf.method_10793(stack);
                    buf.writeFloat(weight.floatValue());
                });
            });
        });
        ServerPlayNetworking.send((class_3222)player, (class_2960)MOB_SENDER, (class_2540)buf);
    }

    @Override
    public void addBuilder(MobLootPoolBuilder builder) {
        this.builderList.add(builder);
    }

    @Override
    public List<MobLootPoolBuilder> getBuilders() {
        return this.builderList;
    }
}

