/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.compat.emi;

import com.tiviacz.travelersbackpack.client.screen.TravelersBackpackHandledScreen;
import com.tiviacz.travelersbackpack.init.ModScreenHandlerTypes;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.screen.TravelersBackpackBaseScreenHandler;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.widget.Bounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1735;
import org.jetbrains.annotations.Nullable;

public class EmiCompat
implements EmiPlugin {
    public void register(EmiRegistry registry) {
        registry.addExclusionArea(TravelersBackpackHandledScreen.class, (screen, consumer) -> {
            if (screen.settingsWidget != null) {
                int[] s = screen.settingsWidget.getWidgetSizeAndPos();
                consumer.accept(new Bounds(s[0], s[1], s[2], s[3]));
            }
            if (screen.sortWidget != null && screen.sortWidget.isVisible()) {
                int[] sort = screen.sortWidget.getWidgetSizeAndPos();
                consumer.accept(new Bounds(sort[0], sort[1], sort[2], sort[3]));
            }
            if (screen.memoryWidget != null && screen.memoryWidget.isVisible()) {
                int[] memory = screen.memoryWidget.getWidgetSizeAndPos();
                consumer.accept(new Bounds(memory[0], memory[1], memory[2], memory[3]));
            }
            if (screen.craftingWidget != null && screen.craftingWidget.isVisible()) {
                int[] crafting = screen.craftingWidget.getWidgetSizeAndPos();
                consumer.accept(new Bounds(crafting[0], crafting[1], crafting[2], crafting[3]));
            }
        });
        registry.addRecipeHandler(ModScreenHandlerTypes.TRAVELERS_BACKPACK_BLOCK_ENTITY, new GridMenuInfo());
        registry.addRecipeHandler(ModScreenHandlerTypes.TRAVELERS_BACKPACK_ITEM, new GridMenuInfo());
    }

    private static class GridMenuInfo<T extends TravelersBackpackBaseScreenHandler>
    implements StandardRecipeHandler<T> {
        private GridMenuInfo() {
        }

        @Nullable
        public class_1735 getOutputSlot(T handler) {
            return handler.method_7611(0);
        }

        public List<class_1735> getInputSources(T handler) {
            int i;
            ArrayList<class_1735> slots = new ArrayList<class_1735>();
            Tiers.Tier tier = ((TravelersBackpackBaseScreenHandler)((Object)handler)).inventory.getTier();
            for (i = 1; i < tier.getStorageSlotsWithCrafting() + 1; ++i) {
                slots.add(handler.method_7611(i));
            }
            for (i = tier.getAllSlots() + 14; i < tier.getAllSlots() + 14 + 36; ++i) {
                slots.add(handler.method_7611(i));
            }
            return slots;
        }

        public List<class_1735> getCraftingSlots(T handler) {
            ArrayList<class_1735> slots = new ArrayList<class_1735>();
            int firstCraftSlot = ((TravelersBackpackBaseScreenHandler)((Object)handler)).inventory.getTier().getStorageSlots() - Tiers.LEATHER.getStorageSlots() + 7;
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    slots.add(handler.method_7611(firstCraftSlot + j + i * 9));
                }
            }
            return slots;
        }

        public boolean supportsRecipe(EmiRecipe recipe) {
            return VanillaEmiRecipeCategories.CRAFTING.equals(recipe.getCategory()) && recipe.supportsRecipeTree();
        }
    }
}

