/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.schedule.WaypointDestinationInstruction;
import com.railwayteam.railways.content.switches.TrackSwitch;
import com.railwayteam.railways.content.switches.TrackSwitchBlock;
import com.railwayteam.railways.mixin.AccessorCarriageBogey;
import com.railwayteam.railways.mixin.AccessorTrain;
import com.railwayteam.railways.mixin_interfaces.IGenerallySearchableNavigation;
import com.railwayteam.railways.mixin_interfaces.ILimitedGlobalStation;
import com.railwayteam.railways.mixin_interfaces.IWaypointableNavigation;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Navigation;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.content.trains.graph.EdgeData;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.schedule.ScheduleEntry;
import com.simibubi.create.content.trains.signal.SignalBoundary;
import com.simibubi.create.content.trains.signal.SignalEdgeGroup;
import com.simibubi.create.content.trains.signal.TrackEdgePoint;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.UUID;
import net.minecraft.class_3532;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Navigation.class}, remap=false)
public abstract class MixinNavigation
implements IWaypointableNavigation,
IGenerallySearchableNavigation {
    @Shadow
    public Train train;
    @Shadow
    public int ticksWaitingForSignal;

    @Override
    public boolean isWaypointMode() {
        try {
            return !this.train.manualTick && !this.train.runtime.paused && !this.train.runtime.completed && this.train.runtime.getSchedule() != null && this.train.runtime.currentEntry < this.train.runtime.getSchedule().entries.size() && ((ScheduleEntry)this.train.runtime.getSchedule().entries.get((int)this.train.runtime.currentEntry)).instruction instanceof WaypointDestinationInstruction;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Redirect(method={"tick"}, at=@At(value="FIELD", opcode=180, target="Lcom/simibubi/create/content/trains/entity/Navigation;distanceToDestination:D"))
    private double fixWaypointDistanceInTick(Navigation instance) {
        if (((IWaypointableNavigation)instance).isWaypointMode()) {
            return 1000.0;
        }
        return instance.distanceToDestination;
    }

    @Redirect(method={"lambda$tick$0"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/station/GlobalStation;canApproachFrom(Lcom/simibubi/create/content/trains/graph/TrackNode;)Z"))
    private boolean keepScoutingAtWaypoints(GlobalStation instance, TrackNode side) {
        return instance.canApproachFrom(side) && !this.isWaypointMode();
    }

    @Redirect(method={"tick"}, at=@At(value="FIELD", opcode=180, target="Lcom/simibubi/create/content/trains/entity/Navigation;waitingForSignal:Lcom/simibubi/create/foundation/utility/Pair;"), slice=@Slice(from=@At(value="CONSTANT", args={"doubleValue=0.25d"}), to=@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/entity/Train;leaveStation()V")))
    private Pair<UUID, Boolean> brakeProperlyAtWaypoints(Navigation instance) {
        return this.isWaypointMode() ? null : instance.waitingForSignal;
    }

    @Redirect(method={"currentSignalResolved"}, at=@At(value="FIELD", opcode=180, target="Lcom/simibubi/create/content/trains/entity/Navigation;distanceToDestination:D"), slice=@Slice(to=@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/graph/TrackGraph;getPoint(Lcom/simibubi/create/content/trains/graph/EdgePointType;Ljava/util/UUID;)Lcom/simibubi/create/content/trains/signal/TrackEdgePoint;")))
    private double preventSignalClearWithWaypoint(Navigation instance) {
        if (((IWaypointableNavigation)instance).isWaypointMode()) {
            return 10.0;
        }
        return instance.distanceToDestination;
    }

    @Redirect(method={"search(DDZLcom/simibubi/create/content/trains/entity/Navigation$StationTest;)V"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/station/GlobalStation;getPresentTrain()Lcom/simibubi/create/content/trains/entity/Train;"))
    private Train replacePresentTrain(GlobalStation instance) {
        return ((ILimitedGlobalStation)instance).orDisablingTrain(instance.getPresentTrain(), this.train);
    }

    @ModifyExpressionValue(method={"search(DDZLcom/simibubi/create/content/trains/entity/Navigation$StationTest;)V"}, at={@At(value="INVOKE", target="Ljava/util/Set;contains(Ljava/lang/Object;)Z")})
    private boolean isNavigationIncompatible(boolean original, @Local Map.Entry<TrackNode, TrackEdge> target) {
        if (target.getValue().getTrackMaterial().trackType == CRTrackMaterials.CRTrackType.UNIVERSAL) {
            return true;
        }
        return original;
    }

    @Override
    public void snr$searchGeneral(double maxDistance, boolean forward, IGenerallySearchableNavigation.PointTest pointTest) {
        this.snr$searchGeneral(maxDistance, -1.0, forward, pointTest);
    }

    @Override
    public void snr$searchGeneral(double maxDistance, double maxCost, boolean forward, IGenerallySearchableNavigation.PointTest pointTest) {
        boolean costRelevant;
        TrackGraph graph = this.train.graph;
        if (graph == null) {
            return;
        }
        boolean skipValidCheck = false;
        HashSet validTypes = new HashSet();
        for (int i = 0; i < this.train.carriages.size(); ++i) {
            Carriage carriage = (Carriage)this.train.carriages.get(i);
            AbstractBogeyBlock<?> leadingType = ((AccessorCarriageBogey)carriage.leadingBogey()).getType();
            AbstractBogeyBlock<?> trailingType = ((AccessorCarriageBogey)carriage.trailingBogey()).getType();
            if (leadingType.getTrackType(carriage.leadingBogey().getStyle()) == CRTrackMaterials.CRTrackType.UNIVERSAL) {
                if (i == 0) {
                    skipValidCheck = true;
                }
            } else {
                if (i == 0 || skipValidCheck) {
                    validTypes.addAll(leadingType.getValidPathfindingTypes(carriage.leadingBogey().getStyle()));
                } else {
                    validTypes.retainAll(leadingType.getValidPathfindingTypes(carriage.leadingBogey().getStyle()));
                }
                skipValidCheck = false;
            }
            if (!carriage.isOnTwoBogeys() || trailingType.getTrackType(carriage.trailingBogey().getStyle()) == CRTrackMaterials.CRTrackType.UNIVERSAL) continue;
            if (skipValidCheck) {
                validTypes.addAll(trailingType.getValidPathfindingTypes(carriage.trailingBogey().getStyle()));
            } else {
                validTypes.retainAll(trailingType.getValidPathfindingTypes(carriage.trailingBogey().getStyle()));
            }
            skipValidCheck = false;
        }
        if (validTypes.isEmpty() && !skipValidCheck) {
            return;
        }
        IdentityHashMap penalties = new IdentityHashMap();
        boolean bl = costRelevant = maxCost >= 0.0;
        if (costRelevant) {
            for (Train otherTrain : Create.RAILWAYS.trains.values()) {
                if (otherTrain.graph != graph || otherTrain == this.train) continue;
                int navigationPenalty = otherTrain.getNavigationPenalty();
                otherTrain.getEndpointEdges().forEach(nodes -> {
                    if (nodes.either(Objects::isNull)) {
                        return;
                    }
                    for (boolean flip : Iterate.trueAndFalse) {
                        TrackEdge e = graph.getConnection(flip ? nodes.swap() : nodes);
                        if (e == null) continue;
                        int existing = penalties.getOrDefault(e, 0);
                        penalties.put(e, existing + navigationPenalty / 2);
                    }
                });
            }
        }
        TravellingPoint startingPoint = forward ? ((Carriage)this.train.carriages.get(0)).getLeadingPoint() : ((Carriage)this.train.carriages.get(this.train.carriages.size() - 1)).getTrailingPoint();
        HashSet<TrackEdge> visited = new HashSet<TrackEdge>();
        IdentityHashMap<TrackEdge, Pair<Boolean, Couple<TrackNode>>> reachedVia = new IdentityHashMap<TrackEdge, Pair<Boolean, Couple<TrackNode>>>();
        PriorityQueue<IGenerallySearchableNavigation.FrontierEntry> frontier = new PriorityQueue<IGenerallySearchableNavigation.FrontierEntry>();
        TrackNode initialNode1 = forward ? startingPoint.node1 : startingPoint.node2;
        TrackNode initialNode2 = forward ? startingPoint.node2 : startingPoint.node1;
        TrackEdge initialEdge = (TrackEdge)graph.getConnectionsFrom(initialNode1).get(initialNode2);
        if (initialEdge == null) {
            return;
        }
        double distanceToNode2 = forward ? initialEdge.getLength() - startingPoint.position : startingPoint.position;
        frontier.add(new IGenerallySearchableNavigation.FrontierEntry(distanceToNode2, 0, initialNode1, initialNode2, initialEdge));
        int signalWeight = class_3532.method_15340((int)(this.ticksWaitingForSignal * 2), (int)AccessorTrain.AccessorPenalties.getRED_SIGNAL(), (int)200);
        block2: while (!frontier.isEmpty()) {
            TrackNode newNode;
            EdgeData signalData;
            IGenerallySearchableNavigation.FrontierEntry entry = (IGenerallySearchableNavigation.FrontierEntry)frontier.poll();
            if (!visited.add(entry.edge)) continue;
            double distance = entry.distance;
            int penalty = entry.penalty;
            if (distance > maxDistance) continue;
            TrackEdge edge = entry.edge;
            TrackNode node1 = entry.node1;
            TrackNode node2 = entry.node2;
            if (costRelevant) {
                penalty += penalties.getOrDefault(edge, 0).intValue();
            }
            if ((signalData = edge.getEdgeData()).hasPoints()) {
                for (TrackEdgePoint point : signalData.getPoints()) {
                    if (node1 == initialNode1 && point.getLocationOn(edge) < edge.getLength() - distanceToNode2) continue;
                    if (costRelevant && distance + (double)penalty > maxCost || !point.canNavigateVia(node2)) continue block2;
                    if (point instanceof SignalBoundary) {
                        SignalEdgeGroup signalEdgeGroup;
                        SignalBoundary signal = (SignalBoundary)point;
                        if (signal.isForcedRed(node2)) {
                            penalty += AccessorTrain.AccessorPenalties.getREDSTONE_RED_SIGNAL();
                            continue;
                        }
                        UUID group = signal.getGroup(node2);
                        if (group == null || (signalEdgeGroup = (SignalEdgeGroup)Create.RAILWAYS.signalEdgeGroups.get(group)) == null) continue;
                        if (signalEdgeGroup.isOccupiedUnless(signal)) {
                            penalty += signalWeight;
                            signalWeight /= 2;
                        }
                    }
                    if (point instanceof GlobalStation) {
                        boolean isOwnStation;
                        GlobalStation station = (GlobalStation)point;
                        Train presentTrain = station.getPresentTrain();
                        boolean bl2 = isOwnStation = presentTrain == this.train;
                        if (presentTrain != null && !isOwnStation) {
                            penalty += AccessorTrain.AccessorPenalties.getSTATION_WITH_TRAIN();
                        }
                        if (station.canApproachFrom(node2) && pointTest.test(distance, distance + (double)penalty, reachedVia, (Pair<Couple<TrackNode>, TrackEdge>)Pair.of((Object)Couple.create((Object)node1, (Object)node2), (Object)edge), (TrackEdgePoint)station)) {
                            return;
                        }
                        if (!isOwnStation) {
                            penalty += AccessorTrain.AccessorPenalties.getSTATION();
                        }
                    }
                    if (!pointTest.test(distance, distance + (double)penalty, reachedVia, (Pair<Couple<TrackNode>, TrackEdge>)Pair.of((Object)Couple.create((Object)node1, (Object)node2), (Object)edge), point)) continue;
                    return;
                }
            }
            if (costRelevant && distance + (double)penalty > maxCost) continue;
            ArrayList validTargets = new ArrayList();
            Map connectionsFrom = graph.getConnectionsFrom(node2);
            for (Map.Entry connection : connectionsFrom.entrySet()) {
                newNode = (TrackNode)connection.getKey();
                if (newNode == node1 || !edge.canTravelTo((TrackEdge)connection.getValue())) continue;
                validTargets.add(connection);
            }
            if (validTargets.isEmpty()) continue;
            for (Map.Entry target : validTargets) {
                if (!skipValidCheck && !validTypes.contains(((TrackEdge)target.getValue()).getTrackMaterial().trackType) && ((TrackEdge)target.getValue()).getTrackMaterial().trackType != CRTrackMaterials.CRTrackType.UNIVERSAL) continue;
                newNode = (TrackNode)target.getKey();
                TrackEdge newEdge = (TrackEdge)target.getValue();
                double newDistance = newEdge.getLength() + distance;
                int newPenalty = penalty;
                reachedVia.putIfAbsent(newEdge, (Pair<Boolean, Couple<TrackNode>>)Pair.of((Object)(validTargets.size() > 1 ? 1 : 0), (Object)Couple.create((Object)node1, (Object)node2)));
                frontier.add(new IGenerallySearchableNavigation.FrontierEntry(newDistance, newPenalty, node2, newNode, newEdge));
            }
        }
    }

    @Override
    public Pair<TrackSwitch, Pair<Boolean, Optional<TrackSwitchBlock.SwitchState>>> snr$findNearestApproachableSwitch(boolean forward) {
        TrackGraph graph = this.train.graph;
        if (graph == null) {
            return null;
        }
        MutableObject result = new MutableObject(null);
        MutableObject headOn = new MutableObject((Object)false);
        MutableObject targetState = new MutableObject(null);
        double acceleration = this.train.acceleration();
        double minDistance = 0.0;
        double maxDistance = Math.max(32.0, 1.5 * (this.train.speed * this.train.speed) / (2.0 * acceleration));
        this.snr$searchGeneral(maxDistance, forward, (distance, cost, reachedVia, currentEntry, trackPoint) -> {
            if (distance < minDistance) {
                return false;
            }
            TrackEdge edge = (TrackEdge)currentEntry.getSecond();
            double position = edge.getLength() - trackPoint.getLocationOn(edge);
            if (distance - position < minDistance) {
                return false;
            }
            if (trackPoint instanceof TrackSwitch) {
                TrackSwitch sw = (TrackSwitch)trackPoint;
                TrackNode node = (TrackNode)((Couple)currentEntry.getFirst()).getSecond();
                headOn.setValue((Object)sw.isPrimary(node));
                result.setValue((Object)sw);
                if (!((Boolean)headOn.getValue()).booleanValue()) {
                    for (TrackEdge reachedEdge : reachedVia.keySet()) {
                        TrackSwitchBlock.SwitchState state = sw.getTargetState(reachedEdge.node1.getLocation());
                        if (state == null) {
                            state = sw.getTargetState(reachedEdge.node2.getLocation());
                        }
                        targetState.setValue((Object)state);
                        if (state == null) continue;
                        break;
                    }
                }
                return true;
            }
            return false;
        });
        return Pair.of((Object)((Object)((TrackSwitch)((Object)result.getValue()))), (Object)Pair.of((Object)((Boolean)headOn.getValue()), Optional.ofNullable((TrackSwitchBlock.SwitchState)((Object)targetState.getValue()))));
    }

    @Inject(method={"search(DDZLcom/simibubi/create/content/trains/entity/Navigation$StationTest;)V"}, at={@At(value="HEAD")})
    private void recordSearch(double maxDistance, double maxCost, boolean forward, Navigation.StationTest stationTest, CallbackInfo ci) {
        ++Railways.navigationCallDepth;
    }

    @Inject(method={"search(DDZLcom/simibubi/create/content/trains/entity/Navigation$StationTest;)V"}, at={@At(value="RETURN")})
    private void recordSearchReturn(double maxDistance, double maxCost, boolean forward, Navigation.StationTest stationTest, CallbackInfo ci) {
        if (Railways.navigationCallDepth > 0) {
            --Railways.navigationCallDepth;
        }
    }
}

