/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable.belt;

import artifacts.component.SwimData;
import artifacts.item.wearable.WearableArtifactItem;
import artifacts.item.wearable.necklace.CharmOfSinkingItem;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModGameRules;
import artifacts.registry.ModItems;
import artifacts.registry.ModKeyMappings;
import artifacts.registry.ModSoundEvents;
import dev.architectury.event.events.common.TickEvent;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3414;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class HeliumFlamingoItem
extends WearableArtifactItem {
    public HeliumFlamingoItem() {
        TickEvent.PLAYER_PRE.register(this::onHeliumFlamingoTick);
    }

    @Override
    protected boolean isCosmetic() {
        return ModGameRules.HELIUM_FLAMINGO_FLIGHT_DURATION.get() <= 0;
    }

    @Override
    protected void addEffectsTooltip(class_1799 stack, List<class_5250> tooltip) {
        tooltip.add(this.tooltipLine("swimming", new Object[0]));
        tooltip.add(this.tooltipLine("keymapping", ModKeyMappings.getHeliumFlamingoKey().method_16007()));
    }

    @Override
    @NotNull
    public class_3414 getEquipSound() {
        return ModSoundEvents.POP.get();
    }

    private void onHeliumFlamingoTick(class_1657 player) {
        SwimData swimData = PlatformServices.platformHelper.getSwimData((class_1309)player);
        if (swimData == null) {
            return;
        }
        int maxFlightTime = Math.max(1, ModGameRules.HELIUM_FLAMINGO_FLIGHT_DURATION.get() * 20);
        int rechargeTime = Math.max(20, ModGameRules.HELIUM_FLAMINGO_RECHARGE_DURATION.get() * 20);
        if (swimData.isSwimming()) {
            if (!ModItems.HELIUM_FLAMINGO.get().isEquippedBy((class_1309)player) || swimData.getSwimTime() > maxFlightTime || player.method_5799() && !player.method_5681() && !CharmOfSinkingItem.shouldSink((class_1309)player) || (!player.method_5799() || CharmOfSinkingItem.shouldSink((class_1309)player)) && player.method_24828()) {
                swimData.setSwimming(false);
                if (!player.method_24828() && !player.method_5799()) {
                    player.method_5783(ModSoundEvents.POP.get(), 0.5f, 0.75f);
                }
            }
            if (ModItems.HELIUM_FLAMINGO.get().isEquippedBy((class_1309)player) && !PlatformServices.platformHelper.isEyeInWater(player) && !player.method_31549().field_7480) {
                swimData.setSwimTime(swimData.getSwimTime() + 1);
            }
        } else if (swimData.getSwimTime() < 0) {
            swimData.setSwimTime(swimData.getSwimTime() < -rechargeTime ? -rechargeTime : swimData.getSwimTime() + 1);
        }
    }
}

