/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.portable_energy_interface;

import com.mrh0.createaddition.blocks.portable_energy_interface.PortableEnergyManager;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.transfer.EnergyTransferable;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.actors.psi.PortableStorageInterfaceBlockEntity;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.SimpleEnergyStorage;

public class PortableEnergyInterfaceTileEntity
extends PortableStorageInterfaceBlockEntity
implements EnergyTransferable {
    protected InterfaceEnergyHandler capability = this.createEmptyHandler();

    public PortableEnergyInterfaceTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void startTransferringTo(Contraption contraption, float distance) {
        this.capability.setWrapped(new InterfaceEnergyHandler(PortableEnergyManager.get(contraption)));
        super.startTransferringTo(contraption, distance);
    }

    protected void stopTransferring() {
        this.capability.setWrapped(EnergyStorage.EMPTY);
        super.stopTransferring();
    }

    protected void invalidateCapability() {
        this.capability.setWrapped(EnergyStorage.EMPTY);
    }

    private InterfaceEnergyHandler createEmptyHandler() {
        return new InterfaceEnergyHandler((EnergyStorage)new SimpleEnergyStorage(0L, 0L, 0L));
    }

    @Override
    public EnergyStorage getEnergyStorage(class_2350 side) {
        return this.capability;
    }

    public boolean isConnected() {
        int timeUnit = this.getTransferTimeout();
        return this.transferTimer >= 4 && this.transferTimer <= timeUnit + 4;
    }

    protected float getExtensionDistance(float partialTicks) {
        return (float)(Math.pow(this.connectionAnimation.getValue(partialTicks), 2.0) * (double)this.distance / 2.0);
    }

    protected float getConnectionDistance() {
        return this.distance;
    }

    protected class_1297 getConnectedEntity() {
        return this.connectedEntity;
    }

    protected int getTransferTimer() {
        return this.transferTimer;
    }

    public long getEnergy() {
        return this.capability != null ? this.capability.getAmount() : -1L;
    }

    public long getCapacity() {
        return this.capability != null ? this.capability.getCapacity() : -1L;
    }

    public class InterfaceEnergyHandler
    implements EnergyStorage {
        private EnergyStorage wrapped;

        public InterfaceEnergyHandler(EnergyStorage wrapped) {
            this.wrapped = wrapped;
        }

        public long insert(long maxReceive, TransactionContext transaction) {
            if (!PortableEnergyInterfaceTileEntity.this.canTransfer()) {
                return 0L;
            }
            maxReceive = Math.min(maxReceive, (Long)Config.PEI_MAX_INPUT.get());
            if (this.wrapped == null) {
                return 0L;
            }
            long received = this.wrapped.insert(maxReceive, transaction);
            if (received != 0L) {
                TransactionCallback.onSuccess((TransactionContext)transaction, this::keepAlive);
            }
            return received;
        }

        public long extract(long maxExtract, TransactionContext transaction) {
            if (!PortableEnergyInterfaceTileEntity.this.canTransfer()) {
                return 0L;
            }
            maxExtract = Math.min(maxExtract, (Long)Config.PEI_MAX_OUTPUT.get());
            if (this.wrapped == null) {
                return 0L;
            }
            long extracted = this.wrapped.extract(maxExtract, transaction);
            if (extracted != 0L) {
                TransactionCallback.onSuccess((TransactionContext)transaction, this::keepAlive);
            }
            return extracted;
        }

        public long getAmount() {
            if (this.wrapped == null) {
                return 0L;
            }
            return this.wrapped.getAmount();
        }

        public long getCapacity() {
            if (this.wrapped == null) {
                return 0L;
            }
            return this.wrapped.getCapacity();
        }

        public boolean supportsExtraction() {
            return true;
        }

        public boolean supportsInsertion() {
            return true;
        }

        public void keepAlive() {
            PortableEnergyInterfaceTileEntity.this.onContentTransferred();
        }

        private void setWrapped(EnergyStorage wrapped) {
            this.wrapped = wrapped;
        }
    }
}

