/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.tesla_coil;

import com.mrh0.createaddition.blocks.tesla_coil.TeslaCoilBeltCallbacks;
import com.mrh0.createaddition.blocks.tesla_coil.TeslaCoilBlock;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.energy.BaseElectricTileEntity;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.index.CADamageTypes;
import com.mrh0.createaddition.index.CAEffects;
import com.mrh0.createaddition.recipe.charging.ChargingRecipe;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.RecipeWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import team.reborn.energy.api.EnergyStorage;

public class TeslaCoilTileEntity
extends BaseElectricTileEntity
implements IHaveGoggleInformation {
    private Optional<ChargingRecipe> recipeCache;
    private final ItemStackHandler inputInv = new ItemStackHandler(1);
    private int chargeAccumulator;
    protected class_1799 chargedStackCache;
    protected int poweredTimer = 0;
    public BeltProcessingBehaviour processingBehaviour;
    int dmgTick = 0;
    int soundTimeout = 0;

    public TeslaCoilTileEntity(class_2591<?> tileEntityTypeIn, class_2338 pos, class_2680 state) {
        super(tileEntityTypeIn, pos, state, Util.max((Long)Config.TESLA_COIL_CAPACITY.get(), (Long)Config.TESLA_COIL_CHARGE_RATE.get(), (Long)Config.TESLA_COIL_RECIPE_CHARGE_RATE.get()), (Long)Config.TESLA_COIL_MAX_INPUT.get(), 0L);
        this.recipeCache = Optional.empty();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.processingBehaviour = new BeltProcessingBehaviour((SmartBlockEntity)this).whenItemEnters((s, i) -> TeslaCoilBeltCallbacks.onItemReceived(s, i, this)).whileItemHeld((s, i) -> TeslaCoilBeltCallbacks.whenItemHeld(s, i, this));
        behaviours.add((BlockEntityBehaviour)this.processingBehaviour);
    }

    @Override
    public boolean isEnergyInput(class_2350 side) {
        return side != ((class_2350)this.method_11010().method_11654((class_2769)TeslaCoilBlock.FACING)).method_10153();
    }

    @Override
    public boolean isEnergyOutput(class_2350 side) {
        return false;
    }

    public long getConsumption() {
        return (Long)Config.TESLA_COIL_CHARGE_RATE.get();
    }

    protected float getItemCharge(EnergyStorage energy) {
        if (energy == null) {
            return 0.0f;
        }
        return (float)energy.getAmount() / (float)energy.getCapacity();
    }

    protected BeltProcessingBehaviour.ProcessingResult onCharge(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        BeltProcessingBehaviour.ProcessingResult res = this.chargeCompundAndStack(transported, handler);
        return res;
    }

    private void doDmg() {
        this.localEnergy.internalConsumeEnergy((Long)Config.TESLA_COIL_HURT_ENERGY_REQUIRED.get());
        class_2338 origin = this.method_11016().method_10093(((class_2350)this.method_11010().method_11654((class_2769)TeslaCoilBlock.FACING)).method_10153());
        List ents = Objects.requireNonNull(this.method_10997()).method_18467(class_1309.class, new class_238(origin).method_1014((double)((Integer)Config.TESLA_COIL_HURT_RANGE.get()).intValue()));
        for (class_1309 e : ents) {
            if (e == null) {
                return;
            }
            int dmg = (Integer)Config.TESLA_COIL_HURT_DMG_MOB.get();
            int time = (Integer)Config.TESLA_COIL_HURT_EFFECT_TIME_MOB.get();
            if (e instanceof class_1657) {
                dmg = (Integer)Config.TESLA_COIL_HURT_DMG_PLAYER.get();
                time = (Integer)Config.TESLA_COIL_HURT_EFFECT_TIME_PLAYER.get();
            }
            if (dmg > 0) {
                e.method_5643(CADamageTypes.TESLA_COIL.source((class_1936)this.field_11863), (float)dmg);
            }
            if (time <= 0) continue;
            e.method_6092(new class_1293((class_1291)CAEffects.SHOCKING.get(), time));
        }
    }

    @Override
    public void tick() {
        super.tick();
        assert (this.field_11863 != null);
        if (this.field_11863 != null && this.field_11863.method_8608()) {
            if (this.isPoweredState() && this.soundTimeout++ > 20) {
                this.soundTimeout = 0;
            }
            return;
        }
        int signal = Objects.requireNonNull(this.method_10997()).method_49804(this.method_11016());
        if (signal > 0 && this.localEnergy.getAmount() >= (Long)Config.TESLA_COIL_HURT_ENERGY_REQUIRED.get()) {
            this.poweredTimer = 10;
        }
        ++this.dmgTick;
        if ((this.dmgTick %= ((Integer)Config.TESLA_COIL_HURT_FIRE_COOLDOWN.get()).intValue()) == 0 && this.localEnergy.getAmount() >= (Long)Config.TESLA_COIL_HURT_ENERGY_REQUIRED.get() && signal > 0) {
            this.doDmg();
        }
        if (this.poweredTimer > 0) {
            if (!this.isPoweredState()) {
                ((TeslaCoilBlock)((Object)CABlocks.TESLA_COIL.get())).setPowered(this.field_11863, this.method_11016(), true);
            }
            --this.poweredTimer;
        } else if (this.isPoweredState()) {
            ((TeslaCoilBlock)((Object)CABlocks.TESLA_COIL.get())).setPowered(this.field_11863, this.method_11016(), false);
        }
    }

    public boolean isPoweredState() {
        return (Boolean)this.method_11010().method_11654((class_2769)TeslaCoilBlock.POWERED);
    }

    protected BeltProcessingBehaviour.ProcessingResult chargeCompundAndStack(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        class_1799 stack = transported.stack;
        if (stack == null) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (this.chargeStack(stack, transported, handler)) {
            this.poweredTimer = 10;
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (this.chargeRecipe(stack, transported, handler)) {
            this.poweredTimer = 10;
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        return BeltProcessingBehaviour.ProcessingResult.PASS;
    }

    protected final boolean chargeStack(class_1799 stack, TransportedItemStack ignoredTransported, TransportedItemStackHandlerBehaviour ignoredHandler) {
        ContainerItemContext context = ContainerItemContext.withConstant((class_1799)stack);
        EnergyStorage es = (EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)context);
        if (es == null) {
            return false;
        }
        try (Transaction t = TransferUtil.getTransaction();){
            if (es.insert(1L, (TransactionContext)t) != 1L) {
                boolean bl = false;
                return bl;
            }
        }
        if (this.localEnergy.getAmount() < (long)stack.method_7947()) {
            return false;
        }
        t = TransferUtil.getTransaction();
        try {
            this.localEnergy.internalConsumeEnergy(es.insert(Math.min(this.getConsumption(), this.localEnergy.getAmount()), (TransactionContext)t));
            t.commit();
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
        stack.method_7980(context.getItemVariant().copyNbt());
        return true;
    }

    private boolean chargeRecipe(class_1799 stack, TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        if (!this.inputInv.getStackInSlot(0).method_31574(stack.method_7909())) {
            this.inputInv.setStackInSlot(0, stack);
            this.recipeCache = this.find(new RecipeWrapper(this.inputInv), Objects.requireNonNull(this.method_10997()));
            this.chargeAccumulator = 0;
        }
        if (this.recipeCache.isPresent()) {
            ChargingRecipe recipe = this.recipeCache.get();
            long energyRemoved = this.localEnergy.internalConsumeEnergy(Math.min((Long)Config.TESLA_COIL_RECIPE_CHARGE_RATE.get(), (long)(recipe.getEnergy() - this.chargeAccumulator)));
            this.chargeAccumulator = (int)((long)this.chargeAccumulator + energyRemoved);
            if (this.chargeAccumulator >= recipe.getEnergy()) {
                TransportedItemStack remainingStack = transported.copy();
                TransportedItemStack result = transported.copy();
                result.stack = recipe.method_8110(null).method_7972();
                remainingStack.stack.method_7934(1);
                ArrayList<TransportedItemStack> outList = new ArrayList<TransportedItemStack>();
                outList.add(result);
                handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld(outList, (TransportedItemStack)remainingStack));
                this.chargeAccumulator = 0;
            }
            return true;
        }
        return false;
    }

    public Optional<ChargingRecipe> find(RecipeWrapper wrapper, class_1937 world) {
        return world.method_8433().method_8132(ChargingRecipe.TYPE, (class_1263)wrapper, world);
    }
}

