/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.renderer;

import com.google.gson.JsonObject;
import dev.felnull.imp.client.music.media.NetEaseCloudMusicManager;
import dev.felnull.imp.client.music.media.NetEaseCloudMusicMedia;
import dev.felnull.imp.include.dev.felnull.fnjl.math.FNVec2d;
import dev.felnull.imp.include.dev.felnull.fnjl.util.FNMath;
import dev.felnull.imp.include.dev.felnull.fnjl.util.FNURLUtil;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.otyacraftengine.client.renderer.texture.TextureScale;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import dev.felnull.otyacraftengine.client.util.OETextureUtils;
import java.net.URL;
import java.util.regex.Pattern;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.apache.commons.lang3.tuple.Pair;

public class PlayImageRenderer {
    private static final class_2960 MISSING_YOUTUBE_THUMBNAIL_TEXTURE = new class_2960("iammusicplayer", "textures/gui/image/missing_youtube_thumbnail.png");
    private static final class_2960 MISSING_SOUND_CLOUD_THUMBNAIL_TEXTURE = new class_2960("iammusicplayer", "textures/gui/image/missing_sound_cloud_artwork.png");
    private static final PlayImageRenderer INSTANCE = new PlayImageRenderer();
    private static final String YOUTUBE_THUMBNAIL_URL = "https://i.ytimg.com/vi/%s/hqdefault.jpg";
    private static final Pattern YOUTUBE_THUMBNAIL_URL_REGEX = Pattern.compile("https://i.ytimg.com/vi/.+/hqdefault.jpg");
    private static final Pattern SOUND_CLOUD_URL_REGEX = Pattern.compile("https://soundcloud.com/.+");
    private static final Pattern NETEASE_CLOUD_MUSIC_URL_REGEX = Pattern.compile("https://p1.music.126.net/.+");
    private static final String SCT_IMG_ST = "<img ";
    private static final String SCT_IMG_END = ">";
    private static final String SCT_SRC_ST = "src=\"";
    private static final String SCT_SRC_END = "\"";

    public static PlayImageRenderer getInstance() {
        return INSTANCE;
    }

    public String getSwapURL(String url) {
        String curl;
        if (url.startsWith("imp_sct_")) {
            String scurl = url.substring("imp_sct_".length());
            if (SOUND_CLOUD_URL_REGEX.matcher(scurl).matches()) {
                String ret = null;
                try {
                    ret = PlayImageRenderer.extractSoundCloudImage(FNURLUtil.getResponse(new URL(scurl)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return ret;
            }
        } else if (url.startsWith("imp_ncmp_") && !(curl = url.substring("imp_ncmp_".length())).isEmpty()) {
            String ret = null;
            try {
                NetEaseCloudMusicManager necmm = NetEaseCloudMusicManager.getInstance();
                JsonObject sj = necmm.getSongJson(curl);
                ret = necmm.getPictureURL(sj);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ret;
        }
        return null;
    }

    public boolean isAllowURL(String url) {
        if (YOUTUBE_THUMBNAIL_URL_REGEX.matcher(url).matches()) {
            return true;
        }
        if (url.startsWith("imp_sct_")) {
            String scurl = url.substring("imp_sct_".length());
            return SOUND_CLOUD_URL_REGEX.matcher(scurl).matches();
        }
        if (url.startsWith("imp_ncmp_")) {
            String curl = url.substring("imp_ncmp_".length());
            return !curl.isEmpty();
        }
        return false;
    }

    public void draw(ImageInfo imageInfo, class_4587 poseStack, float x, float y, int size) {
        this.draw(imageInfo, poseStack, x, y, size, true);
    }

    public void draw(ImageInfo imageInfo, class_4587 poseStack, float x, float y, float size, boolean cash) {
        if (imageInfo.isEmpty()) {
            return;
        }
        if (imageInfo.getImageType() == ImageInfo.ImageType.PLAYER_FACE) {
            this.drawPlayerFaceImage(imageInfo.getIdentifier(), poseStack, x, y, size);
            return;
        }
        Pair<class_2960, class_241> td = this.getImageTexture(imageInfo, cash);
        if (td != null) {
            this.drawTextureImage((class_2960)td.getLeft(), poseStack, ((class_241)td.getRight()).field_1343, ((class_241)td.getRight()).field_1342, x, y, size);
        }
    }

    public void drawPlayerFaceImage(String name, class_4587 poseStack, float x, float y, float size) {
        class_2960 texture = OETextureUtils.getPlayerSkinTexture((String)name);
        OERenderUtils.drawTexture((class_2960)texture, (class_4587)poseStack, (float)x, (float)y, (float)size, (float)size, (float)size, (float)size, (float)(size * 8.0f), (float)(size * 8.0f));
        OERenderUtils.drawTexture((class_2960)texture, (class_4587)poseStack, (float)x, (float)y, (float)(size * 5.0f), (float)size, (float)size, (float)size, (float)(size * 8.0f), (float)(size * 8.0f));
    }

    private void drawTextureImage(class_2960 location, class_4587 poseStack, float wScale, float hScale, float x, float y, float size) {
        if (location == null) {
            return;
        }
        float w = size * wScale;
        float h = size * hScale;
        OERenderUtils.drawTexture((class_2960)location, (class_4587)poseStack, (float)(x + (size - w) / 2.0f), (float)(y + (size - h) / 2.0f), (float)0.0f, (float)0.0f, (float)w, (float)h, (float)w, (float)h);
    }

    public void renderSprite(ImageInfo imageInfo, class_4587 poseStack, class_4597 multiBufferSource, float x, float y, float z, float size, int i, int j) {
        this.renderSprite(imageInfo, poseStack, multiBufferSource, x, y, z, size, i, j, true);
    }

    public void renderSprite(ImageInfo imageInfo, class_4587 poseStack, class_4597 multiBufferSource, float x, float y, float z, float size, int i, int j, boolean cash) {
        if (imageInfo.isEmpty()) {
            return;
        }
        if (imageInfo.getImageType() == ImageInfo.ImageType.PLAYER_FACE) {
            this.renderPlayerFaceImageSprite(imageInfo.getIdentifier(), poseStack, multiBufferSource, x, y, z, size, i, j);
            return;
        }
        Pair<class_2960, class_241> td = this.getImageTexture(imageInfo, cash);
        if (td != null) {
            this.renderTextureImageSprite((class_2960)td.getLeft(), poseStack, multiBufferSource, ((class_241)td.getRight()).field_1343, ((class_241)td.getRight()).field_1342, x, y, z, size, i, j);
        }
    }

    private void renderPlayerFaceImageSprite(String name, class_4587 poseStack, class_4597 multiBufferSource, float x, float y, float z, float size, int i, int j) {
        poseStack.method_22903();
        poseStack.method_46416(x, y, z);
        OERenderUtils.renderPlayerFaceSprite((class_4587)poseStack, (class_4597)multiBufferSource, (String)name, (float)size, (int)i, (int)j);
        poseStack.method_22909();
    }

    private void renderTextureImageSprite(class_2960 location, class_4587 poseStack, class_4597 multiBufferSource, float wScale, float hScale, float x, float y, float z, float size, int i, int j) {
        if (location == null) {
            return;
        }
        float w = size * wScale;
        float h = size * hScale;
        OERenderUtils.renderTextureSprite((class_2960)location, (class_4587)poseStack, (class_4597)multiBufferSource, (float)(x + (size - w) / 2.0f), (float)(y + (size - h) / 2.0f), (float)z, (float)0.0f, (float)0.0f, (float)0.0f, (float)w, (float)h, (float)0.0f, (float)0.0f, (float)w, (float)h, (float)w, (float)h, (int)i, (int)j);
    }

    private Pair<class_2960, class_241> getImageTexture(ImageInfo imageInfo, boolean cash) {
        if (imageInfo.getImageType() == ImageInfo.ImageType.URL) {
            class_2960 loc = OETextureUtils.getAndLoadURLTextureAsync((String)imageInfo.getIdentifier(), (boolean)cash).of();
            TextureScale scale = OETextureUtils.getTextureScale((class_2960)loc);
            float w = 1.0f;
            float h = 1.0f;
            if (scale != null) {
                w = (float)scale.w();
                h = (float)scale.h();
            }
            return Pair.of((Object)loc, (Object)new class_241(w, h));
        }
        if (imageInfo.getImageType() == ImageInfo.ImageType.YOUTUBE_THUMBNAIL) {
            class_2960 loc = OETextureUtils.getAndLoadURLTextureAsync((String)String.format(YOUTUBE_THUMBNAIL_URL, imageInfo.getIdentifier()), (boolean)cash).of(MISSING_YOUTUBE_THUMBNAIL_TEXTURE);
            TextureScale scale = OETextureUtils.getTextureScale((class_2960)loc);
            float w = 1.0f;
            float h = 1.0f;
            if (loc == MISSING_YOUTUBE_THUMBNAIL_TEXTURE) {
                FNVec2d st = FNMath.scale(120.0, 90.0);
                w = (float)st.getX();
                h = (float)st.getY();
            } else if (scale != null) {
                w = (float)scale.w();
                h = (float)scale.h();
            }
            return Pair.of((Object)loc, (Object)new class_241(w, h));
        }
        if (imageInfo.getImageType() == ImageInfo.ImageType.SOUND_CLOUD_ARTWORK) {
            String idf = imageInfo.getIdentifier();
            class_2960 loc = OETextureUtils.getAndLoadURLTextureAsync((String)("imp_sct_" + idf), (boolean)cash).of(MISSING_SOUND_CLOUD_THUMBNAIL_TEXTURE);
            TextureScale scale = OETextureUtils.getTextureScale((class_2960)loc);
            float w = 1.0f;
            float h = 1.0f;
            if (loc == MISSING_SOUND_CLOUD_THUMBNAIL_TEXTURE) {
                FNVec2d st = FNMath.scale(1.0, 1.0);
                w = (float)st.getX();
                h = (float)st.getY();
            } else if (scale != null) {
                w = (float)scale.w();
                h = (float)scale.h();
            }
            return Pair.of((Object)loc, (Object)new class_241(w, h));
        }
        if (imageInfo.getImageType() == ImageInfo.ImageType.NETEASE_CLOUD_MUSIC_PICTURE) {
            String idf = imageInfo.getIdentifier();
            class_2960 loc = OETextureUtils.getAndLoadURLTextureAsync((String)("imp_ncmp_" + idf), (boolean)cash).of(NetEaseCloudMusicMedia.ICON);
            TextureScale scale = OETextureUtils.getTextureScale((class_2960)loc);
            float w = 1.0f;
            float h = 1.0f;
            if (scale != null) {
                w = (float)scale.w();
                h = (float)scale.h();
            }
            return Pair.of((Object)loc, (Object)new class_241(w, h));
        }
        return null;
    }

    private static String extractSoundCloudImage(String html) {
        String ts = html.substring(html.indexOf(SCT_IMG_ST) + SCT_IMG_ST.length());
        ts = ts.substring(0, ts.indexOf(SCT_IMG_END));
        ts = ts.substring(ts.indexOf(SCT_SRC_ST) + SCT_SRC_ST.length());
        ts = ts.substring(0, ts.indexOf(SCT_SRC_END));
        return ts;
    }
}

