/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.util;

import dev.felnull.imp.include.com.github.kiulian.downloader.YoutubeDownloader;
import dev.felnull.imp.include.com.github.kiulian.downloader.downloader.request.RequestPlaylistInfo;
import dev.felnull.imp.include.com.github.kiulian.downloader.downloader.request.RequestVideoInfo;
import dev.felnull.imp.include.com.github.kiulian.downloader.model.Extension;
import dev.felnull.imp.include.com.github.kiulian.downloader.model.playlist.PlaylistInfo;
import dev.felnull.imp.include.com.github.kiulian.downloader.model.videos.VideoInfo;
import dev.felnull.imp.include.com.github.kiulian.downloader.model.videos.formats.AudioFormat;
import dev.felnull.imp.include.com.github.kiulian.downloader.model.videos.formats.Format;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YoutubeUtil {
    private static final YoutubeDownloader youtubeDownloader = new YoutubeDownloader();
    private static final Map<String, URLCacheEntry> CACHE = new HashMap<String, URLCacheEntry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getYoutubeRawURL(String videoID) {
        Map<String, URLCacheEntry> map = CACHE;
        synchronized (map) {
            URLCacheEntry hit = CACHE.get(videoID);
            if (hit != null && (hit.url != null && System.currentTimeMillis() - hit.time < 600000L || hit.url == null && System.currentTimeMillis() - hit.time < 60000L)) {
                return hit.url();
            }
            VideoInfo video = youtubeDownloader.getVideoInfo(new RequestVideoInfo(videoID)).data();
            String url = null;
            if (!video.details().isLive()) {
                url = video.audioFormats().stream().filter(n -> n.extension() == Extension.WEBA).min(Comparator.comparingInt(AudioFormat::averageBitrate)).map(Format::url).orElse(null);
            }
            hit = new URLCacheEntry(System.currentTimeMillis(), url);
            CACHE.put(videoID, hit);
            return hit.url();
        }
    }

    public static PlaylistInfo getYoutubePlayList(String playListID) {
        return youtubeDownloader.getPlaylistInfo(new RequestPlaylistInfo(playListID)).data();
    }

    @Nullable
    public static String getPlayListID(@NotNull String value) {
        if (value.matches("[a-zA-Z0-9-_]+")) {
            return value;
        }
        if (!value.contains("list=")) {
            return null;
        }
        String[] split = value.split("list=");
        String v = split[1];
        if (!v.contains("&")) {
            return v;
        }
        return v.split("&")[0];
    }

    private record URLCacheEntry(long time, String url) {
    }
}

