/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.lava.extensions.youtuberotator.planner;

import dev.felnull.imp.include.com.sedmelluq.lava.extensions.youtuberotator.planner.AbstractRoutePlanner;
import dev.felnull.imp.include.com.sedmelluq.lava.extensions.youtuberotator.tools.Tuple;
import dev.felnull.imp.include.com.sedmelluq.lava.extensions.youtuberotator.tools.ip.IpBlock;
import dev.felnull.imp.include.com.sedmelluq.lava.extensions.youtuberotator.tools.ip.Ipv6Block;
import dev.felnull.imp.include.org.apache.http.HttpException;
import dev.felnull.imp.include.org.slf4j.Logger;
import dev.felnull.imp.include.org.slf4j.LoggerFactory;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;

public final class RotatingIpRoutePlanner
extends AbstractRoutePlanner {
    private static final Logger log = LoggerFactory.getLogger(RotatingIpRoutePlanner.class);
    private static final Random random = new Random();
    private final Predicate<InetAddress> ipFilter;
    private final AtomicBoolean next;
    private final AtomicReference<BigInteger> rotateIndex;
    private final AtomicReference<BigInteger> index;
    private volatile InetAddress lastFailingAddress;

    public RotatingIpRoutePlanner(List<IpBlock> ipBlocks) {
        this(ipBlocks, i -> true);
    }

    public RotatingIpRoutePlanner(List<IpBlock> ipBlocks, Predicate<InetAddress> ipFilter) {
        this(ipBlocks, ipFilter, true);
    }

    public RotatingIpRoutePlanner(List<IpBlock> ipBlocks, Predicate<InetAddress> ipFilter, boolean handleSearchFailure) {
        super(ipBlocks, handleSearchFailure);
        this.ipFilter = ipFilter;
        this.next = new AtomicBoolean(false);
        this.rotateIndex = new AtomicReference<BigInteger>(BigInteger.valueOf(0L));
        this.index = new AtomicReference<BigInteger>(BigInteger.valueOf(0L));
        this.lastFailingAddress = null;
    }

    public void next() {
        this.rotateIndex.accumulateAndGet(BigInteger.ONE, BigInteger::add);
        if (!this.next.compareAndSet(false, true)) {
            log.warn("Call to next() even when previous next() hasn't completed yet");
        }
    }

    public InetAddress getCurrentAddress() {
        if (this.index.get().compareTo(BigInteger.ZERO) == 0) {
            return null;
        }
        return this.ipBlock.getAddressAtIndex(this.index.get().subtract(BigInteger.ONE));
    }

    public BigInteger getIndex() {
        return this.index.get();
    }

    public BigInteger getRotateIndex() {
        return this.rotateIndex.get();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Tuple<InetAddress, InetAddress> determineAddressPair(Tuple<Inet4Address, Inet6Address> remoteAddresses) throws HttpException {
        void var2_9;
        void var2_7;
        InetAddress remoteAddress;
        Object var2_2 = null;
        if (this.ipBlock.getType() == Inet4Address.class) {
            if (remoteAddresses.l == null) throw new HttpException("Could not resolve host");
            if (this.index.get().compareTo(BigInteger.ZERO) == 0 || this.next.get()) {
                InetAddress inetAddress = this.extractLocalAddress();
                log.info("Selected " + inetAddress.toString() + " as new outgoing ip");
            }
            remoteAddress = (InetAddress)remoteAddresses.l;
        } else {
            if (this.ipBlock.getType() != Inet6Address.class) throw new HttpException("Unknown IpBlock type: " + this.ipBlock.getType().getCanonicalName());
            if (remoteAddresses.r != null) {
                if (this.index.get().compareTo(BigInteger.ZERO) == 0 || this.next.get()) {
                    InetAddress inetAddress = this.extractLocalAddress();
                    log.info("Selected " + inetAddress.toString() + " as new outgoing ip");
                }
                remoteAddress = (InetAddress)remoteAddresses.r;
            } else {
                if (remoteAddresses.l == null) throw new HttpException("Could not resolve host");
                remoteAddress = (InetAddress)remoteAddresses.l;
                log.warn("Could not look up AAAA record for host. Falling back to unbalanced IPv4.");
            }
        }
        if (var2_7 == null && this.index.get().compareTo(BigInteger.ZERO) > 0) {
            Object i = this.ipBlock.getAddressAtIndex(this.index.get().subtract(BigInteger.ONE));
        }
        this.next.set(false);
        return new Tuple<void, InetAddress>(var2_9, remoteAddress);
    }

    @Override
    protected void onAddressFailure(InetAddress address) {
        if (this.lastFailingAddress != null && this.lastFailingAddress.toString().equals(address.toString())) {
            log.warn("Address {} was already failing, not triggering next()", (Object)address.toString());
            return;
        }
        this.lastFailingAddress = address;
        this.next();
    }

    private InetAddress extractLocalAddress() {
        InetAddress localAddress;
        long triesSinceBlockSkip = 0L;
        BigInteger it = BigInteger.valueOf(0L);
        do {
            if (this.ipBlock.getSize().multiply(BigInteger.valueOf(2L)).compareTo(it) < 0) {
                throw new RuntimeException("Can't find a free ip");
            }
            if (this.ipBlock.getSize().compareTo(BigInteger.valueOf(128L)) > 0) {
                this.index.accumulateAndGet(BigInteger.valueOf(random.nextInt(10) + 10), BigInteger::add);
            } else {
                this.index.accumulateAndGet(BigInteger.ONE, BigInteger::add);
            }
            it = it.add(BigInteger.ONE);
            if (this.ipBlock.getSize().compareTo(Ipv6Block.BLOCK64_IPS) > 0 && ++triesSinceBlockSkip > 128L) {
                triesSinceBlockSkip = 0L;
                this.rotateIndex.accumulateAndGet(Ipv6Block.BLOCK64_IPS.add(BigInteger.valueOf(random.nextLong())), BigInteger::add);
            }
            try {
                localAddress = (InetAddress)this.ipBlock.getAddressAtIndex(this.index.get().subtract(BigInteger.ONE));
            }
            catch (Exception ex) {
                this.index.set(BigInteger.ZERO);
                localAddress = null;
            }
        } while (localAddress == null || !this.ipFilter.test(localAddress) || !this.isValidAddress(localAddress));
        return localAddress;
    }
}

