/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.render.entity.renderer;

import immersive_aircraft.Main;
import immersive_aircraft.client.render.entity.renderer.AircraftEntityRenderer;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.QuadrocopterEntity;
import immersive_aircraft.util.obj.Mesh;
import java.util.Random;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4588;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class QuadrocopterEntityRenderer<T extends QuadrocopterEntity>
extends AircraftEntityRenderer<T> {
    private static final class_2960 id = Main.locate("objects/quadrocopter.obj");
    private final class_2960 texture = Main.locate("textures/entity/quadrocopter.png");
    private final Random random = new Random();
    private static final float[][] PROPELLERS = new float[][]{{1.25f, 0.53125f, 0.65625f}, {-1.25f, 0.53125f, 0.65625f}, {1.25f, 0.53125f, -0.71875f}, {-1.25f, 0.53125f, -0.71875f}};
    private final AircraftEntityRenderer.Model model = new AircraftEntityRenderer.Model().add(new AircraftEntityRenderer.Object(id, "frame")).add(new AircraftEntityRenderer.Object(id, "engine").setAnimationConsumer((entity, yaw, tickDelta, matrixStack) -> {
        double p = (double)entity.enginePower.getSmooth() / 128.0;
        matrixStack.method_22904((this.random.nextDouble() - 0.5) * p, (this.random.nextDouble() - 0.5) * p, (this.random.nextDouble() - 0.5) * p);
    }).setRenderConsumer((vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
        class_2960 identifier = this.getTextureLocation(entity);
        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_23578((class_2960)identifier));
        Mesh mesh = QuadrocopterEntityRenderer.getFaces(id, "engine_" + ((double)entity.enginePower.getSmooth() > 0.01 ? entity.field_6012 % 2 : 0));
        QuadrocopterEntityRenderer.renderObject(mesh, matrixStack, vertexConsumer, light);
    }));

    public QuadrocopterEntityRenderer(class_5617.class_5618 context) {
        super(context);
        for (float[] propeller : PROPELLERS) {
            this.model.add(new AircraftEntityRenderer.Object(id, "propeller").setAnimationConsumer((entity, yaw, tickDelta, matrixStack) -> {
                matrixStack.method_46416(propeller[0], propeller[1], propeller[2]);
                matrixStack.method_22907(class_7833.field_40716.rotationDegrees(entity.engineRotation.getSmooth(tickDelta) * propeller[0] * propeller[2] * 200.0f));
            }).setRenderConsumer((vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
                class_2960 identifier = this.getTextureLocation(entity);
                class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_23578((class_2960)identifier));
                Mesh mesh = QuadrocopterEntityRenderer.getFaces(id, "propeller");
                QuadrocopterEntityRenderer.renderObject(mesh, matrixStack, vertexConsumer, light);
            }));
        }
        this.field_4673 = 0.8f;
    }

    public class_2960 getTextureLocation(@NotNull T entity) {
        return this.texture;
    }

    @Override
    protected AircraftEntityRenderer.Model getModel(AircraftEntity entity) {
        return this.model;
    }

    @Override
    protected Vector3f getPivot(AircraftEntity entity) {
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }
}

