/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import immersive_aircraft.Main;
import immersive_aircraft.item.upgrade.AircraftStat;
import immersive_aircraft.item.upgrade.AircraftUpgrade;
import immersive_aircraft.item.upgrade.AircraftUpgradeRegistry;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7923;

public class UpgradeDataLoader
extends class_4309 {
    public UpgradeDataLoader() {
        super(new Gson(), "aircraft_upgrades");
    }

    protected void apply(Map<class_2960, JsonElement> jsonMap, class_3300 manager, class_3695 profiler) {
        AircraftUpgradeRegistry.INSTANCE.reset();
        jsonMap.forEach((identifier, jsonElement) -> {
            try {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                if (class_7923.field_41178.method_10250(identifier)) {
                    class_1792 item = (class_1792)class_7923.field_41178.method_10223(identifier);
                    AircraftUpgrade upgrade = new AircraftUpgrade();
                    for (String key : jsonObject.keySet()) {
                        AircraftStat stat = AircraftUpgradeRegistry.STATS.get(key);
                        if (stat == null) continue;
                        upgrade.set(stat, jsonObject.get(key).getAsFloat());
                    }
                    AircraftUpgradeRegistry.INSTANCE.setUpgrade(item, upgrade);
                }
            }
            catch (JsonParseException | IllegalArgumentException exception) {
                Main.LOGGER.error("Parsing error on aircraft upgrade {}: {}", identifier, (Object)exception.getMessage());
            }
        });
    }
}

