/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity.misc;

import immersive_aircraft.util.Rect2iCommon;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;

public class VehicleInventoryDescription {
    int height = 0;
    int lastIndex = 0;
    int lastSyncIndex = 0;
    final List<Rect2iCommon> rectangles = new LinkedList<Rect2iCommon>();
    final EnumMap<SlotType, List<Slot>> slotMap = new EnumMap(SlotType.class);
    final List<Slot> slots = new LinkedList<Slot>();

    public VehicleInventoryDescription() {
        for (SlotType value : SlotType.values()) {
            this.slotMap.put(value, new LinkedList());
        }
    }

    public int getInventorySize() {
        return this.slots.size();
    }

    public List<Slot> getSlots() {
        return this.slots;
    }

    public List<Slot> getSlots(SlotType type) {
        return this.slotMap.get((Object)type);
    }

    public VehicleInventoryDescription addSlot(SlotType type, int x, int y) {
        Slot slot = new Slot(x, y, this.lastIndex++, type);
        this.slotMap.get((Object)type).add(slot);
        this.slots.add(slot);
        if (type != SlotType.INVENTORY) {
            this.lastSyncIndex = this.lastIndex;
        }
        return this;
    }

    public VehicleInventoryDescription addSlots(SlotType type, int x, int y, int cols, int rows) {
        for (int sx = 0; sx < cols; ++sx) {
            for (int sy = 0; sy < rows; ++sy) {
                this.addSlot(type, x + sx * 18, y + sy * 18);
            }
        }
        return this;
    }

    public VehicleInventoryDescription addBoxedSlots(SlotType type, int x, int y, int cols, int rows) {
        this.addSlots(type, x, y, cols, rows);
        return this.addRectangle(x - 8, y + 2, cols * 18 + 14, rows * 18 + 14);
    }

    public VehicleInventoryDescription addRectangle(int x, int y, int w, int h) {
        this.rectangles.add(new Rect2iCommon(x, y, w, h));
        return this;
    }

    public VehicleInventoryDescription build() {
        for (Slot slot : this.slots) {
            if (slot.x < 0 || slot.x >= 176) continue;
            this.height = Math.max(this.height, slot.y + 28);
        }
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public int getLastSyncIndex() {
        return this.lastSyncIndex;
    }

    public List<Rect2iCommon> getRectangles() {
        return this.rectangles;
    }

    public static enum SlotType {
        INVENTORY,
        BOILER,
        WEAPON,
        UPGRADE,
        BOOSTER,
        BANNER,
        DYE;

    }

    public static class Slot {
        public final int x;
        public final int y;
        public final int index;
        public final SlotType type;

        public Slot(int x, int y, int index, SlotType type) {
            this.x = x;
            this.y = y;
            this.index = index;
            this.type = type;
        }
    }
}

