/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.flora.flora.gen;

import com.dfsek.terra.addons.flora.flora.gen.BlockLayer;
import com.dfsek.terra.addons.flora.lib.jafama.FastMath;
import com.dfsek.terra.api.block.state.BlockState;
import com.dfsek.terra.api.block.state.properties.enums.Direction;
import com.dfsek.terra.api.noise.NoiseSampler;
import com.dfsek.terra.api.structure.Structure;
import com.dfsek.terra.api.util.Rotation;
import com.dfsek.terra.api.util.collection.MaterialSet;
import com.dfsek.terra.api.util.collection.ProbabilityCollection;
import com.dfsek.terra.api.util.vector.Vector3Int;
import com.dfsek.terra.api.world.WritableWorld;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;

public class TerraFlora
implements Structure {
    private final List<ProbabilityCollection<BlockState>> layers;
    private final boolean physics;
    private final boolean ceiling;
    private final MaterialSet testRotation;
    private final NoiseSampler distribution;
    private final String id;

    public TerraFlora(List<BlockLayer> layers, boolean physics, boolean ceiling, MaterialSet testRotation, NoiseSampler distribution, String id) {
        this.physics = physics;
        this.testRotation = testRotation;
        this.ceiling = ceiling;
        this.distribution = distribution;
        this.id = id;
        this.layers = new ArrayList<ProbabilityCollection<BlockState>>();
        layers.forEach(layer -> {
            for (int i = 0; i < layer.getLayers(); ++i) {
                this.layers.add(layer.getBlocks());
            }
        });
    }

    private void test(EnumSet<Direction> faces, Direction f, Vector3Int b, WritableWorld world) {
        if (this.testRotation.contains((Object)world.getBlockState(b.getX() + f.getModX(), b.getY() + f.getModY(), b.getZ() + f.getModZ()).getBlockType())) {
            faces.add(f);
        }
    }

    private ProbabilityCollection<BlockState> getStateCollection(int layer) {
        return this.layers.get(FastMath.max(FastMath.min(layer, this.layers.size() - 1), 0));
    }

    private EnumSet<Direction> getFaces(Vector3Int b, WritableWorld world) {
        EnumSet<Direction> faces = EnumSet.noneOf(Direction.class);
        this.test(faces, Direction.NORTH, b, world);
        this.test(faces, Direction.SOUTH, b, world);
        this.test(faces, Direction.EAST, b, world);
        this.test(faces, Direction.WEST, b, world);
        return faces;
    }

    public boolean generate(Vector3Int location, WritableWorld world, Random random, Rotation rotation) {
        EnumSet<Direction> faces;
        boolean doRotation = this.testRotation.size() > 0;
        int size = this.layers.size();
        int c = this.ceiling ? -1 : 1;
        EnumSet<Direction> enumSet = faces = doRotation ? this.getFaces(location.mutable().add(0, c, 0).immutable(), world) : EnumSet.noneOf(Direction.class);
        if (doRotation && faces.size() == 0) {
            return false;
        }
        int i = 0;
        while (FastMath.abs(i) < size) {
            int lvl = FastMath.abs(i);
            BlockState data = (BlockState)this.getStateCollection(this.ceiling ? lvl : size - lvl - 1).get(this.distribution, (double)location.getX(), (double)location.getY(), (double)location.getZ(), world.getSeed());
            if (doRotation) {
                Direction direction = new ArrayList<Direction>(faces).get(new Random(location.getX() ^ location.getZ()).nextInt(faces.size()));
            }
            world.setBlockState(location.mutable().add(0, i + c, 0).immutable(), data, this.physics);
            i += c;
        }
        return true;
    }
}

