/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.sponge;

import com.dfsek.terra.addons.manifest.api.AddonInitializer;
import com.dfsek.terra.addons.sponge.SpongeStructure;
import com.dfsek.terra.api.Platform;
import com.dfsek.terra.api.addon.BaseAddon;
import com.dfsek.terra.api.block.state.BlockState;
import com.dfsek.terra.api.event.events.config.pack.ConfigPackPreLoadEvent;
import com.dfsek.terra.api.event.functional.FunctionalEventHandler;
import com.dfsek.terra.api.inject.annotations.Inject;
import com.dfsek.terra.api.registry.CheckedRegistry;
import com.dfsek.terra.api.structure.Structure;
import com.dfsek.terra.api.util.StringUtil;
import com.dfsek.terra.api.util.vector.Vector3Int;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import net.querz.nbt.io.NBTDeserializer;
import net.querz.nbt.tag.ByteArrayTag;
import net.querz.nbt.tag.CompoundTag;
import net.querz.nbt.tag.IntTag;
import net.querz.nbt.tag.Tag;

public class SpongeSchematicAddon
implements AddonInitializer {
    @Inject
    private Platform platform;
    @Inject
    private BaseAddon addon;

    private static InputStream detectDecompression(InputStream is) throws IOException {
        PushbackInputStream pbis = new PushbackInputStream(is, 2);
        int signature = (pbis.read() & 0xFF) + (pbis.read() << 8);
        pbis.unread(signature >> 8);
        pbis.unread(signature & 0xFF);
        if (signature == 35615) {
            return new GZIPInputStream(pbis);
        }
        return pbis;
    }

    public void initialize() {
        ((FunctionalEventHandler)this.platform.getEventManager().getHandler(FunctionalEventHandler.class)).register(this.addon, ConfigPackPreLoadEvent.class).then(event -> {
            CheckedRegistry structureRegistry = event.getPack().getOrCreateRegistry(Structure.class);
            event.getPack().getLoader().open("", ".schem").thenEntries(entries -> entries.stream().map(entry -> this.convert((InputStream)entry.getValue(), StringUtil.fileName((String)((String)entry.getKey())))).forEach(arg_0 -> ((CheckedRegistry)structureRegistry).register(arg_0))).close();
        }).failThrough();
    }

    public SpongeStructure convert(InputStream in, String id) {
        try {
            CompoundTag baseTag = (CompoundTag)new NBTDeserializer(false).fromStream(SpongeSchematicAddon.detectDecompression(in)).getTag();
            int ver = baseTag.getInt("Version");
            int wid = baseTag.getShort("Width");
            int len = baseTag.getShort("Length");
            int hei = baseTag.getShort("Height");
            CompoundTag metadata = baseTag.getCompoundTag("Metadata");
            Vector3Int offset = switch (ver) {
                case 2 -> {
                    IntTag worldEditOffsetX = metadata.getIntTag("WEOffsetX");
                    IntTag worldEditOffsetY = metadata.getIntTag("WEOffsetY");
                    IntTag worldEditOffsetZ = metadata.getIntTag("WEOffsetZ");
                    if (worldEditOffsetX != null || worldEditOffsetY != null || worldEditOffsetZ != null) {
                        if (worldEditOffsetX == null || worldEditOffsetY == null || worldEditOffsetZ == null) {
                            throw new IllegalArgumentException("Failed to parse Sponge schematic: Malformed WorldEdit offset");
                        }
                        yield Vector3Int.of((int)worldEditOffsetX.asInt(), (int)worldEditOffsetY.asInt(), (int)worldEditOffsetZ.asInt());
                    }
                    yield Vector3Int.zero();
                }
                case 3 -> {
                    int[] offsetArray = baseTag.getIntArray("Offset");
                    yield Vector3Int.of((int)offsetArray[0], (int)offsetArray[1], (int)offsetArray[2]);
                }
                default -> throw new IllegalArgumentException("Failed to parse Sponge schematic: Unsupported format version: " + ver);
            };
            ByteArrayTag blocks = baseTag.getByteArrayTag("BlockData");
            CompoundTag palette = (CompoundTag)baseTag.get("Palette");
            HashMap<Integer, String> data = new HashMap<Integer, String>();
            for (Map.Entry<String, Tag<?>> entry : palette.entrySet()) {
                data.put(((IntTag)entry.getValue()).asInt(), entry.getKey());
            }
            BlockState[][][] states = new BlockState[wid][len][hei];
            byte[] arr = (byte[])blocks.getValue();
            for (int x = 0; x < wid; ++x) {
                for (int z = 0; z < len; ++z) {
                    for (int y = 0; y < hei; ++y) {
                        String block = (String)data.get(arr[x + z * wid + y * wid * len]);
                        if (block.startsWith("minecraft:structure_void")) continue;
                        states[x][z][y] = this.platform.getWorldHandle().createBlockState(block);
                    }
                }
            }
            return new SpongeStructure(states, offset, this.addon.key(id));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to parse Sponge schematic: ", e);
        }
    }
}

