/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.sponge;

import com.dfsek.terra.api.block.state.BlockState;
import com.dfsek.terra.api.registry.key.Keyed;
import com.dfsek.terra.api.registry.key.RegistryKey;
import com.dfsek.terra.api.structure.Structure;
import com.dfsek.terra.api.util.Rotation;
import com.dfsek.terra.api.util.vector.Vector2Int;
import com.dfsek.terra.api.util.vector.Vector3Int;
import com.dfsek.terra.api.world.WritableWorld;
import java.util.Random;

public class SpongeStructure
implements Structure,
Keyed<SpongeStructure> {
    private final BlockState[][][] blocks;
    private final int offsetX;
    private final int offsetY;
    private final int offsetZ;
    private final RegistryKey id;

    public SpongeStructure(BlockState[][][] blocks, Vector3Int offset, RegistryKey id) {
        this.blocks = blocks;
        this.offsetX = offset.getX();
        this.offsetY = offset.getY();
        this.offsetZ = offset.getZ();
        this.id = id;
    }

    public boolean generate(Vector3Int location, WritableWorld world, Random random, Rotation rotation) {
        int bX = location.getX();
        int bY = location.getY();
        int bZ = location.getZ();
        for (int x = 0; x < this.blocks.length; ++x) {
            for (int z = 0; z < this.blocks[x].length; ++z) {
                int oX = x + this.offsetX;
                int oZ = z + this.offsetZ;
                Vector2Int r = Vector2Int.of((int)oX, (int)oZ).rotate(rotation);
                int rX = r.getX();
                int rZ = r.getZ();
                for (int y = 0; y < this.blocks[x][z].length; ++y) {
                    BlockState state = this.blocks[x][z][y];
                    if (state == null) continue;
                    world.setBlockState(bX + rX, bY + y + this.offsetY, bZ + rZ, state);
                }
            }
        }
        return true;
    }

    public RegistryKey getRegistryKey() {
        return this.id;
    }
}

