/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.things;

import com.github.crimsondawn45.fabricshieldlib.lib.object.FabricShield;
import com.glisco.things.ThingsNetwork;
import com.glisco.things.blocks.ThingsBlocks;
import com.glisco.things.enchantments.RetributionEnchantment;
import com.glisco.things.items.ThingsItems;
import com.glisco.things.misc.AgglomerateRecipe;
import com.glisco.things.misc.AnAmazinglyExpensiveMistakeCriterion;
import com.glisco.things.misc.DisplacementTomeScreenHandler;
import com.glisco.things.misc.JumpySocksRecipe;
import com.glisco.things.misc.MomentumStatusEffect;
import com.glisco.things.misc.SockDataComponent;
import com.glisco.things.misc.SockUpgradeRecipe;
import com.glisco.things.misc.ThingsConfig;
import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistry;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentInitializer;
import dev.onyxstudios.cca.api.v3.entity.RespawnCopyStrategy;
import io.wispforest.owo.Owo;
import io.wispforest.owo.itemgroup.Icon;
import io.wispforest.owo.itemgroup.OwoItemGroup;
import io.wispforest.owo.particles.ClientParticles;
import io.wispforest.owo.particles.systems.ParticleSystem;
import io.wispforest.owo.particles.systems.ParticleSystemController;
import io.wispforest.owo.registration.reflect.FieldRegistrationHandler;
import io.wispforest.owo.util.Maldenhagen;
import java.util.Set;
import java.util.function.Predicate;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1291;
import net.minecraft.class_1309;
import net.minecraft.class_174;
import net.minecraft.class_179;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1819;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_5321;
import net.minecraft.class_6796;
import net.minecraft.class_6862;
import net.minecraft.class_6908;
import net.minecraft.class_7701;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class Things
implements ModInitializer,
EntityComponentInitializer {
    public static final String MOD_ID = "things";
    public static final ThingsConfig CONFIG = ThingsConfig.createAndLoad();
    public static final OwoItemGroup THINGS_GROUP = OwoItemGroup.builder((class_2960)new class_2960("things", "things"), () -> Icon.of((class_1935)ThingsItems.BATER_WUCKET)).build();
    public static final class_1887 RETRIBUTION = new RetributionEnchantment();
    public static final class_1291 MOMENTUM = new MomentumStatusEffect();
    public static final AnAmazinglyExpensiveMistakeCriterion AN_AMAZINGLY_EXPENSIVE_MISTAKE_CRITERION = new AnAmazinglyExpensiveMistakeCriterion();
    public static final ComponentKey<SockDataComponent> SOCK_DATA = ComponentRegistry.getOrCreate((class_2960)Things.id("sock_data"), SockDataComponent.class);
    public static final class_3917<DisplacementTomeScreenHandler> DISPLACEMENT_TOME_SCREEN_HANDLER = new class_3917(DisplacementTomeScreenHandler::new, class_7701.field_40183);
    private static final class_5321<class_6796> GLEAMING_ORE = class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)Things.id("ore_gleaming"));
    public static final class_6862<class_1792> HARDENING_CATALYST_BLACKLIST = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Things.id("hardening_catalyst_blacklist"));
    public static final class_6862<class_1792> AGGLOMERATION_BLACKLIST = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Things.id("agglomeration_blacklist"));
    public static final class_6862<class_1792> DISPLACEMENT_TOME_FUELS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Things.id("displacement_tome_fuels"));
    private static Predicate<class_1792> SHIELD_PREDICATE = item -> item instanceof class_1819;
    private static Set<class_1792> BROKEN_WATCH_RECIPE;
    private static final ParticleSystemController CONTROLLER;
    public static final ParticleSystem<Void> TOGGLE_JUMP_BOOST_PARTICLES;

    public void onInitialize() {
        FieldRegistrationHandler.register(ThingsItems.class, (String)MOD_ID, (boolean)false);
        FieldRegistrationHandler.register(ThingsBlocks.class, (String)MOD_ID, (boolean)false);
        class_2378.method_10230((class_2378)class_7923.field_41176, (class_2960)Things.id("retribution"), (Object)RETRIBUTION);
        if (CONFIG.generateGleamingOre()) {
            BiomeModifications.addFeature(Things.overworldSelector(), (class_2893.class_2895)class_2893.class_2895.field_13176, GLEAMING_ORE);
            Maldenhagen.injectCopium((class_2248)ThingsBlocks.GLEAMING_ORE);
        }
        class_2378.method_10230((class_2378)class_7923.field_41188, (class_2960)Things.id("sock_upgrade_crafting"), (Object)SockUpgradeRecipe.Type.INSTANCE);
        class_2378.method_10230((class_2378)class_7923.field_41189, (class_2960)Things.id("sock_upgrade_crafting"), (Object)((Object)SockUpgradeRecipe.Serializer.INSTANCE));
        class_2378.method_10230((class_2378)class_7923.field_41188, (class_2960)Things.id("jumpy_sock_crafting"), (Object)JumpySocksRecipe.Type.INSTANCE);
        class_2378.method_10230((class_2378)class_7923.field_41189, (class_2960)Things.id("jumpy_sock_crafting"), (Object)((Object)JumpySocksRecipe.Serializer.INSTANCE));
        class_2378.method_10230((class_2378)class_7923.field_41189, (class_2960)Things.id("agglomerate"), (Object)((Object)AgglomerateRecipe.Serializer.INSTANCE));
        class_2378.method_10230((class_2378)class_7923.field_41174, (class_2960)Things.id("momentum"), (Object)MOMENTUM);
        class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)Things.id("displacement_tome"), DISPLACEMENT_TOME_SCREEN_HANDLER);
        class_174.method_767((class_179)AN_AMAZINGLY_EXPENSIVE_MISTAKE_CRITERION);
        ThingsNetwork.init();
        THINGS_GROUP.initialize();
        if (FabricLoader.getInstance().isModLoaded("fabricshieldlib")) {
            SHIELD_PREDICATE = SHIELD_PREDICATE.or(item -> item instanceof FabricShield);
        }
        ResourceConditions.register((class_2960)Things.id("agglomeration_enabled"), jsonObject -> CONFIG.enableAgglomeration());
        BROKEN_WATCH_RECIPE = ImmutableSet.of((Object)class_1802.field_8745, (Object)class_1802.field_8557, (Object)ThingsItems.GLEAMING_COMPOUND);
        if (Owo.DEBUG) {
            CommandRegistrationCallback.EVENT.register((dispatcher, access, environment) -> dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"things:set_walk_speed_modifier").then(class_2170.method_9244((String)"speed", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> {
                float speed = FloatArgumentType.getFloat((CommandContext)context, (String)"speed");
                ((SockDataComponent)SOCK_DATA.get((Object)((class_2168)context.getSource()).method_44023())).setModifier(speed);
                return 0;
            }))));
        }
    }

    public static Predicate<BiomeSelectionContext> overworldSelector() {
        return context -> context.getBiomeRegistryEntry().method_40220(class_6908.field_37393);
    }

    public static boolean isShield(class_1792 item) {
        return SHIELD_PREDICATE.test(item);
    }

    public static Set<class_1792> brokenWatchRecipe() {
        return BROKEN_WATCH_RECIPE;
    }

    public static TrinketComponent getTrinkets(class_1309 entity) {
        return (TrinketComponent)TrinketsApi.getTrinketComponent((class_1309)entity).get();
    }

    public static boolean hasTrinket(class_1309 entity, class_1792 trinket) {
        return Things.getTrinkets(entity).isEquipped(trinket);
    }

    public static class_2960 id(String path) {
        return new class_2960(MOD_ID, path);
    }

    public void registerEntityComponentFactories(EntityComponentFactoryRegistry registry) {
        registry.registerForPlayers(SOCK_DATA, SockDataComponent::new, RespawnCopyStrategy.NEVER_COPY);
    }

    static {
        CONTROLLER = new ParticleSystemController(Things.id("particles"));
        TOGGLE_JUMP_BOOST_PARTICLES = CONTROLLER.register(Void.class, (world, pos, data) -> {
            ClientParticles.setParticleCount((int)25);
            ClientParticles.spawnPrecise((class_2394)class_2398.field_29643, (class_1937)world, (class_243)pos.method_1031(0.0, 1.0, 0.0), (double)1.0, (double)2.0, (double)1.0);
        });
    }
}

