/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.eventbus;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import me.lucko.luckperms.lib.eventbus.EventSubscriber;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class PostResult {
    private static final PostResult SUCCESS = new PostResult(Collections.emptyMap());
    private final Map<EventSubscriber<?>, Throwable> exceptions;

    public static @NonNull PostResult success() {
        return SUCCESS;
    }

    public static @NonNull PostResult failure(@NonNull Map<EventSubscriber<?>, Throwable> exceptions) {
        Preconditions.checkState((!exceptions.isEmpty() ? 1 : 0) != 0, (Object)"no exceptions present");
        return new PostResult((Map<EventSubscriber<?>, Throwable>)ImmutableMap.copyOf(exceptions));
    }

    private PostResult(@NonNull Map<EventSubscriber<?>, Throwable> exceptions) {
        this.exceptions = exceptions;
    }

    public boolean wasSuccessful() {
        return this.exceptions.isEmpty();
    }

    public @NonNull Map<EventSubscriber<?>, Throwable> exceptions() {
        return this.exceptions;
    }

    public void raise() throws CompositeException {
        if (!this.wasSuccessful()) {
            throw new CompositeException(this);
        }
    }

    public String toString() {
        if (this.wasSuccessful()) {
            return MoreObjects.toStringHelper((Object)this).add("type", (Object)"success").toString();
        }
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)"failure").add("exceptions", this.exceptions().values()).toString();
    }

    public static final class CompositeException
    extends Exception {
        private final PostResult result;

        CompositeException(@NonNull PostResult result) {
            super("Exceptions occurred whilst posting to subscribers");
            this.result = result;
        }

        public @NonNull PostResult result() {
            return this.result;
        }

        public void printAllStackTraces() {
            this.printStackTrace();
            for (Throwable exception : this.result.exceptions().values()) {
                exception.printStackTrace();
            }
        }
    }
}

